<?php $image_url = $image_width = $image_height = '';
if ( has_post_thumbnail( get_the_ID() ) ) {
	$image_id     = get_post_thumbnail_id( get_the_ID() );
	$image_size   = apply_filters( 'lifeshine_page_schema_image_size', 'medium' );
	$image        = wp_get_attachment_image_src( $image_id, 'medium' );
	$image_url    = $image[0];
	$image_width  = $image[1];
	$image_height = $image[2];
}
?>
<link itemscope itemprop="mainEntityOfPage" href="<?php echo esc_url( get_the_permalink() ); ?>">
<?php if ( ! empty( $image_url ) ) : ?>
	<div itemprop="image" itemscope itemtype="https://schema.org/ImageObject">
		<meta itemprop="url" content="<?php echo esc_url( $image_url ); ?>">
		<meta itemprop="width" content="<?php echo esc_attr( $image_width ); ?>">
		<meta itemprop="height" content="<?php echo esc_attr( $image_height ); ?>">
	</div>
<?php endif; ?>
<div itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
	<?php if ( ! empty( $logo_url = talemy_get_option( 'logo' )  ) ) : ?>
	<div itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">
		<meta itemprop="url" content="<?php echo esc_url( $logo_url ); ?>">
	</div>
	<?php endif; ?>
	<meta itemprop="name" content="<?php bloginfo( 'name' ); ?>">
</div>