<?php
if ( ! talemy_get_option( 'post_adjacent' ) ) {
	return;
}
$in_same_term = talemy_get_option( 'post_adjacent_same_term' );
$prev         = get_previous_post( $in_same_term );
$next         = get_next_post( $in_same_term );

if ( empty( $prev ) && empty( $next ) ) {
	return;
}
?>
<div class="post-adjacent">
	<div class="row">
		<div class="col-sm-6 position-relative">
		<?php if ( ! empty( $prev ) ) : ?>
			<a class="previous-post" href="<?php echo esc_url( get_permalink( $prev->ID ) ); ?>">
				<span><?php echo esc_html_e( 'Previous Post', 'talemy' ); ?></span>
				<h4 class="post-title"><?php echo wp_kses_post( $prev->post_title ); ?></h4>
				<i class="fas fa-long-arrow-alt-left"></i>
			</a>
		<?php endif; ?>
		</div>
		<div class="col-sm-6 position-relative">
		<?php if ( ! empty( $next ) ) : ?>
			<a class="next-post" href="<?php echo esc_url( get_permalink( $next->ID ) ); ?>">
				<span><?php echo esc_html_e( 'Next Post', 'talemy' ); ?></span>
				<h4 class="post-title"><?php echo wp_kses_post( $next->post_title ); ?></h4>
				<i class="fas fa-long-arrow-alt-right"></i>
			</a>
		<?php endif; ?>
		</div>
	</div>
</div>
