<?php
$course_id         = get_the_ID();
$course            = new LLMS_Course( $course_id );
$enrollment_status = '';
$course_meta_info  = do_shortcode( '[lifterlms_course_meta_info]' );
$sidebar_id		   = talemy_get_setting( 'sidebar', 'default-sidebar' );

if ( is_user_logged_in() ) {
	$student = llms_get_student( get_current_user_id() );
	if ( $student ) {
		$enrollment_status = $student->get_enrollment_status( $course_id );
	}
}
?>
<aside class="sidebar sticky-sidebar">
	<div class="sidebar-inner">
		<div class="course-sidebar">
			<div class="course-sidebar__inner">

				<?php do_action( 'talemy_course_sidebar_start' ); ?>

					<div class="course-sidebar__price">
					</div><!-- .course-sidebar__price -->

				<div class="course-sidebar__buttons">
					
					<?php do_action( 'talemy_course_sidebar_buttons_start' );

					if ( 'enrolled' === $enrollment_status ) {
						echo do_shortcode( '[lifterlms_course_continue]' );
					} else {
						echo talemy_get_llms_access_plan_button();
					} 

					do_action( 'talemy_course_sidebar_buttons_end' ); ?>

				</div><!-- .course-sidebar__buttons -->

				<?php if ( ! empty( $course_meta_info ) ) : ?>	
					<div class="course-sidebar__info">
						<h3><?php esc_html_e( 'Course Information', 'talemy' ); ?></h3>
						<?php echo wp_kses_post( $course_meta_info ); ?>
					</div>
				<?php endif; ?>

				<?php if ( talemy_get_option( 'ld_course_share' ) ) : ?>
					<div class="course-sidebar__share">
						<button class="btn btn-block" id="course-sidebar__share-btn">
							<span class="btn-text-wrapper">
								<span class="btn-icon btn-align-icon-right"><i class="fas fa-share"></i></span>
								<span class="btn-text"><?php esc_html_e( 'Share', 'talemy' ); ?></span>
							</span>
						</button>
						<?php do_action( 'sf_post_share_buttons' ); ?>
					</div><!-- .course-sidebar__share -->
				<?php endif; ?>

				<?php do_action( 'talemy_course_sidebar_end' ); ?>

			</div><!-- .course-sidebar__inner -->
		</div><!-- .course-sidebar -->
		<?php if ( is_active_sidebar( $sidebar_id ) ) : ?>
		<?php dynamic_sidebar( $sidebar_id ); ?>
		<?php endif; ?>
	</div><!-- .sidebar-inner -->
</aside><!-- .sidebar -->