<?php

$sections_layout  = talemy_get_option( 'ld_course_sections_layout' );
$course_sections  = [];
$custom_sections  = talemy_get_option( 'ld_course_sections' );
$default_sections = array(
    'overview' => talemy_get_option( 'ld_course_section_title_overview' ),
    'curriculum' => talemy_get_option( 'ld_course_section_title_curriculum' ),
    'instructors' => talemy_get_option( 'ld_course_section_title_instructors' ),
    'reviews' => talemy_get_option( 'ld_course_section_title_reviews' )
);

foreach ( $custom_sections as $section ) {
    if ( isset( $default_sections[ $section ] ) ) {
        $course_sections[ $section ] = $default_sections[ $section ];
    }
}

$sections = apply_filters( 'talemy_course_sections', $course_sections );

if ( empty( $sections ) ) {
    return;
}

remove_action( 'lifterlms_single_course_after_summary', 'lifterlms_template_single_reviews', 100 );
$reviews_enabled = ( get_post_meta( get_the_ID(), '_llms_reviews_enabled', true ) && is_user_logged_in() );
?>
<?php if ( 'tabs' == $sections_layout ) : ?>
    
    <ul class="course-tabs">

        <?php foreach ( $sections as $section => $section_title ) : ?>

            <li><a class="course-tab" href="<?php echo esc_attr( '#course-section__'. $section ); ?>"><?php echo esc_html( $section_title ); ?></a></li>

        <?php endforeach; ?>

    </ul>

<?php endif; ?>

<div class="course-sections course-sections--layout-<?php echo esc_attr( $sections_layout ); ?>">
    
    <?php foreach ( $sections as $section => $section_title ) : ?>

        <?php if ( 'toggles' === $sections_layout ) : ?>

            <h4 class="course-section__title"><a href="<?php echo esc_attr( '#course-section__'. $section ); ?>"><?php echo esc_html( $section_title ); ?></a></h4>

        <?php endif; ?>
        
        <?php if ( 'overview' == $section ) : ?>
        
            <div class="course-section" id="course-section__overview">
                <div class="content">
                    <?php the_content(); ?>
                </div>
            </div>
        
        <?php elseif ( 'curriculum' == $section ) : ?>

            <div class="course-section" id="course-section__curriculum">
                <?php echo do_shortcode( '[lifterlms_course_syllabus]' ); ?>
            </div>

        <?php elseif ( 'instructors' == $section ) : ?>
            
            <div class="course-section" id="course-section__instructors">
                <h3><?php esc_html_e( 'About the Instructors', 'talemy' ); ?></h3>
                <?php
                $course = new LLMS_Course( get_the_ID() );
                $instructors = $course->get_instructors( true );
                if ( $instructors ) {
                    echo '<div class="author-boxes">';
                    foreach ( $instructors as $instructor ) {
                        echo talemy_get_llms_author_box( [
                            'avatar_size' => 72,
                            'label'       => $instructor['label'],
                            'user_id'     => $instructor['id']
                        ] );
                    }
                    echo '</div>';
                }
                ?>
            </div>
        
        <?php elseif ( 'reviews' == $section ) : ?>
            
            <?php if ( $reviews_enabled ) : ?>
                <div class="course-section" id="course-section__reviews">
                    <?php echo do_shortcode( '[lifterlms_course_reviews]' ); ?> 
                </div>
            <?php endif; ?>
        
        <?php else : ?>
        
            <div class="course-section" id="<?php echo esc_attr( 'course-section__'. $section ); ?>"><?php do_action( 'talemy_course_section_'. $section, $course_id ); ?></div>
        
        <?php endif; ?>

    <?php endforeach; ?>

</div>
