<?php
if ( ! talemy_get_option( 'ld_course_related' ) ) {
	return;
}

$course_id    = get_the_ID();
$post_count   = talemy_get_option( 'ld_course_related_count' );
$related_type = talemy_get_option( 'ld_course_related_type' );
$query_args   = [
	'post_type'           => 'course',
	'post_status'         => 'publish',
	'posts_per_page'      => $post_count,
	'post__not_in'        => [ $course_id ],
	'ignore_sticky_posts' => 1,
	'not_found_rows'      => 1,
];

switch ( $related_type ) {

case 'cat':
	$cats = wp_get_post_terms( $course_id, 'course_cat', [ 'fields' => 'ids' ] );
	if ( ! empty( $cats ) ) {
		$query_args['tax_query'] = [
			'relation' => 'OR',
			[
				'taxonomy' => 'course_cat',
				'field'    => 'id',
				'terms'    => $cats,
			],
		];
	}
	break;

case 'tag':
	$tags = wp_get_post_terms( $course_id, 'course_tag', [ 'fields' => 'ids' ] );
	if ( ! empty( $tags ) ) {
		$query_args['tax_query'] = [
			'relation' => 'OR',
			[
				'taxonomy' => 'course_tag',
				'field'    => 'id',
				'terms'    => $tags,
			],
		];
	}
	break;

case 'author':
	$query_args['author__in'] = get_the_author_meta( 'ID' );
	break;

case 'cat_or_tag':
	$cats                    = wp_get_post_terms( $course_id, 'course_cat', [ 'fields' => 'ids' ] );
	$tags                    = wp_get_post_terms( $course_id, 'course_tag', [ 'fields' => 'ids' ] );
	$query_args['tax_query'] = [
		'relation' => 'OR',
		[
			'taxonomy' => 'course_cat',
			'field'    => 'id',
			'terms'    => $cats,
		],
		[
			'taxonomy' => 'course_tag',
			'field'    => 'id',
			'terms'    => $tags,
		],
	];
	break;

case 'random':
	$query_args['orderby'] = 'rand';
	break;
}

$query_args = apply_filters( 'talemy_related_courses_query_args', $query_args );
$query 		= new WP_Query( $query_args );

if ( $query->have_posts() ) :
talemy_set_setting( 'post_class', 'loop-post post-style-grid' );
talemy_set_setting( 'grid_meta_data', talemy_get_option( 'ld_courses_meta_data' ) );
?>
<div class="post-related ld-related-courses">
	<h3 class="section-heading sh-2">
		<span class="title"><?php echo apply_filters( 'talemy_related_courses_title', esc_html__( 'You may also like', 'talemy' ) ); ?></span>
	</h3>
	<div class="post-list row columns-3 tablet-columns-3 mobile-columns-1">
	<?php
	while ( $query->have_posts() ):
		$query->the_post();
		get_template_part( 'templates/lifterlms/loop/course/'. talemy_get_option( 'ld_courses_list_style' ) );
	endwhile;
	?>
	</div>
</div>
<?php
endif;
wp_reset_postdata();