<?php

get_template_part( 'templates/lifterlms/single/focus/header' );

if ( is_singular( 'llms_quiz' ) || is_singular( 'llms_assignment' ) ) {
	$assignment = llms_get_post( get_the_ID() );
	$lesson_id  = $assignment->get( 'lesson_id' );
	$post       = get_post( $lesson_id );
} else {
	global $post;
}
$lesson             = new LLMS_Lesson( $post );
$lesson_id          = $post->ID;
$course_id          = $lesson->get_parent_course();
$course             = new LLMS_Course( $course_id );
$sections           = $course->get_sections();
$lesson_ids         = $course->get_lessons( 'ids' );
$total_lessons      = count( $lesson_ids );
$lesson_index       = array_search( $lesson_id, $lesson_ids );
$parent_course_link = get_permalink( $course_id );

remove_action( 'lifterlms_single_lesson_before_summary', 'lifterlms_template_single_parent_course' );

do_action( 'talemy_content_start' );
?>
<div class="course-focus focus-sidebar-active">
	<div class="course-focus__sidebar">
		<div class="focus-navigation__heading">
			<h3 class="focus-navigation__title">
				<a title="<?php echo get_the_title( $course_id ); ?>" href="<?php echo esc_url( $parent_course_link ); ?>"><?php echo get_the_title( $course_id ); ?></a>
			</h3>
		</div>
		<div class="focus-navigation">
			<div class="llms-syllabus-wrapper">
				<?php if ( ! $sections ) : ?>
					<?php esc_html_e( 'This course does not have any sections.', 'talemy' ); ?>
				<?php else : ?>
					<?php foreach ( $sections as $section ) : ?>
						<?php if ( apply_filters( 'llms_display_outline_section_titles', true ) ) : ?>
							<h3 class="llms-h3 llms-section-title"><?php echo get_the_title( $section->get( 'id' ) ); ?></h3>
						<?php endif;
						$lessons = $section->get_lessons();
						if ( $lessons ) :
							foreach ( $lessons as $lesson ) :
								llms_get_template(
									'course/lesson-preview.php',
									[
										'lesson'        => $lesson,
										'total_lessons' => count( $lessons ),
										'context'		=> 'focus_navigation'
									]
								);
							endforeach;
						else :
							?>
							<div class="llms-lesson-preview">
							<div class="llms-lesson-link">
								<?php esc_html_e( 'This section does not have any lessons.', 'talemy' ); ?>
							</div>
						</div>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<div class="course-focus__main">
		<div class="course-focus__header">
			<nav class="nav">
				<?php get_template_part( 'templates/header/nav-logo' ); ?>
				<div class="nav-inner-wrapper">
					<?php echo do_shortcode( '[lifterlms_course_progress check_enrollment="false"]' ); ?>
				</div>
				<div class="nav-btns">
					<?php
					if ( is_user_logged_in() ) :
					$user_id   = get_current_user_id();
					$user_data = get_userdata( $user_id );
					?>
					<div class="nav-item-wrap dropdown-open-on-hover">
						<a href="javascript:void(0)" class="nav-btn btn-login btn-has-dropdown"><span><?php echo esc_html( $user_data->user_nicename ); ?></span><?php echo get_avatar( $user_id, 24 ); ?></a>
						<div class="nav-dropdown account-dropdown">
							<?php do_action( 'talemy_before_account_menu', $user_data ); ?>
							<?php talemy_account_menu(); ?>
							<?php do_action( 'talemy_after_account_menu', $user_data ); ?>
							<a class="account-logout-link" href="<?php echo wp_logout_url( home_url() ); ?>" title="<?php esc_attr_e( 'Log Out', 'talemy' ); ?>"><span><?php esc_html_e( 'Log Out', 'talemy' ); ?></span></a>
						</div>
					</div>
					<?php endif; ?>
					<button type="button" class="focus-sidebar__toggle">
						<i class="fas fa-expand-alt" aria-hidden="true"></i>
						<i class="fas fa-bars" aria-hidden="true"></i>
					</button>
				</div>
			</nav>
		</div>
		<div class="course-focus__content">
			<?php if ( have_posts() ) : the_post(); ?>
				<div class="post-top">
					<a href="<?php echo esc_url( $parent_course_link ); ?>" class="focus-navigation__back"><i class="fas fa-angle-left"></i><?php esc_html_e( 'Back to Course', 'talemy' ); ?></a>
					<?php if ( $total_lessons > 0 ) : ?>
						<div class="lesson-index"><?php printf( esc_html__( 'Lesson %s of %s', 'talemy' ), $lesson_index + 1, $total_lessons ); ?></div>
					<?php endif; ?>
				</div>
				<div class="post-header">
					<h1 class="post-title"><?php the_title(); ?></h1>
				</div>
				<div class="post-content">
					<div class="content">
						<?php the_content(); ?>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
<?php
do_action( 'talemy_content_end' );
get_template_part( 'templates/lifterlms/single/focus/footer' );