<?php
$course          = new LLMS_Course( get_the_ID() );
$meta_data_items = apply_filters( 'talemy_course_intro_meta_data', talemy_get_option( 'ld_course_meta_data' ) );

?>
<div class="course-intro__content">

	<?php do_action( 'talemy_course_intro_before_title' ); ?>

	<h1 class="post-title"><?php the_title(); ?></h1>

	<?php do_action( 'talemy_course_intro_after_title' ); ?>

	<div class="course-intro__meta">
		
		<?php foreach ( $meta_data_items as $meta_item ) : ?>
			
			<?php if ( 'enrolled' === $meta_item ) : ?>

				<?php if ( ( $enrolled = $course->get_student_count() ) > 0 ) : ?>
					<div class="course-meta__item">
						<span class="meta__enrolled"><i class="fas fa-user-friends"></i><?php printf( _n( '%s student enrolled', '%s students enrolled', $enrolled, 'talemy' ), $enrolled ) ?></span>
					</div>
				<?php endif; ?>

			<?php elseif ( 'author' === $meta_item ) : ?>

				<div class="course-meta__item">
					<span class="course-meta__author"><i class="fas fa-user"></i><?php printf( __( 'Created by %s', 'talemy' ), '<a href="'. esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) .'"><span itemprop="name">'. get_the_author() .'</span></a>' ); ?></span>
				</div>

			<?php elseif ( 'modified' === $meta_item ) : ?>

				<div class="course-meta__item">
					<span class="meta__updated"><i class="far fa-calendar"></i><?php printf( __( 'Last updated %s', 'talemy' ), get_the_modified_date() ); ?></span>
				</div>

			<?php elseif ( 'level' === $meta_item ) : ?>

				<?php if ( ! empty( $course_level = $difficulty = $course->get_difficulty() ) ) : ?>
					<div class="course-meta__item">
						<span class="course-meta__level"><i class="fas fa-signal"></i><?php echo esc_html( $course_level ); ?></span>
					</div>

				<?php endif; ?>

			<?php elseif ( 'cats' === $meta_item ) : ?>

				<?php if ( ! empty( $course_category_html = talemy_get_llms_course_categories() ) ) : ?>

					<div class="course-meta__item">
						<span class="course-meta__categories"><i class="fas fa-tag"></i><?php echo wp_kses_post( $course_category_html ); ?></span>
					</div>

				<?php endif; ?>

			<?php elseif ( 'duration' === $meta_item ) : ?>

				<?php if ( '' !== ( $course_duration = $course->get( 'length' ) ) ) : ?>

					<div class="course-meta__item">
						<span class="course-meta__duration"><i class="fas fa-clock"></i><?php echo esc_html( $course_duration ); ?></span>
					</div>

				<?php endif; ?>

			<?php endif; ?>

		<?php endforeach; ?>

	</div>
</div>