<?php
$layout      = talemy_get_option( 'ld_course_layout' );
$has_sidebar = ( 'sidebar-right' === $layout || 'sidebar-left' === $layout );
if ( have_posts() ) : the_post();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( talemy_get_setting( 'layout' ) ); ?>>
	<?php get_template_part( 'templates/single/schema' ); ?>
	<div class="course-intro"<?php echo talemy_get_post_hero_style( false ); ?>>
		<div class="container"><?php talemy_breadcrumbs(); ?></div>	
		<div class="container">
			<?php if ( ! $has_sidebar ) : ?>
			<?php get_template_part( 'templates/lifterlms/single/intro' ); ?>
			<?php else : ?>
				<div class="row align-items-end">
					<div class="col-lg-4 order-lg-2">
						<?php get_template_part( 'templates/lifterlms/single/preview' ); ?>
					</div>
					<div class="col-lg-8 order-lg-1">
						<?php get_template_part( 'templates/lifterlms/single/intro' ); ?>
					</div>
				</div>
			<?php endif; ?>
		</div>
		<?php $hero_image = get_post_meta( get_the_ID(), '_sf_hero_image', true ); ?>
		<?php if ( ! empty( $hero_image['image'] ) ) : ?>
			<div class="head-image-overlay"></div>
		<?php endif; ?>
	</div>
	<div class="course-content">
		<div class="container">
			<?php if ( $has_sidebar ) : ?>
			<div class="row">
				<div class="col-lg-8 order-lg-1">
			<?php endif; ?>
					<div class="post-content">
						<?php //get_template_part( 'templates/lifterlms/single/sections' ); ?>
						<div class="content"><?php the_content(); ?></div>
					</div>
					<?php get_template_part( 'templates/lifterlms/single/related' ); ?>
					<?php if ( comments_open() ) : ?>
					<?php comments_template(); ?>
					<?php endif; ?>
				</div>
			<?php if ( $has_sidebar ) : ?>
				<div class="col-lg-4 order-lg-2">
					<?php get_template_part( 'templates/lifterlms/single/sidebar' ); ?>
				</div>
			</div>
			<?php endif; ?>
		</div>
	</div>
</article>
<?php endif; ?>