<?php
$category   = ( get_query_var( 'course_cat' ) ) ? get_query_var( 'course_cat' ) : '';
$category   = ( get_query_var( 'course_tag' ) ) ? get_query_var( 'course_tag' ) : '';
$form_class = talemy_get_option( 'ajax_search_form' ) ? 'course-search ajax-search-form' : 'course-search';
?>
<form class="<?php echo esc_attr( $form_class ); ?>" role="search" action="<?php echo esc_url( home_url() ); ?>" method="get">
    <div class="row xs-gutters">
        <div class="col-sm-12 col-md-6">
            <div class="course-search__input-container">
                <input type="search" name="s" class="course-search__input" placeholder="<?php esc_attr_e( 'Search..', 'talemy' ); ?>" value="<?php echo get_search_query(); ?>">
                <input type="hidden" name="post_type" value="course">
                <button class="course-search__submit" type="submit">
                    <i class="fas fa-search" aria-hidden="true"></i>
                </button>
                <?php do_action( 'wpml_add_language_form_field' ); ?>
            </div>
        </div>
        <div class="col-sm-12 col-md-3">
            <select name="course_cat" class="course-select__category">
                <option value="" selected><?php esc_html_e( 'All Categories', 'talemy' ); ?></option>
            <?php foreach ( talemy_get_option_terms( 'course_cat', 'slug' ) as $slug => $label ) : ?>
                <option value="<?php echo esc_attr( $slug ); ?>" <?php selected( $category, $slug ); ?>><?php echo esc_html( $label ); ?></option>
            <?php endforeach; ?>
            </select>
        </div>
        <div class="col-sm-12 col-md-3">
            <select name="course_tag" class="course-select__tag">
                <option value="" selected><?php esc_html_e( 'All Tags', 'talemy' ); ?></option>
            <?php foreach ( talemy_get_option_terms( 'course_tag', 'slug' ) as $slug => $label ) : ?>
                <option value="<?php echo esc_attr( $slug ); ?>" <?php selected( $category, $slug ); ?>><?php echo esc_html( $label ); ?></option>
            <?php endforeach; ?>
            </select>
        </div>
    </div>
</form>