<?php $course = new LLMS_Course( get_the_ID() ); ?>
<div <?php post_class( 'post ' . talemy_get_setting( 'post_class' ) ); ?>>
	<div class="post-body has-popover">
		<?php echo talemy_get_llms_loop_thumb( $course, talemy_get_setting( 'thumb_size' ) ); ?>
		<?php echo talemy_get_llms_loop_badge(); ?>
		<div class="post-info">
			<?php echo talemy_get_loop_title(); ?>
            <?php if ( talemy_get_setting( 'post_author' ) ) : ?>
                <div class="post-author"><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php the_author(); ?></a></div>
            <?php endif; ?>
		</div>
        <?php if ( talemy_get_setting( 'post_price' ) ) : ?>
            <div class="post-meta">
                <div class="course-meta__price"><?php echo talemy_get_llms_course_price(); ?></div> 
            </div>
        <?php endif; ?>
        <div class="post-popover">
            <div class="popover-body">
                <?php echo talemy_get_loop_title(); ?>
                <?php echo talemy_get_llms_loop_course_meta( $course, talemy_get_setting( 'grid_meta_data' ) ); ?>
                <?php echo talemy_get_loop_excerpt(); ?>
                <div class="post-action">
                    <?php echo talemy_get_llms_access_plan_button(); ?>
                </div>
            </div>
        </div>
	</div>
</div>