<?php
$course_id 			  = get_the_ID();
$course_options 	  = get_post_meta( $course_id, '_sfwd-courses', true );
$price_type 		  = isset( $course_options['sfwd-courses_course_price_type'] ) ? strtoupper( $course_options['sfwd-courses_course_price_type'] ) : 'free';
$has_access 		  = sfwd_lms_has_access( $course_id, get_current_user_id() );
$meta_data_items      = apply_filters( 'talemy_course_intro_meta_data', talemy_get_option( 'ld_course_meta_data' ) );

?>
<div class="course-intro__content">

	<?php do_action( 'talemy_course_intro_before_title' ); ?>

	<h1 class="post-title"><?php the_title(); ?></h1>
	<?php if ( ! empty( $course_headline = talemy_get_ld_course_meta( 'headline' ) ) ) : ?>
		<p class="course-headline" itemprop="headline"><?php echo wp_kses_post( $course_headline ); ?></p>
	<?php endif; ?>

	<?php do_action( 'talemy_course_intro_after_title' ); ?>

	<div class="course-intro__meta">
		
		<?php foreach ( $meta_data_items as $meta_item ) : ?>
			
			<?php if ( 'rating' === $meta_item ) : ?>
				
				<?php if ( function_exists( 'ldcr_get_course_rating' ) ) :
						$course_rating_html = ldcr_get_course_rating( $course_id, true, true, true );
				endif; ?>

				<?php if ( ! empty( $course_rating_html ) ) : ?>
					<div class="course-meta__item">
						<a href="#"><?php do_action( 'ldcr_course_rating', $course_id, true, true, true ); ?></a>
					</div>
				<?php endif; ?>

			<?php elseif ( 'enrolled' === $meta_item ) : ?>

				<?php $enrolled_base = talemy_get_ld_course_meta( 'enrolled' ); ?>
				<?php $enrolled 	 = talemy_get_ld_course_student_count( $course_id, $enrolled_base ); ?>
				
				<?php if ( 'OPEN' !== $price_type || $enrolled_base > 0 ) : ?>
					<div class="course-meta__item">
						<span class="meta__enrolled"><i class="fas fa-user-friends"></i><?php printf( _n( '%s student enrolled', '%s students enrolled', $enrolled, 'talemy' ), $enrolled ) ?></span>
					</div>
				<?php endif; ?>

			<?php elseif ( 'author' === $meta_item ) : ?>

				<div class="course-meta__item">
					<span class="course-meta__author"><i class="fas fa-user"></i><?php printf( __( 'Created by %s', 'talemy' ), '<a href="'. esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) .'"><span itemprop="name">'. get_the_author() .'</span></a>' ); ?></span>
				</div>

			<?php elseif ( 'modified' === $meta_item ) : ?>

				<div class="course-meta__item">
					<span class="meta__updated"><i class="far fa-calendar"></i><?php printf( __( 'Last updated %s', 'talemy' ), get_the_modified_date() ); ?></span>
				</div>

			<?php elseif ( 'language' === $meta_item ) : ?>

				<?php if ( ! empty( $course_language = talemy_get_ld_course_meta( 'language' ) ) ) : ?>

					<div class="course-meta__item">
						<span class="course-meta__language"><i class="fas fa-globe"></i><?php echo esc_html( $course_language ); ?></span>
					</div>

				<?php endif; ?>

			<?php elseif ( 'level' === $meta_item ) : ?>

				<?php if ( ! empty( $course_level = talemy_get_ld_course_meta( 'level' ) ) ) : ?>
					
					<div class="course-meta__item">
						<span class="course-meta__level">
							<i class="fas fa-signal"></i>
							<?php if ( function_exists( 'ldcm_get_course_level_label' ) ) {
								echo ldcm_get_course_level_label( $course_level );
							} else {
								echo esc_html( $course_level );
							} ?>
						</span>
					</div>

				<?php endif; ?>

			<?php elseif ( 'cats' === $meta_item ) : ?>

				<?php if ( ! empty( $course_category_html = talemy_get_ld_course_categories() ) ) : ?>

					<div class="course-meta__item">
						<span class="course-meta__categories"><i class="fas fa-tag"></i><?php echo wp_kses_post( $course_category_html ); ?></span>
					</div>

				<?php endif; ?>

			<?php elseif ( 'duration' === $meta_item ) : ?>

				<?php if ( '' !== ( $course_duration = talemy_get_ld_course_meta( 'duration' ) ) ) : ?>

					<div class="course-meta__item">
						<span class="course-meta__duration"><i class="fas fa-clock"></i><?php echo esc_html( $course_duration ); ?></span>
					</div>

				<?php endif; ?>

			<?php endif; ?>

		<?php endforeach; ?>

		<?php do_action( 'talemy_course_meta_items' ); ?>

	</div>
</div>