<?php
$instructors = [ get_the_author_meta( 'ID' ) ];
if ( defined( 'INSTRUCTOR_ROLE_PLUGIN_VERSION' ) ) {
    $shared_instructors_list = get_post_meta( get_the_ID(), 'ir_shared_instructor_ids', 1 );
    if ( ! empty( $shared_instructors_list ) ) {
        $shared_instructors = explode( ',', $shared_instructors_list );
        $instructors = array_unique( array_merge( $instructors, $shared_instructors ) );
    }
}
if ( empty( $instructors ) ) {
    return;
}
$section_title = apply_filters( 'talemy_instructors_section_title', esc_html__( 'About the Instructors', 'talemy' ) );
?>
<?php if ( ! empty( $section_title ) ) : ?>
    <h3><?php echo esc_html( $section_title ); ?></h3>
<?php endif; ?>
<div class="author-boxes">
    <?php
    foreach ( $instructors as $id ) :
        $author_email = get_the_author_meta( 'email', $id );
        $author_url   = get_the_author_meta( 'url', $id );
        $author_title = get_the_author_meta( 'sf_user_title', $id );
        $author_desc  = get_the_author_meta( 'description', $id );
        $author_bio   = get_the_author_meta( 'sf_user_bio', $id );
        if ( ! empty( $author_bio ) ) {
            $author_desc = $author_bio;
        }
    ?>
    <div class="author-box">
        <a class="author-portray" itemprop="author" href="<?php echo get_author_posts_url( $id ); ?>"><?php echo get_avatar( $author_email, 72 ); ?></a>
        <div class="author-description">
            <a class="author-name" itemprop="author" href="<?php echo get_author_posts_url( $id ); ?>"><?php echo get_the_author_meta( 'display_name', $id ); ?></a>

            <?php if ( ! empty( $author_title ) ) : ?>
                <div class="author-title"><?php echo esc_html( $author_title ); ?></div>
            <?php endif; ?>

            <?php if ( ! empty( $author_desc ) ) : ?>
                <div class="author-bio"><?php echo wp_kses_post( $author_desc ); ?></div>
            <?php endif; ?>

            <?php if ( ! empty( $author_url ) ) : ?>
                <div class="author-url"><a href="<?php echo esc_url( $author_url ); ?>" target="_blank"><?php echo esc_url( $author_url ); ?></a></div>
            <?php endif; ?>

            <?php do_action( 'sf_author_social_links', $id ); ?>
        </div>
    </div>
    <?php endforeach; ?>
</div>


