<?php if ( have_posts() ) : the_post(); ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( talemy_get_setting( 'layout' ) ); ?>>
		<?php get_template_part( 'templates/single/schema' ); ?>
		<div class="course-intro"<?php echo talemy_get_post_hero_style( false ); ?>>
			<?php talemy_breadcrumbs(); ?>
			<div class="container">
				<div class="row align-items-end lg-gutters">
					<div class="col-md-4 order-md-2">
						<?php get_template_part( 'templates/learndash/single/preview' ); ?>
					</div>
					<div class="col-md-8 order-md-1">
						<?php get_template_part( 'templates/learndash/single/group-intro' ); ?>
					</div>
				</div>
			</div>
			<?php $hero_image = get_post_meta( get_the_ID(), '_sf_hero_image', true ); ?>
			<?php if ( !empty( $hero_image['image'] ) ) : ?>
				<div class="head-image-overlay"></div>
			<?php endif; ?>
		</div>
		<div class="course-content course-sections--style-<?php echo esc_attr( talemy_get_option( 'ld_group_sections_layout' ) ); ?>">
			<div class="container">
				<div class="row">
					<div class="col-md-8 order-md-1">
						<div class="post-content"><?php the_content(); ?></div>
						<?php if ( comments_open() ) : ?>
						<?php comments_template(); ?>
						<?php endif; ?>
					</div>
					<div class="col-md-4 order-md-2">
						<?php get_template_part( 'templates/learndash/single/group-sidebar' ); ?>
					</div>
				</div>
			</div>
		</div>
	</article>
<?php endif; ?>