<?php
$user_id		= get_current_user_id();
$group_id		= get_the_ID();
$meta_data		= get_post_meta( $group_id, '_ld_custom_meta', true );
$group_status	= learndash_get_user_group_status( $group_id, $user_id );
$group_pricing 	= learndash_get_group_price( $group_id );
$is_wc_product	= defined( 'WC_PLUGIN_FILE' ) && defined( 'LEARNDASH_WOOCOMMERCE_FILE' ) && ! empty( $meta_data['related_product'] );
$sidebar_id		= talemy_get_setting( 'sidebar', 'default-sidebar' );

if ( learndash_is_user_in_group( $user_id, $group_id ) ) {
	$has_access = true;
} else {
	$has_access = false;
}

$ajax_login_class = '';
if ( talemy_get_option( 'theme_login' ) && defined( 'SF_FRAMEWORK_VERSION' ) && SF()->get_setting( 'enable_login_registration' ) ) {
	$ajax_login_class = ' ' . apply_filters( 'talemy_nav_login_class', 'sf-ajax-login' );
}

if ( ! is_user_logged_in() ) {
	
	if ( defined( 'LEARNDASH_VERSION' ) ) {
		$login_model = LearnDash_Settings_Section::get_section_setting( 'LearnDash_Settings_Theme_LD30', 'login_mode_enabled' );
		if ( $login_model === 'yes' ) {
			$login_url = apply_filters( 'learndash_login_url', '#login' );
		}
	}

	if ( empty( $login_url ) ) {
		if ( ! empty( $login_page = talemy_get_option( 'custom_login_page' ) ) ) {
			$login_url = get_permalink( $login_page );
		} else {
			$login_url = wp_login_url( get_permalink() );
		}
	}

	$login_url = apply_filters( 'talemy_login_url', $login_url );
}

?>
<aside class="sidebar sticky">
	<div class="sidebar-wrapper">
		<div class="course-sidebar">
			<div class="course-sidebar__inner">

				<?php do_action( 'talemy_course_sidebar_start' ); ?>

				<?php if ( ! $has_access ) : ?>
					<div class="course-sidebar__price">
						<?php if ( $is_wc_product ) : ?>
						<?php echo talemy_get_wc_product_price( $meta_data['related_product'] ); ?>
						<?php else: ?>
						<?php echo talemy_get_ld_group_price( $group_id ); ?>
						<?php endif; ?>
					</div><!-- .course-sidebar__price -->
				<?php endif; ?>
				
				<?php if ( is_user_logged_in() && $has_access ) : ?>
					<div class="course-sidebar__status">
						<div class="learndash-wrapper">
							<?php learndash_status_bubble( $group_status ); ?>
						</div>
					</div><!-- .course-sidebar__status -->
				<?php endif; ?>
				
				<div class="course-sidebar__buttons">
					
					<?php do_action( 'talemy_course_sidebar_buttons_start' ); ?>

					<?php if ( ! $has_access && $is_wc_product ) : ?>
						<?php echo do_shortcode( '[add_to_cart id="'. $meta_data['related_product'] .'" show_price="FALSE" style="margin-bottom:10px;margin-top:0;" class="ld-add-to-cart"]' ); ?>
						<?php echo talemy_get_ld_wc_payment_button( $group_id, $meta_data['related_product'] ); ?>
					<?php endif; ?>

					<?php

						switch ( $group_pricing['type'] ) {
						
						case 'free':
							if ( ! is_user_logged_in() ) {
								?>
								<a href="<?php echo esc_url( $login_url ); ?>" class="btn btn-lg btn-block btn-primary<?php echo esc_attr( $ajax_login_class ); ?>"><?php esc_html_e( 'Login to Enroll', 'talemy' ); ?></a>
								<?php
							} else {
								echo '<div class="learndash-wrapper">';
								echo learndash_payment_buttons( $group_id ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Outputs Payment button HTML
								echo '</div>';
							}

							break;

						case 'paynow':
						case 'subscribe':

							if ( ! $has_access ) {
								echo '<div class="learndash-wrapper">';
								echo learndash_payment_buttons( $group_id );
								echo '</div>';
							}

							break;

						case 'closed':

							if ( ! $has_access && ! $is_wc_product ) {
								$ld_payment_buttons = learndash_payment_buttons( $group_id );
								if ( empty( $ld_payment_buttons ) ) {
									echo '<span class="ld-text">' . esc_html__( 'This group is currently closed', 'talemy' ) . '</span>';
								} else {
									echo '<div class="learndash-wrapper">';
									echo wp_kses_post( $ld_payment_buttons );
									echo '</div>';
								}
							}

							break;
						}

					?>

					<?php do_action( 'talemy_course_sidebar_buttons_end' ); ?>

				</div><!-- .course-sidebar__buttons -->

				<?php if ( talemy_get_option( 'ld_group_share' ) ) : ?>
					<div class="course-sidebar__share">
						<button class="btn btn-block" id="course-sidebar__share-btn">
							<span class="btn-text-wrapper">
								<span class="btn-icon btn-align-icon-right"><i class="fas fa-share"></i></span>
								<span class="btn-text"><?php esc_html_e( 'Share', 'talemy' ); ?></span>
							</span>
						</button>
						<?php do_action( 'sf_post_share_buttons' ); ?>
					</div><!-- .course-sidebar__share -->
				<?php endif; ?>

				<?php do_action( 'talemy_course_sidebar_end' ); ?>

			</div><!-- .course-sidebar__inner -->
		</div><!-- .course-sidebar -->
		<?php if ( is_active_sidebar( $sidebar_id ) ) : ?>
		<?php dynamic_sidebar( $sidebar_id ); ?>
		<?php endif; ?>
	</div><!-- .sidebar-wrapper -->
</aside><!-- .sidebar -->