<?php
$course_search_filters = talemy_get_option( 'ld_courses_search_filters' );
$category   = ( get_query_var( 'ld_course_category' ) ) ? get_query_var( 'ld_course_category' ) : '';
$tag   = ( get_query_var( 'ld_course_tag' ) ) ? get_query_var( 'ld_course_tag' ) : '';
$price      = isset( $_GET['ld_course_price'] ) ? $_GET['ld_course_price'] : '';
$form_class = talemy_get_option( 'ajax_search_form' ) ? 'course-search ajax-search-form' : 'course-search';
?>
<form class="<?php echo esc_attr( $form_class ); ?>" role="search" action="<?php echo esc_url( home_url() ); ?>" method="get">
    <div class="course-search__input-container">
        <input type="search" name="s" class="course-search__input" placeholder="<?php esc_attr_e( 'Search..', 'talemy' );?>" value="<?php echo get_search_query(); ?>">
        <input type="hidden" name="post_type" value="sfwd-courses">
        <button class="course-search__submit" type="submit">
            <i class="fas fa-search" aria-hidden="true"></i>
        </button>
        <?php do_action( 'wpml_add_language_form_field' );?>
    </div>
    <?php if ( in_array( 'category', $course_search_filters ) ) : ?>
        <select name="ld_course_category" class="course-select__category">
            <option value="" selected><?php esc_html_e( 'All Categories', 'talemy' );?></option>
        <?php foreach ( talemy_get_ld_option_course_cats( 'slug' ) as $slug => $label ): ?>
            <option value="<?php echo esc_attr( $slug ); ?>" <?php selected( $category, $slug );?>><?php echo esc_html( $label ); ?></option>
        <?php endforeach; ?>
        </select>
    <?php endif; ?>
    <?php if ( in_array( 'tag', $course_search_filters ) ) : ?>
        <select name="ld_course_tag" class="course-select__tag">
            <option value="" selected><?php esc_html_e( 'All Tags', 'talemy' );?></option>
        <?php foreach ( talemy_get_ld_option_course_tags( 'slug' ) as $slug => $label ): ?>
            <option value="<?php echo esc_attr( $slug ); ?>" <?php selected( $tag, $slug );?>><?php echo esc_html( $label ); ?></option>
        <?php endforeach; ?>
        </select>
    <?php endif; ?>
    <?php if ( in_array( 'price', $course_search_filters ) ) : ?>
        <select name="ld_course_price" class="course-select__price">
            <option value="all" <?php selected( $price, '' );?>><?php esc_html_e( 'All Price', 'talemy' );?></option>
            <option value="free" <?php selected( $price, 'free' );?>><?php esc_html_e( 'Free', 'talemy' );?></option>
            <option value="paid" <?php selected( $price, 'paid' );?>><?php esc_html_e( 'Paid', 'talemy' );?></option>
        </select>
    <?php endif; ?>
</form>