<?php
$post_types = apply_filters( 'talemy_nav_search_post_types', Talemy::$lms_course );
$post_types = (array) $post_types;
$form_class = talemy_get_option( 'ajax_search_form' ) ? 'search-form ajax-search-form' : 'search-form';
?>
<form class="<?php echo esc_attr( $form_class ); ?>" role="search" action="<?php echo esc_url( home_url() ); ?>" method="get">
    <div class="position-relative">
        <input type="search" name="s" class="sf-input" placeholder="<?php echo esc_attr( talemy_get_option( 'header_search_placeholder' ) ); ?>" title="<?php echo esc_attr_e( 'Search', 'talemy' ); ?>" value="<?php echo get_search_query(); ?>">
        <?php
        if ( ! empty( $post_types ) ) :
            foreach( $post_types as $post_type ) :
                ?>
                <input type="hidden" name="post_type[]" value="<?php echo esc_attr( $post_type ); ?>">
                <?php 
            endforeach;
        endif;
        ?>
        <button class="sf-submit" type="submit">
            <i class="ticon-search-alt" aria-hidden="true"></i>
        </button>
        <?php do_action( 'wpml_add_language_form_field' ); ?>
    </div>
</form>