<?php
$defaults = [
	'logo_class'  => 'logo-wrapper',
	'title'       => '<a href="%1$s" rel="home"><span class="%2$s">%3$s</span></a>',
	'title_class' => 'site-title',
	'container'   => '<div class="%1$s" itemscope="itemscope" itemtype="https://schema.org/Organization">%2$s</div>'
];
$args = wp_parse_args( $args, $defaults );
$args = apply_filters( 'talemy_logo_args', $args );

if ( has_custom_logo() ) {
	$logo_html = get_custom_logo();
} else {
	$logo_html = sprintf( $args['title'], esc_url( get_home_url( null, '/' ) ), $args['title_class'], get_bloginfo( 'name' ) );
}

$html = sprintf( $args['container'], $args['logo_class'], $logo_html );

/**
 * Filters the arguments for `learncentral_logo`.
 *
 * @param string $html      Compiled html based on our arguments.
 * @param array  $args      Parsed arguments.
 * @param string $logo_html HTML for site title or logo.
 */
echo apply_filters( 'talemy_logo', $html, $args, $logo_html );