<?php
$taxonomy   = apply_filters( 'talemy_nav_search_taxonomy', Talemy::$lms_category );
$category   = ( get_query_var( $taxonomy ) ) ? get_query_var( $taxonomy ) : '';
$post_types = apply_filters( 'talemy_nav_search_post_types', Talemy::$lms_course );
$post_types = (array) $post_types;
$form_class = talemy_get_option( 'ajax_search_form' ) ? 'course-search-form ajax-search-form' : 'course-search-form';
?>
<form class="<?php echo esc_attr( $form_class ); ?>" role="search" action="<?php echo esc_url( home_url() ); ?>" method="get">
    <select name="<?php echo esc_attr( $taxonomy ); ?>" class="course-search-category">
        <option value="" selected><?php esc_html_e( 'All Categories', 'talemy' ); ?></option>
        <?php foreach ( talemy_get_option_terms( $taxonomy, 'slug' ) as $slug => $label ) : ?>
            <option value="<?php echo esc_attr( $slug ); ?>" <?php selected( $category, $slug ); ?>><?php echo esc_html( $label ); ?></option>
        <?php endforeach; ?>
    </select>
    <div class="position-relative">
        <input type="search" name="s" class="course-search-input" placeholder="<?php echo esc_attr( talemy_get_option( 'header_search_placeholder' ) ); ?>" value="<?php echo get_search_query(); ?>">
        <?php 
        if ( ! empty( $post_types ) ) :
            foreach( $post_types as $post_type ) :
                ?>
                <input type="hidden" name="post_type[]" value="<?php echo esc_attr( $post_type ); ?>">
                <?php 
            endforeach;
        endif;
        ?>
        <button class="course-search-btn sf-submit" type="submit">
            <i class="ticon-search-alt" aria-hidden="true"></i>
        </button>
        <?php do_action( 'wpml_add_language_form_field' ); ?>
    </div>
</form>