<?php
$banner = talemy_get_setting( 'banner' );
$banner = 'inherit' === $banner ? talemy_get_option( 'banner' ) : $banner;
if ( '' === $banner ) :
	$has_banner_image = false;
	$banner_image     = talemy_get_setting( 'banner_image' );
	$banner_bg        = talemy_get_option( 'banner_bg' );
	if ( ! empty( $banner_image ) || ! empty( $banner_bg['background-image'] ) ) {
		$has_banner_image = true;
	}
	?>
	<div class="content-banner"<?php if ( ! empty( $banner_image ) ) { echo ' style="background-image:url('. esc_url( $banner_image ) .');"'; } ?>>
		<div class="container">
			<h1 class="page-title"><?php
				if ( is_home() ) {
					echo wp_kses_post( talemy_get_option( 'home_title' ) );
				} else if ( is_singular() ) {
					if ( is_singular( 'post' ) ) {
						echo wp_kses_post( talemy_get_option( 'home_title' ) );
					} else {
						the_title();
					}
				} else if ( is_search() ) {
					if ( talemy_get_query()->have_posts() ) {
						printf( esc_html__( 'Search Results for "%s"', 'talemy' ), get_search_query() );
					} else {
						printf( esc_html__( 'No results found for "%s"', 'talemy' ), get_search_query() );
					}
				} else if ( is_archive() ) {
					echo talemy_get_archive_title();
				}
			?>
			</h1>
			<?php talemy_breadcrumbs(); ?>
		</div>
		<?php if ( $has_banner_image ) : ?>
			<div class="banner-overlay"></div>
		<?php endif; ?>
	</div>
<?php elseif ( 'breadcrumbs' === $banner ) : ?>
<?php get_template_part( 'templates/content-breadcrumbs' ); ?>
<?php elseif ( 'shortcode' === $banner ) : ?>
<?php echo do_shortcode( html_entity_decode( talemy_get_setting( 'banner_shortcode' ) ) ); ?>
<?php endif; ?>