<?php
/**
 * Plugin Name: Talemy Demo Data
 * Plugin URI: https://themespirit.com
 * Description: Demo data for Talemy theme
 * Author: ThemeSpirit
 * Author URI: https://themespirit.com
 * Version: 1.1.3
 * Text Domain: talemy-demo
 * Domain Path: languages
 */

if ( ! defined( 'TALEMY_DEMO_DIR' ) ) define( 'TALEMY_DEMO_DIR', plugin_dir_path( __FILE__ ) );
if ( ! defined( 'TALEMY_DEMO_URL' ) ) define( 'TALEMY_DEMO_URL', plugin_dir_url( __FILE__ ) );

add_filter( 'sf_config_demos_dir', 'talemy_theme_demos_dir' );
add_filter( 'sf_config_demos', 'talemy_theme_demos_config' );
add_filter( 'sf_config_demo_pages', 'talemy_theme_demo_config_pages' );
add_filter( 'sf_config_sidebars', 'talemy_theme_sidebars' );
add_filter( 'sf_config_demo_shared_content', 'talemy_theme_demo_shared_content' );

function talemy_theme_demos_dir( $path ) {
	return TALEMY_DEMO_DIR . 'data';
}

function talemy_theme_demos_config( $demo_data = '' ) {
	$demo_data = array(
		'demo-1' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_demo_1.jpg',
			'id'         => 'demo-1',
			'label'      => esc_html__( 'Default', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'sliders', 'courses', 'events', 'options', 'menus' )
		),
		'university' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_university.jpg',
			'id'         => 'university',
			'label'      => esc_html__( 'University', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/university/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'sliders', 'courses', 'events', 'options', 'menus' )
		),
		'high-school' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_high_school.jpg',
			'id'         => 'high-school',
			'label'      => esc_html__( 'High School', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/high-school/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'sliders', 'courses', 'events', 'options', 'menus' )
		),
		'online-learning' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_online_learning.jpg',
			'id'         => 'online-learning',
			'label'      => esc_html__( 'Online Learning', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/online-learning/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'courses', 'events', 'options', 'menus' )
		),
		'one-course' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_one_course.jpg',
			'id'         => 'one-course',
			'label'      => esc_html__( 'One Course', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/one-course/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'courses', 'events', 'options', 'menus' )
		),
		'one-instructor' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_one_instructor.jpg',
			'id'         => 'one-instructor',
			'label'      => esc_html__( 'One Instructor', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/one-instructor/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'courses', 'events', 'options', 'menus' )
		),
		'kindergarten' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_kindergarten.jpg',
			'id'         => 'kindergarten',
			'label'      => esc_html__( 'Kindergarten', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/kindergarten/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'courses', 'events', 'options', 'menus' )
		),
		'demo-2' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_demo_2.jpg',
			'id'         => 'demo-2',
			'label'      => esc_html__( 'Demo 2', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/demo-2/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'courses', 'events', 'options', 'menus' )
		),
		'demo-3' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_demo_3.jpg',
			'id'         => 'demo-3',
			'label'      => esc_html__( 'Demo 3', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/demo-3/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'sliders', 'courses', 'events', 'options', 'menus' )
		),
		'demo-5' => array(
			'thumbnail'  => 'https://talemy.themespirit.com/wp-content/uploads/demo/thumbnail_demo_5.jpg',
			'id'         => 'demo-5',
			'label'      => esc_html__( 'Demo 5', 'talemy-demo' ),
			'preview'    => 'https://talemy.themespirit.com/demo-5/',
			'content'    => array( 'images', 'pages', 'posts', 'widgets', 'courses', 'events', 'options', 'menus' )
		)
	);

	if ( !empty( $demo_id ) && isset( $demo_data[ $demo_id ] ) ) {
		return $demo_data[ $demo_id ];
	}
	return $demo_data;
}

function talemy_theme_demo_config_pages( $pages = array() ) {
	return array(
		'page_homepage' => 'Homepage',
		'page_blog' => 'Blog',
		'page_login' => 'Login',
		'page_profile' => 'Profile',
		'page_about_us' => 'About Us',
		'page_about_us_2' => 'About Us 2',
		'page_contact_us' => 'Contact Us',
		'page_research' => 'Research',
		'page_faqs' => 'FAQs',
		'page_course_list' => 'Course List',
		'page_accordion' => 'Accordion',
		'page_buttons' => 'Buttons',
		'page_countdown' => 'Countdown',
		'page_icon_box' => 'Icon Box',
		'page_info_boxes' => 'Info Boxes',
		'page_gallery' => 'Gallery',
		'page_number_counter' => 'Number Counter',
		'page_pricing_table' => 'Pricing Table',
		'page_progress_bars' => 'Progress Bars',
		'page_team_members' => 'Team Members',
		'page_testimonials' => 'Testimonials',
		'page_woo_products' => 'Woo Products',
		'page_block_courses' => 'Block Courses',
		'page_block_posts' => 'Block Posts',
		'page_course_categories' => 'Course Categories',
		'page_course_search' => 'Course Search'
	);
}

function talemy_theme_sidebars() {
	return array(
		'default-sidebar',
		'footer-1',
		'footer-2',
		'footer-3',
		'footer-4',
		'footer-5',
		'footer-gallery',
		'footer-top',
		'footer-bottom',
		'topbar-left',
		'topbar-right',
		'side',
		'side_right'
	);
}

function talemy_theme_demo_shared_content() {
	return [ 'images', 'posts', 'courses', 'events' ];
}