<?php

SF_Demo_Installer::add_widget_to_sidebar(
    'topbar-left',
    'sf-social-icons',
    array(
        'title' => '',
        'url_source' => 'mods',
    )
);

/** Language menu */
$demo_lang_menu_id = SF_Demo_Installer::add_menu( 'demo-lang-menu' );

$demo_lang_menu_item_parent = SF_Demo_Installer::add_menu_item_link( $demo_lang_menu_id, array(
    'parent_id' => 0,
    'title' => 'English',
    'url' => '#',
    'classes' => 'flag flag-us'
));

SF_Demo_Installer::add_menu_item_link( $demo_lang_menu_id, array(
    'parent_id' => $demo_lang_menu_item_parent,
    'title' => 'French',
    'url' => '#',
    'classes' => 'flag flag-fr'
));

SF_Demo_Installer::add_menu_item_link( $demo_lang_menu_id, array(
    'parent_id' => $demo_lang_menu_item_parent,
    'title' => 'German',
    'url' => '#',
    'classes' => 'flag flag-de'
));

SF_Demo_Installer::add_menu_item_link( $demo_lang_menu_id, array(
    'parent_id' => $demo_lang_menu_item_parent,
    'title' => 'Italian',
    'url' => '#',
    'classes' => 'flag flag-it'
));

SF_Demo_Installer::add_widget_to_sidebar(
    'topbar-right',
    'nav_menu',
    array(
        'title' => '',
        'nav_menu' => $demo_lang_menu_id,
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'default-sidebar',
    'search',
    array(
        'title' => ''
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'default-sidebar',
    'recent-posts',
    array(
        'title' => '',
        'number' => 5,
        'show_date' => false
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'default-sidebar',
    'categories',
    array(
        'title' => '',
        'count' => false,
        'hierarchical' => false,
        'dropdown' => false
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'default-sidebar',
    'tag-cloud',
    array()
);

$demo_logo_id = SF_Demo_Installer::get_data_value( 'image_logo_light' );
$demo_logo_url = '';

if ( !empty( $demo_logo_id ) ) {
    $demo_logo = wp_get_attachment_image_src( $demo_logo_id, 'full' );
    $demo_logo_url = !empty( $demo_logo ) ? $demo_logo[0] : '';
}

SF_Demo_Installer::add_widget_to_sidebar(
    'footer-1',
    'sf-about-site',
    array(
        'title' => '',
        'logo' => $demo_logo_url,
        'retina_logo' => '',
        'logo_width' => 135,
        'logo_height' => 43,
        'description' => 'Talemy is your ideal education WordPress theme for sharing and selling your knowledge online. Teach what you love. Talemy gives you the tools to create an online course.',
        'show_social' => 1
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'footer-2',
    'custom_html',
    array(
        'title' => 'Working Hours',
        'content' => '<p>Please feel free to contact us for any inquiry.</p>
<br>
<ul class="office-hours">
<li>Monday - Friday <span class="float-right text-white">8:00 am - 16.00 pm</span></li>
<li>Saturday <span class="float-right text-white">10:00 am - 14.00 pm</span></li>
<li>Sunday <span class="float-right text-white">9:00 am - 12.00 pm</span></li>
</ul>'
    )
);

/** Mailchimp **/

if ( defined( 'MC4WP_VERSION' ) ) {
	SF_Demo_Installer::add_custom_post_type( '', array(
			'title' => 'mail form 1',
			'post_type' => 'mc4wp-form',
			'post_content' => '<p>
  Subscribe to our newsletter for latest updates about our company
</p>
<p class="position-relative">
  <input type="email" name="EMAIL" placeholder="'. esc_attr__( 'Email address', 'talemy-demo' ) .'" required style="border-color:#444444;"/>
  <button type="submit" class="sf-submit" style="color:#694f76;line-height:40px;width:50px;text-align:center;padding-right:5px;"><i class="fas fa-paper-plane"></i></button>
</p>
<span>We don\'t send spam*</span>'
    ));
    
    SF_Demo_Installer::add_widget_to_sidebar(
        'footer-3',
        'mc4wp_form_widget',
        array(
            'title' => 'Newsletter'
        )
    );
}


