<?php

if ( defined( 'WPCF7_VERSION' ) ) {

	SF_Demo_Installer::add_custom_post_type( '', array(
		'title' => 'Send message',
		'post_type' => 'wpcf7_contact_form',
		'post_meta' => array(
			'_form' => '<div class="row sm-gutters">
<p class="col-md-4">[text* your-name placeholder "Name*"]</p>
<p class="col-md-4">[email* your-email placeholder "Email*"]</p>
<p class="col-md-4">[text your-subject placeholder "Subject"]</p>
</div>
<p>[textarea* your-message x4 placeholder "Message*"]</p>
<p class="text-center">[submit class:btn class:btn-primary "Send"]</p>',
			'_mail' => array(
				'active' => 1,
				'subject' =>
					/* translators: 1: blog name, 2: [your-subject] */
					sprintf(
						_x( '%1$s "%2$s"', 'mail subject', 'talemy-demo' ),
						get_bloginfo( 'name' ), '[your-subject]' ),
				'sender' => sprintf( '[your-name] <%s>', get_option( 'admin_email' ) ),
				'body' =>
					/* translators: %s: [your-name] <[your-email]> */
					sprintf( __( 'From: %s', 'talemy-demo' ),
						'[your-name] <[your-email]>' ) . "\n"
					/* translators: %s: [your-subject] */
					. sprintf( __( 'Subject: %s', 'talemy-demo' ),
						'[your-subject]' ) . "\n\n"
					. __( 'Message Body:', 'talemy-demo' )
						. "\n" . '[your-message]' . "\n\n"
					. '-- ' . "\n"
					/* translators: 1: blog name, 2: blog URL */
					. sprintf(
						__( 'This e-mail was sent from a contact form on %1$s (%2$s)', 'talemy-demo' ),
						get_bloginfo( 'name' ),
						home_url( '/' ) ),
				'recipient' => get_option( 'admin_email' ),
				'additional_headers' => 'Reply-To: [your-email]',
				'attachments' => '',
				'use_html' => 0,
				'exclude_blank' => 0
			)
		)
	));
}