<?php

switch ( $demo_item ) {

    case 'page_homepage':
        if ( $demo_id == 'one-course' ) {
            $demo_homepage_menu_id = SF_Demo_Installer::add_menu( 'demo-homepage-menu' );
	
            SF_Demo_Installer::add_menu_item_link( $demo_homepage_menu_id, array(
                'parent_id' => 0,
                'title' => 'Home',
                'url' => home_url( '/' ),
            ));
        
            SF_Demo_Installer::add_menu_item_link( $demo_homepage_menu_id, array(
                'parent_id' => 0,
                'title' => 'Overview',
                'url' => '#overview'
            ));
        
            SF_Demo_Installer::add_menu_item_link( $demo_homepage_menu_id, array(
                'parent_id' => 0,
                'title' => 'Features',
                'url' => '#features'
            ));
        
            SF_Demo_Installer::add_menu_item_link( $demo_homepage_menu_id, array(
                'parent_id' => 0,
                'title' => 'Pricing',
                'url' => '#pricing'
            ));
        
            SF_Demo_Installer::add_menu_item_link( $demo_homepage_menu_id, array(
                'parent_id' => 0,
                'title' => 'Instructor',
                'url' => '#instructor'
            ));
        
            SF_Demo_Installer::add_menu_item_link( $demo_homepage_menu_id, array(
                'parent_id' => 0,
                'title' => 'FAQs',
                'url' => '#faqs'
            ));
        
            $file_name = 'home_' . str_replace( '-', '_', $demo_id ) . '.json';
            SF_Demo_Installer::add_elementor_page( 'page_homepage', array(
                'file' => TALEMY_DEMO_DIR . 'data/common/pages/'. $file_name,
                'post_meta' => array(
                    '_wp_page_template' => 'elementor_header_footer',
                    '_sf_menu' => $demo_homepage_menu_id
                )
            ));

        } else {
            $file_name = 'home_' . str_replace( '-', '_', $demo_id ) . '.json';
            SF_Demo_Installer::add_elementor_page( 'page_homepage', array(
                'file' => TALEMY_DEMO_DIR . 'data/common/pages/'. $file_name,
                'post_meta' => array(
                    '_wp_page_template' => 'elementor_header_footer'
                )
            ));
        }

    break;

    case 'page_blog':
        SF_Demo_Installer::add_page( 'page_blog', array(
            'title' => 'Blog',
        ));
    break;

    case 'page_profile':
        SF_Demo_Installer::add_page( 'page_profile', array(
            'title' => esc_html__( 'Profile', 'talemy-demo-data' ),
            'post_content' => '[ld_profile]',
            'post_meta' => array(
                '_sf_layout' => 'full-width'
            )
        ));
    break;

    case 'page_login':
        SF_Demo_Installer::add_elementor_page( 'page_login', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/login.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_about_us':
        SF_Demo_Installer::add_elementor_page( 'page_about_us', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/about_us.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_about_us_2':
        SF_Demo_Installer::add_elementor_page( 'page_about_us_2', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/about_us_2.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_contact_us':
        SF_Demo_Installer::add_elementor_page( 'page_contact_us', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/contact_us.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
        
        include_once( TALEMY_DEMO_DIR . 'data/'. $demo_id .'/contactform7.php' );

    break;

    case 'page_research':
        SF_Demo_Installer::add_elementor_page( 'page_research', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/research.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_faqs':
        SF_Demo_Installer::add_elementor_page( 'page_faqs', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/faqs.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_course_list':
        if ( defined( 'LEARNDASH_VERSION' ) ) {
            SF_Demo_Installer::add_elementor_page( 'page_course_list', array(
                'file' => TALEMY_DEMO_DIR . 'data/common/pages/course_list.json',
                'post_meta' => array(
                    '_wp_page_template' => 'page-builder.php'
                )
            ));
        }
    break;

    case 'page_accordion':
        SF_Demo_Installer::add_elementor_page( 'page_accordion', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/accordion.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_buttons':
        SF_Demo_Installer::add_elementor_page( 'page_buttons', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/buttons.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_countdown':
        SF_Demo_Installer::add_elementor_page( 'page_countdown', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/countdown.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_icon_box':
        SF_Demo_Installer::add_elementor_page( 'page_icon_box', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/icon_box.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_info_boxes':
        SF_Demo_Installer::add_elementor_page( 'page_info_boxes', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/info_boxes.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_gallery':
        SF_Demo_Installer::add_elementor_page( 'page_gallery', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/gallery.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_number_counter':
        SF_Demo_Installer::add_elementor_page( 'page_number_counter', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/number_counter.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_pricing_table':
        SF_Demo_Installer::add_elementor_page( 'page_pricing_table', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/pricing_table.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_progress_bars':
        SF_Demo_Installer::add_elementor_page( 'page_progress_bars', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/progress_bars.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_team_members':
        SF_Demo_Installer::add_elementor_page( 'page_team_members', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/team_members.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_testimonials':
        SF_Demo_Installer::add_elementor_page( 'page_testimonials', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/testimonials.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_woo_products':
        SF_Demo_Installer::add_elementor_page( 'page_woo_products', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/woo_products.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_block_courses':
        SF_Demo_Installer::add_elementor_page( 'page_block_courses', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/block_courses.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_block_posts':
        SF_Demo_Installer::add_elementor_page( 'page_block_posts', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/block_posts.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_course_categories':
        SF_Demo_Installer::add_elementor_page( 'page_course_categories', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/course_categories.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;

    case 'page_course_search':
        SF_Demo_Installer::add_elementor_page( 'page_course_search', array(
            'file' => TALEMY_DEMO_DIR . 'data/common/pages/course_search.json',
            'post_meta' => array(
                '_wp_page_template' => 'page-builder.php'
            )
        ));
    break;
}

SF_Demo_Installer::add_record( 'pages', 'pages' );