<?php

if ( 'options' != $demo_item ) {
	return;
}

/**
 * Customize Settings
 */
$theme_options = array();

// Theme logo
$demo_data = get_option( 'sf_demo_data' );
$demo_image_logo = '';
if ( !empty( $demo_data['image_logo'] ) ) {
    $theme_options['custom_logo'] = $demo_data['image_logo'];
}

// Update customize settings
SF_Demo_Installer::install_theme_options( TALEMY_DEMO_DIR . 'data/'. $demo_id .'/options.json' );
SF_Demo_Installer::update_theme_options( $theme_options );

/**
 * Database Options
 */
$options = array( 'permalink_structure' => '/%postname%/' );

/**
 * Theme Colors
 */
$primary_color = '';
$secondary_color = '';
$text_color = '#495255';
$text_dark_color = '#222222';
switch ( $demo_id ) {
    case 'demo-1':
        $primary_color = '#41246d';
        $secondary_color = '#f5b417';
        break;
    case 'demo-2':
        $primary_color = '#4054b2';
        $secondary_color = '#f4c150';
        break;
    case 'high-school':
        $primary_color = '#5d0059';
        $secondary_color = '#e4125d';
        break;
    case 'online-learning':
        $primary_color = '#3c415e';
        $secondary_color = '#1cb3c8';
        break;
    case 'university':
        $primary_color = '#162a50';
        $secondary_color = '#329e58';
        break;
    case 'demo-3':
    case 'demo-5':
    case 'kindergarten':
    case 'one-course':
    case 'one-instructor':
        $primary_color = '#d22f2f';
        $secondary_color = '#d22f2f';
        break;
}

// Elementor settings
if ( defined( 'ELEMENTOR_VERSION' ) ) {
    $options['elementor_disable_color_schemes'] = 'yes';
    $options['elementor_disable_typography_schemes'] = 'yes';
    $options['elementor_page_title_selector'] = '.post-header';
    $options['elementor_cpt_support'] = array( 'post', 'page', 'sfwd-courses', 'sfwd-lessons', 'sfwd-topic' );

    $page_settings = [];
    $page_settings['system_colors'] = [
        [
            '_id' => 'primary',
            'title' => 'Primary',
            'color' => $primary_color
        ],
        [
            '_id' => 'secondary',
            'title' => 'Secondary',
            'color' => $secondary_color
        ],
        [
            '_id' => 'text',
            'title' => 'Text',
            'color' => $text_color
        ],
        [
            '_id' => 'text_dark',
            'title' => 'Text Dark',
            'color' => $text_dark_color
        ]
    ];
    $page_settings['container_width'] = [
        'unit' => 'px',
        'size' => 1200,
        'sizes' => []
    ];
    SF_Demo_installer::update_elementor_page_settings( $page_settings );
}

// Breadcrumb NavXT settings
if ( function_exists( 'bcn_display' ) ) {
	$bcn_options = get_option( 'bcn_options' );
	if ( !empty( $bcn_options ) && is_array( $bcn_options ) ) {
		$bcn_options['hseparator'] = '<span class="sep fas fa-chevron-right"></span>';
		$bcn_options['Hhome_template'] = '<span property="itemListElement" typeof="ListItem"><a property="item" typeof="WebPage" title="Go to %title%." href="%link%" class="%type%"><span class="fas fa-home"></span><span property="name">%htitle%</span></a><meta property="position" content="%position%"></span>';
		$bcn_options['Hhome_template_no_anchor'] = '<span property="itemListElement" typeof="ListItem"><span class="fas fa-home"></span><span property="name">%htitle%</span><meta property="position" content="%position%"></span>';
		$options['bcn_options'] = $bcn_options;
	}
}

// LearnDash settings
if ( defined( 'LEARNDASH_VERSION' ) ) {
    $options['learndash_settings_courses_themes'] = array(
        'active_theme' => 'ld30'
	);

    $options['learndash_settings_theme_ld30'] = array(
        'color_primary' => $primary_color,
        'color_secondary' => '',
        'color_tertiary' => '',
        'focus_mode_enabled' => 'yes',
        'focus_mode_content_width' => 'default',
        'login_mode_enabled' => 0,
        'login_logo' => $demo_image_logo_url
    );
    
    $options['learndash_settings_courses_builder'] = array(
        'enabled' => 'yes',
        'per_page' => 25,
        'shared_steps' => 'yes'
    );
    
    $options['learndash_settings_per_page'] = array(
        'per_page' => 9
    );
}

// Event Calendar Settings
if ( defined( 'TRIBE_EVENTS_FILE' ) ) {
    $tribe_options = get_option( 'tribe_events_calendar_options' );
    if ( isset( $tribe_options ) && is_array( $tribe_options ) ) {
        $tribe_options['stylesheetOption'] = 'skeleton';
        $tribe_options['stylesheet_mode'] = 'skeleton';
        $tribe_options['hideSubsequentRecurrencesDefault'] = true;
        $tribe_options['views_v2_enabled'] = false;
        $tribe_options['tribeEventsTemplate'] = '';
        $options['tribe_events_calendar_options'] = $tribe_options;
    }
}

// Spirit Framework settings
$options['enable_login_registration'] = 1;

// Update database options
SF_Demo_Installer::update_options( $options );

// Set homepage & blog page
$demo_homepage = SF_Demo_Installer::get_data_value( 'page_homepage' );
$demo_blog_page = SF_Demo_Installer::get_data_value( 'page_blog' );

SF_Demo_Installer::set_homepage( array(
    // 'show_on_front' => 'posts',
    'show_on_front' => 'page',
    'page_on_front' => $demo_homepage,
    'page_for_posts' => $demo_blog_page
) );

SF_Demo_Installer::add_record( 'options', 'options' );