<?php

SF_Demo_Installer::add_widget_to_sidebar(
    'topbar-left',
    'custom_html',
    array(
        'title' => '',
        'content' => '<ul><li><a href="tel:00123456789"><i class="fas fa-phone"></i>Hotline 0123456789</a></li><li><a href="mailto:info@talemy.com"><i class="far fa-envelope"></i>info@talemy.com</a></li></ul>'
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'topbar-right',
    'sf-social-icons',
    array(
        'title' => '',
        'url_source' => 'mods',
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'default-sidebar',
    'search',
    array(
        'title' => ''
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'default-sidebar',
    'recent-posts',
    array(
        'title' => '',
        'number' => 5,
        'show_date' => false
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'default-sidebar',
    'categories',
    array(
        'title' => '',
        'count' => false,
        'hierarchical' => false,
        'dropdown' => false
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'default-sidebar',
    'tag-cloud',
    array()
);

$demo_logo_id = SF_Demo_Installer::get_data_value( 'image_logo_light' );
$demo_logo_url = '';

if ( !empty( $demo_logo_id ) ) {
    $demo_logo = wp_get_attachment_image_src( $demo_logo_id, 'full' );
    $demo_logo_url = !empty( $demo_logo ) ? $demo_logo[0] : '';
}

SF_Demo_Installer::add_widget_to_sidebar(
    'footer-top',
    'sf-about-site',
    array(
        'title' => '',
        'logo' => $demo_logo_url,
        'retina_logo' => '',
        'logo_width' => 135,
        'logo_height' => 43,
        'description' => '',
        'show_social' => 1
    )
);

/** Mailchimp **/

if ( defined( 'MC4WP_VERSION' ) ) {
    $demo_img_email_icon_id = SF_Demo_Installer::add_media_image( 'image_email_icon', 'https://talemy.themespirit.com/online-learning/wp-content/uploads/sites/6/2019/02/newsletter_blue.png' );
    $demo_img_email_icon = wp_get_attachment_image_src( $demo_img_email_icon_id, 'full' );

	SF_Demo_Installer::add_custom_post_type( '', array(
			'title' => 'mail form 3',
			'post_type' => 'mc4wp-form',
			'post_content' => '<div class="row footer-newsletter-1">
  <div class="col-md-4">
    <h4 class="newsletter-title" style="background-image:url('. $demo_img_email_icon[0] .');"><span>OUR NEWSLETTER</span></h4>
  </div>
  <div class="col-md-8">
    <div class="newsletter-form">
    	<input type="email" name="EMAIL" placeholder="E-mail Address" required />
    	<button type="submit" class="btn btn-sm btn-secondary sf-submit">Subscribe Now</button>
    </div>
  </div>
</div>'
    ));
    
    SF_Demo_Installer::add_widget_to_sidebar(
        'footer-bottom',
        'mc4wp_form_widget',
        array(
            'title' => ''
        )
    );
}

/** Footer menus **/
$demo_footer_menu_1 = SF_Demo_Installer::add_menu( 'demo-footer-menu-1' );
$demo_footer_menu_2 = SF_Demo_Installer::add_menu( 'demo-footer-menu-2' );
$demo_footer_menu_3 = SF_Demo_Installer::add_menu( 'demo-footer-menu-3' );

$demo_page_faqs = SF_Demo_Installer::get_data_value( 'page_faqs' );
$demo_page_contact = SF_Demo_Installer::get_data_value( 'page_contact_us' );

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_1, array(
    'parent_id' => 0,
    'title' => 'Admission',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_1, array(
    'parent_id' => 0,
    'title' => 'Academics',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_1, array(
    'parent_id' => 0,
    'title' => 'Alumni',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_1, array(
    'parent_id' => 0,
    'title' => 'Research',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_1, array(
    'parent_id' => 0,
    'title' => 'Students',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_2, array(
    'parent_id' => 0,
    'title' => 'History & Mission',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_2, array(
    'parent_id' => 0,
    'title' => 'Administration',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_2, array(
    'parent_id' => 0,
    'title' => 'Campus Direction',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_2, array(
    'parent_id' => 0,
    'title' => 'Employment',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_2, array(
    'parent_id' => 0,
    'title' => 'Around The World',
    'url' => '#'
));

if ( !empty( $demo_page_faqs ) ) {
    SF_Demo_Installer::add_menu_item_page( $demo_footer_menu_3, array(
        'parent_id' => 0,
        'post_id' => $demo_page_faqs,
        'title' => 'FAQs'
    ));
}

if ( !empty( $demo_page_contact ) ) {
    SF_Demo_Installer::add_menu_item_page( $demo_footer_menu_3, array(
        'parent_id' => 0,
        'post_id' => $demo_page_contact,
        'title' => 'Contact Us'
    ));
}

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_3, array(
    'parent_id' => 0,
    'title' => 'Privacy Policy',
    'url' => '#'
));

SF_Demo_Installer::add_menu_item_link( $demo_footer_menu_3, array(
    'parent_id' => 0,
    'title' => 'Terms and Conditions',
    'url' => '#'
));

SF_Demo_Installer::add_widget_to_sidebar(
    'footer-1',
    'nav_menu',
    array(
        'title' => 'Admission',
        'nav_menu' => $demo_footer_menu_1
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'footer-2',
    'nav_menu',
    array(
        'title' => 'Explore',
        'nav_menu' => $demo_footer_menu_2
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'footer-3',
    'nav_menu',
    array(
        'title' => 'Help',
        'nav_menu' => $demo_footer_menu_3
    )
);

SF_Demo_Installer::add_widget_to_sidebar(
    'footer-4',
    'sf-contact-info',
    array(
        'title' => 'Get In Touch',
        'item_icon_1' => 'fas fa-map-marker-alt',
        'item_text_1' => '205 West 21th Street, MIAMI FL, USA',
        'item_icon_2' => 'fas fa-phone',
        'item_text_2' => '(800) 123-4567',
        'item_icon_3' => 'fas fa-phone',
        'item_text_3' => '(800) 765-4321',
        'item_icon_4' => 'fas fa-envelope',
        'item_text_4' => 'info@talemy.com'
    )
);

$demo_img_map_id = SF_Demo_Installer::add_media_image( 'image_map', 'https://talemy.themespirit.com/online-learning/wp-content/uploads/sites/6/2019/04/map_blue.png' );
$demo_img_map = wp_get_attachment_image_src( $demo_img_map_id, 'full' );

SF_Demo_Installer::add_widget_to_sidebar(
    'footer-5',
    'media_image',
    array(
        'attachment_id' => $demo_img_map_id,
        'url' => $demo_img_map[0],
        'title' => '',
        'size' => 'full',
        'width' => 242,
        'height' => 157,
        'caption' => '',
        'alt' => '',
        'link_type' => 'custom',
        'link_url' => '',
        'image_classes' => '',
        'link_classes' => '',
        'link_rel' => '',
        'link_target_blank' => false,
        'image_title' => ''
    )
);