<?php
/**
 * Template used for single membership post type
 *
 * @package Talemy
 * @subpackage Templates
 */

get_header();

do_action( 'talemy_content_start' );

do_action( 'talemy_content_banner' );

if ( have_posts() ) : the_post();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'thin-width' ); ?>>
    <div class="article-content">
        <div class="container">
            <div class="main">
                <?php do_action( 'talemy_before_main_content' ); ?>
                <?php if ( '' !== talemy_get_setting( 'banner' ) ) : ?>
                    <div class="post-header">
                        <h1 class="post-title" ><?php the_title(); ?></h1>
                    </div>
                <?php endif; ?>
                <div class="post-content">
                    <div class="content"><?php the_content(); ?></div>
                    <?php talemy_link_pages(); ?>
                </div>
                <?php if ( comments_open() ) : ?>
                <?php comments_template(); ?>
                <?php endif; ?>
                <?php do_action( 'talemy_after_main_content' ); ?>
                <?php do_action( 'talemy_sidebar' ); ?>
            </div>
        </div>
    </div>
</article>
<?php
endif;

do_action( 'talemy_content_end' );

get_footer(); ?>
