<?php
/**
 * Course & Membership Instructors Block
 *
 * @package LifterLMS/Templates/Shared
 *
 * @since 4.11.0
 * @version 4.11.0
 *
 * @param LLMS_Post_Model $llms_post   Instance of the LLMS_Post_Model for the current screen.
 * @param array[]         $instructors Array of instructor data from the post's `get_instructors()` method.
 * @param int             $count       Number of instructors found in the `$instructors` array.
 */

defined( 'ABSPATH' ) || exit;
?>
<section class="llms-instructor-info">
	<h3 class="llms-meta-title">
		<?php echo apply_filters(
			'llms_instructors_info_title',
			// Translators: %s = The singular name of the post type, eg: "Course".
			sprintf( _n( '%s Instructor', '%s Instructors', $count, 'talemy' ), $llms_post->get_post_type_label() ),
			$llms_post,
			$count
		);
		?>
	</h3>
	<div class="llms-instructors author-boxes">
		<?php
		foreach ( $instructors as $instructor ) {
			echo talemy_get_llms_author_box( [
				'avatar_size' => 72,
				'label'       => $instructor['label'],
				'user_id'     => $instructor['id']
			] );
		}
		?>
	</div>
</section>
