<?php
/**
 * Template for a lesson preview element
 *
 * @author LifterLMS
 * @package LifterLMS/Templates
 *
 * @since 1.0.0
 * @since 3.19.2 Unknown.
 * @since 4.4.0 Use the passed `$order` param if available, in favor of retrieving the lesson's order post meta.
 * @version 4.4.0
 */
defined( 'ABSPATH' ) || exit;

$restrictions = llms_page_restricted( $lesson->get( 'id' ), get_current_user_id() );
$context      = isset( $context ) ? $context : '';

if ( $restrictions['is_restricted'] ) {
	$lesson_link_classes = 'llms-lesson-link llms-lesson-link-locked';
	$lesson_link_url     = '#llms-lesson-locked';
} else {
	$lesson_link_classes = 'llms-lesson-link';
	$lesson_link_url     = get_permalink( $lesson->get( 'id' ) );
}
if ( get_the_ID() === $lesson->get( 'id' ) ) {
	$lesson_link_classes .= ' llms-current-lesson';
}
?>

<div class="llms-lesson-preview<?php echo esc_attr( $lesson->get_preview_classes() ); ?>">
	<a class="<?php echo esc_attr( $lesson_link_classes ); ?>" href="<?php echo esc_url( $lesson_link_url ); ?>"<?php if ( $restrictions['is_restricted'] ) : ?> data-tooltip-msg="<?php echo esc_html( strip_tags( llms_get_restriction_message( $restrictions ) ) ); ?>"<?php endif; ?>>

		<?php if ( 'course' === get_post_type( get_the_ID() ) || 'focus_navigation' === $context ) : ?>

			<?php if ( apply_filters( 'llms_display_outline_thumbnails', true ) ) : ?>
				<?php if ( has_post_thumbnail( $lesson->get( 'id' ) ) ) : ?>
					<div class="llms-lesson-thumbnail">
						<?php echo get_the_post_thumbnail( $lesson->get( 'id' ) ); ?>
					</div>
				<?php endif; ?>
			<?php endif; ?>

			<aside class="llms-extra">
				<?php if ( 'focus_navigation' !== $context ) : ?>
					<span class="llms-lesson-counter"><?php printf( _x( '%1$d of %2$d', 'lesson order within section', 'talemy' ), isset( $order ) ? $order : $lesson->get_order(), $total_lessons ); ?></span>
				<?php endif; ?>
				<?php echo wp_kses( $lesson->get_preview_icon_html(), [
					'span' => [ 'class' => true ],
					'i' => [ 'class' => true, 'aria-hidden' => true, 'aria-label' => true ],
				] ); ?>
			</aside>

		<?php endif; ?>

		<section class="llms-main">
			<?php if ( 'lesson' === get_post_type( get_the_ID() ) && ! empty( $pre_text ) ) : ?>
				<h6 class="llms-pre-text"><?php echo esc_html( $pre_text ); ?></h6>
			<?php endif; ?>
			<h5 class="llms-h5 llms-lesson-title"><?php echo get_the_title( $lesson->get( 'id' ) ); ?></h5>
			<?php if ( apply_filters( 'llms_show_preview_excerpt', true ) && llms_get_excerpt( $lesson->get( 'id' ) ) ) : ?>
				<div class="llms-lesson-excerpt"><?php echo llms_get_excerpt( $lesson->get( 'id' ) ); ?></div>
			<?php endif; ?>
		</section>
	</a>
</div>
