<?php

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'talemy_body_class' ) ) {
    /**
     * Add extra body class
     */
    function talemy_body_class( $classes ) {
        $menu_icons_position = talemy_get_option( 'menu_icons_position' );
        $classes[]           = 'menu-icons-pos-' . $menu_icons_position;
        $classes[]           = 'header-v' . talemy_get_option( 'header_style' );

        $global_header_position = talemy_get_option( 'header_position' );
        $page_header_position   = is_page() ? get_post_meta( get_the_ID(), '_sf_header_position', true ) : '';
        $sticky_mode            = talemy_get_option( 'nav_sticky_style' );

        if ( 'default' != $page_header_position && ( 'absolute' == $page_header_position || 'absolute' == $global_header_position ) ) {
            $classes[] = 'header-position-absolute';
        }

        if ( in_array( $sticky_mode, [ 'always', 'smart' ] ) ) {
            $classes[] = 'nav-sticky-mode-' . $sticky_mode;
        }

        $loader_style = talemy_get_option( 'page_loader' );
        if ( ! empty( $loader_style ) && 'none' != $loader_style ) {
            $classes[] = 'page-loading';
        }

        $corner_style = talemy_get_option( 'corner_style' );
        if ( ! empty( $corner_style ) ) {
            $classes[] = 'style-' . $corner_style . '-corner';
        }

        if ( talemy_get_option( 'loop_thumb_placeholder' ) ) {
            $classes[] = 'thumb-placeholder-active';
        }

        $footer_title_style = talemy_get_option( 'footer_title_style' );
        if ( ! empty( $footer_title_style ) ) {
            $classes[] = 'footer-title-style-' . $footer_title_style;
        }

        return $classes;
    }
}

if ( ! function_exists( 'talemy_output_before_page' ) ) {
	/**
	 * Output before page
	 */
	function talemy_output_before_page() {
		// talemy_page_loader();
		get_template_part( 'templates/off-canvas-left' );
		get_template_part( 'templates/off-canvas-right' );
        // echo '<div class="site-overlay"></div>';
    }
}

if ( ! function_exists( 'talemy_output_header' ) ) {
    /**
     * Output site header
     */
    function talemy_output_header() {
        get_template_part( 'templates/header/header', talemy_get_option( 'header_style' ) );
    }
}

if ( ! function_exists( 'talemy_output_footer' ) ) {
    /**
     * Output site footer
     */
    function talemy_output_footer() {
        ?>
		<footer id="footer" class="footer">
            <?php get_template_part( 'templates/footer/footer', 'top' ); ?>
            <?php get_template_part( 'templates/footer/footer', 'bottom' ); ?>
		</footer><!-- .footer -->
        <?php
    }
}


if ( ! function_exists( 'talemy_output_content_wrapper_start' ) ) {
    /**
     * Output the start of the page wrapper.
     */
    function talemy_output_content_wrapper_start() {
        get_template_part( 'templates/global/wrapper-start' );
    }
}

if ( ! function_exists( 'talemy_output_content_wrapper_end' ) ) {
    /**
     * Output the end of the page wrapper.
     */
    function talemy_output_content_wrapper_end() {
        get_template_part( 'templates/global/wrapper-end' );
    }
}

if ( ! function_exists( 'talemy_output_container_start' ) ) {
    /**
     * Output the start of the page wrapper.
     */
    function talemy_output_container_start() {
        if ( 'container' == talemy_get_setting( 'container' ) ) {
            echo '<div class="container">';
        }
    }
}

if ( ! function_exists( 'talemy_output_container_end' ) ) {
    /**
     * Output the end of the page wrapper.
     */
    function talemy_output_container_end() {
        if ( 'container' == talemy_get_setting( 'container' ) ) {
            echo '</div>';
        }
    }
}

if ( ! function_exists( 'talemy_output_before_main_content' ) ) {
    /**
     * Output before the main content.
     */
    function talemy_output_before_main_content() {
        switch ( talemy_get_setting( 'layout' ) ) {
        case 'sidebar-left':
            echo '<div class="row flex-row-reverse lg-gutters">';
            echo '<div class="col-lg-9">';
            break;
        case 'sidebar-right':
            echo '<div class="row lg-gutters">';
            echo '<div class="col-lg-9">';
            break;
        }
        if ( is_author() ) {
            get_template_part( 'templates/author-box' );
        }
    }
}

if ( ! function_exists( 'talemy_output_after_main_content' ) ) {
    /**
     * Output after the main content.
     */
    function talemy_output_after_main_content() {
        switch ( talemy_get_setting( 'layout' ) ) {
        case 'sidebar-left':
        case 'sidebar-right':
            echo '</div>';
            break;
        }
    }
}

if ( ! function_exists( 'talemy_output_sidebar' ) ) {
    /**
     * Output the sidebar.
     */
    function talemy_output_sidebar() {
        switch ( talemy_get_setting( 'layout' ) ) {
        case 'sidebar-left':
        case 'sidebar-right':
            echo '<div class="col-lg-3">';
            get_sidebar();
            echo '</div>';
            echo '</div>';
            break;
        }
    }
}

if ( ! function_exists( 'talemy_output_content_banner' ) ) {
    /**
     * Output the content banner.
     */
    function talemy_output_content_banner() {
        get_template_part( 'templates/content-banner' );
    }
}

if ( ! function_exists( 'talemy_output_content_search_bar' ) ) {
    /**
     * Output the content search bar.
     */
    function talemy_output_content_search_bar() {
        if ( ! is_search() ) {
            return;
        }
        $post_type = ! empty( $_GET['post_type'] ) ? $_GET['post_type'] : array();
        ?>
        <div class="content-search">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3">
                        <div class="search-count">
                            <?php printf( _n( 'About 1 Result', 'About %u Results', talemy_get_query()->found_posts, 'talemy' ), talemy_get_query()->found_posts ); ?>
                        </div>
                    </div>
                    <div class="col-lg-9">
                    <?php
                    if ( 'course' == $post_type || ( is_array( $post_type ) && in_array( 'course', $post_type ) ) ) {
                        get_template_part( 'templates/lifterlms/search-form' );
                    } else if ( 'sfwd-courses' == $post_type || ( is_array( $post_type ) && in_array( 'sfwd-courses', $post_type ) ) ) {
                        get_template_part( 'templates/learndash/search-form' );
                    } else {
                        get_search_form();
                    }
                    ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

if ( ! function_exists( 'talemy_output_content_loop' ) ) {
    /**
     * Output the content loop
     */
    function talemy_output_content_loop() {

        talemy_set_list_settings();

        echo '<div class="' . esc_attr( talemy_get_setting( 'list_class' ) ) . '">';

        while ( have_posts() ) {

            the_post();

            $post_type = get_post_type();

            if ( 'course' == $post_type ) {
                get_template_part( 'templates/lifterlms/loop/course/' . talemy_get_setting( 'list_style' ) );
            
            } elseif ( 'llms_membership' == $post_type ) {
                get_template_part( 'templates/lifterlms/loop/membership/' . talemy_get_setting( 'list_style' ) );

            } elseif ( 'sfwd-courses' == $post_type ) {
                get_template_part( 'templates/learndash/loop/' . talemy_get_setting( 'list_style' ) );

            } elseif ( 'groups' == $post_type ) {
                get_template_part( 'templates/learndash/loop-group/' . talemy_get_setting( 'list_style' ) );

            } else {
                get_template_part( 'templates/loop/' . talemy_get_setting( 'list_style' ) );
            }
        }

        echo '</div>';

        if ( talemy_get_query()->max_num_pages > 1 ) {
            get_template_part( 'templates/pagination/' . talemy_get_setting( 'pagination' ) );
        }

        wp_reset_postdata();
        // reset global query
        global $talemy_global_query;
        $talemy_global_query = NULL;
    }
}

if ( ! function_exists( 'talemy_output_post_subtitle' ) ) {
    /**
     * Output post subtitle
     */
    function talemy_output_post_subtitle() {
        $subtitle = talemy_get_post_meta( '_sf_subtitle', '' );
        if ( ! empty( $subtitle ) ): ?>
        <h2 itemprop="description" class="post-subtitle"><?php echo esc_html( $subtitle ); ?></h2>
        <?php endif;
    }
}

if ( ! function_exists( 'talemy_output_before_account_menu' ) ) {
    /**
     * Output before account menu
     *
     * @param object $user_data
     * @return void
     */
    function talemy_output_before_account_menu( $user_data ) {
        ?>
        <a class="user-link" href="<?php echo esc_url( talemy_get_user_page_url() ); ?>">
            <?php echo get_avatar( $user_data->ID, 30 ); ?>
            <span>
                <span class="user-name"><?php echo esc_html( $user_data->first_name ); ?></span>
                <span class="user-mention"><?php echo esc_html( $user_data->user_login ); ?></span>
            </span>
        </a>
        <?php
    }
}

/**
 * Custom logo
 *
 * @param string $html
 * @return string
 */
function talemy_get_custom_logo( $html ) {
    $logo_id        = get_theme_mod( 'custom_logo' );
    $custom_logo_id = apply_filters( 'talemy_logo_id', false );
    $mobile_logo_id = apply_filters( 'talemy_mobile_logo_id', get_theme_mod( 'mobile_logo' ) );
    $mobile_logo_img_html = '';
    
    if ( $custom_logo_id ) {
        $logo_id = $custom_logo_id;
    }

    $logo_img_html = talemy_get_logo_html( $logo_id );
    $mobile_logo_img_html = talemy_get_logo_html( $mobile_logo_id, 'logo logo-alt' );

    if ( ! empty( $logo_img_html ) || ! empty( $mobile_logo_img_html ) ) {
        $html = sprintf(
            '<a href="%1$s" class="logo-link" aria-label="%2$s" rel="home">%3$s</a>',
            esc_url( apply_filters( 'talemy_logo_href' , home_url( '/' ) ) ),
            esc_attr( apply_filters( 'talemy_logo_title', get_bloginfo( 'name', 'display' ) ) ),
            $mobile_logo_img_html . $logo_img_html
        );
    } else if ( is_customize_preview() ) {
        // If no logo is set but we're in the Customizer, leave a placeholder (needed for the live preview).
        $html = sprintf(
            '<a href="%1$s" class="logo-link" style="display:none;"><img class="logo"/></a>',
            esc_url( home_url( '/' ) )
        );
    }

    return $html;
}
add_filter( 'get_custom_logo', 'talemy_get_custom_logo' );

add_filter( 'talemy_logo_id', function( $logo_id ) {
    if ( is_singular() && ! empty( ( $post_logo_id = get_post_meta( get_the_ID(), '_sf_logo', true ) ) ) ) {
        $logo_id = $post_logo_id;
    }
    return $logo_id;
} );

add_filter( 'talemy_mobile_logo_id', function( $logo_id ) {
    if ( is_singular() && ! empty( ( $post_logo_id = get_post_meta( get_the_ID(), '_sf_logo_alt', true ) ) ) ) {
        $logo_id = $post_logo_id;
    }
    return $logo_id;
} );