<?php
/**
 * LifterLMS integration
 *
 * @since   1.2.3
 * @package Talemy/Classes
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! class_exists( 'LifterLMS' ) ) {
    return;
}

require_once( TALEMY_THEME_DIR . 'includes/support/lifterlms/helpers.php' );

class Talemy_LifterLMS {

	/**
	 * Init
	 */
	public static function init() {
		add_action( 'lifterlms_before_main_content', [ __CLASS__, 'output_before_main_content' ] );
		add_action( 'lifterlms_after_main_content', [ __CLASS__, 'output_after_main_content' ] );
		add_post_type_support( 'course', 'excerpt' );
		add_post_type_support( 'llms_membership', 'excerpt' );
		add_action( 'wp_enqueue_scripts', [ __CLASS__, 'enqueue_scripts' ], 9 );
		add_action( 'enqueue_block_editor_assets', [ __CLASS__, 'enqueue_block_editor_scripts' ], 1000 );

		remove_action( 'lifterlms_student_dashboard_header', 'lifterlms_template_student_dashboard_title', 20 );
		add_action( 'lifterlms_before_student_dashboard_content', [ __CLASS__, 'output_before_student_dashboard_content' ], 11 );
		add_action( 'lifterlms_before_student_dashboard_content', 'lifterlms_template_student_dashboard_title', 12 );
		add_action( 'lifterlms_after_student_dashboard', [ __CLASS__, 'output_after_student_dashboard' ], 9 );
		
		add_action( 'talemy_before_content', [ __CLASS__, 'output_before_content_wrapper' ] );
		add_action( 'talemy_after_content', [ __CLASS__, 'output_after_content_wrapper' ] );
	}

	/**
	 * Enqueue scripts
	 *
	 * @return void
	 */
	public static function enqueue_scripts() {
		// Replace default lifterlms styles
		$suffix = ! TALEMY_DEV_MODE ? '.min' : '';
        wp_register_style(
            'lifterlms-styles',
            TALEMY_THEME_URI . 'assets/css/lifterlms' . $suffix . '.css',
            false,
			TALEMY_THEME_VERSION
        );
		wp_enqueue_style( 'lifterlms-styles' );

		if ( is_singular( 'course' ) ) {
			wp_enqueue_style( 'fancybox' );
			wp_enqueue_script( 'fancybox' );
		}
	}

	/**
	 * Enqueue block editor scripts
	 *
	 * @return void
	 */
	public static function enqueue_block_editor_scripts() {
		wp_deregister_style( 'llms-blocks-editor' );
		wp_dequeue_style( 'llms-blocks-editor' );
		wp_enqueue_style( 'llms-blocks-editor', TALEMY_THEME_URI . 'assets/css/admin/llms-blocks-editor.css', [ 'wp-edit-blocks' ], TALEMY_THEME_VERSION );
	}

	/**
	 * Output before content wrapper
	 *
	 * @return void
	 */
	public static function output_before_main_content() {
		?>
		<div class="#content">
			<div class="article-content">
				<div class="container">
		<?php
	}

	/**
	 * Output after content wrapper
	 *
	 * @return void
	 */
	public static function output_after_main_content() {
		?>
				</div>
			</div>
		</div>
		<?php
	}
	
	/**
	 * Output after student dashboard
	 *
	 * @return void
	 */
	public static function output_before_student_dashboard_content() {
		?><div class="llms-sd-main">
		<?php
	}

	/**
	 * Output after student dashboard
	 *
	 * @return void
	 */
	public static function output_after_student_dashboard() {
		?></div><!-- .llms-sd-main -->
		<?php
	}

	/**
	 * Output before content wrapper
	 */
	public static function output_before_content_wrapper() {
		if ( is_singular( [ 'llms_certificate', 'llms_my_certificate' ] ) ) {
			echo '<div id="content">';
		}
	}

	/**
	 * Output after content wrapper
	 */
	public static function output_after_content_wrapper() {
		if ( is_singular( [ 'llms_certificate', 'llms_my_certificate' ] ) ) {
			echo '</div>';
		}
	}
}

Talemy_LifterLMS::init();