<?php
/**
 * The Events Calendar integration
 *
 * @version 1.2.14
 * @since   1.0.0
 * @package Talemy/Classes
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Talemy_Events_Calendar {

	/**
	 * Hooks
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'add_custom_style' ), 99 );
		add_filter( 'tribe_events_mobile_breakpoint', array( $this, 'customize_tribe_events_breakpoint' ) );
		add_filter( 'bcn_breadcrumb_title', array( $this, 'bcn_fix_month_view' ), 10, 3 );
	}

	/**
	 * Add custom style
	 */
	public function add_custom_style() {
		global $post;

		// Checks if we should enqueue frontend assets
		if ( ! ( tribe_is_event_query()
			|| tribe_is_event_organizer()
			|| tribe_is_event_venue()
			|| ( $post instanceof WP_Post && has_shortcode( $post->post_content, 'tribe_events' ) )
		) ) {
			return;
		}
		
		$suffix = !TALEMY_DEV_MODE ? '.min' : '';

		$style_deps = [ 'tribe-events-views-v2-full' ];
		if ( defined( 'EVENTS_CALENDAR_PRO_FILE' ) ) {
			$style_deps[] = 'tribe-events-pro-views-v2-full';
		}

		wp_register_style( 'talemy-events-calendar-style', TALEMY_THEME_URI . 'assets/css/events'. $suffix .'.css', $style_deps );
		
		wp_enqueue_style( 'talemy-events-calendar-style' );
		wp_style_add_data( 'talemy-events-calendar-style', 'rtl', 'replace' );
	}

	/**
	 * Customize breakpoint
	 */
	public function customize_tribe_events_breakpoint() {
	    return 768;
	}

    /**
     * A custom "hack" to override the breadcrumbs on the month view Events page.
     *
     * @param string $title
     * @param string $type
     * @param int $id
     * @return string
     */
    public function bcn_fix_month_view( $title, $type, $id ) {
        // Modify Month View breadcrumbs.
        if ( empty( $title ) && tribe_is_month() ) {
            $title = sprintf( 
                '<a href="%s">%s</a>',
                get_post_type_archive_link( $type ),
                esc_html__( 'Events', 'talemy' )
            );
        }
        return $title;
	}
}

if ( defined( 'TRIBE_EVENTS_FILE' ) ) {
	new Talemy_Events_Calendar();
}
