<?php
/**
 * Learndash Course Reviews integration
 *
 * @since   1.1.7
 * @package Talemy/Classes
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! defined( 'LDCR_PLUGIN_FILE' ) ) {
	return;
}
class Talemy_Course_Reviews {

	/**
	 * Constructor
	 */
	public static function init() {
		add_action( 'ldcr_before_main_content', array( __CLASS__, 'output_before_main_content' ) );
		add_action( 'ldcr_after_main_content', array( __CLASS__, 'output_after_main_content' ) );
		add_filter( 'ldcr_course_rating_hide_not_rated', '__return_true' );
	}

	/**
	 * Output before content wrapper
	 *
	 * @return void
	 */
	public static function output_before_main_content() {
		?>
		<div class="#content">
			<div class="article-content">
				<div class="container">
		<?php
	}

	/**
	 * Output after content wrapper
	 *
	 * @return void
	 */
	public static function output_after_main_content() {
		?>
				</div>
			</div>
		</div>
		<?php
	}

}

Talemy_Course_Reviews::init();