<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Talemy_Course_Search extends Widget_Base {

    public function get_name() {
        return 'talemy-course-search';
    }

    public function get_title() {
        return esc_html__( 'Course Search', 'talemy' );
    }

    public function get_icon() {
        return 'eicon-search sf-addons-label';
    }

    public function get_categories() {
        return array( 'sf-addons' );
    }

    public function get_keywords() {
        return [ 'sf' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'search_content',
            [
                'label' => esc_html__( 'Search Form', 'talemy' ),
            ]
        );

        $this->add_control(
            'placeholder',
            [
                'label' => esc_html__( 'Placeholder', 'talemy' ),
                'type' => Controls_Manager::TEXT,
                'separator' => 'before',
                'default' => esc_html__( 'Search', 'talemy' ) . '...',
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'talemy' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Search', 'talemy' ),
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'ajax_search',
            [
                'label' => esc_html__( 'AJAX Search', 'talemy' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'search_filters',
            [
                'label' => esc_html__( 'Filters', 'talemy' ),
            ]
        );

        $this->add_control(
            'filter_category',
            [
                'label' => esc_html__( 'Category', 'talemy' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
    
        $this->add_control(
            'filter_tag',
            [
                'label' => esc_html__( 'Tag', 'talemy' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        if ( 'learndash' === \Talemy::$lms_plugin ) {
            $this->add_control(
                'filter_price',
                [
                    'label' => esc_html__( 'Price', 'talemy' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'no',
                ]
            );
        }

        $this->end_controls_section();

        $this->start_controls_section(
            'section_input_style',
            [
                'label' => esc_html__( 'Input', 'talemy' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'input_typography',
                'selector' => '{{WRAPPER}} input[type="search"].course-search__input',
            ]
        );

        $this->start_controls_tabs( 'tabs_input_colors' );

        $this->start_controls_tab(
            'tab_input_normal',
            [
                'label' => esc_html__( 'Normal', 'talemy' ),
            ]
        );

        $this->add_control(
            'input_text_color',
            [
                'label' => esc_html__( 'Text Color', 'talemy' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .course-search .course-search__input' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .course-search__input::-webkit-input-placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .course-search__input::-moz-input-placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .course-search__input:-ms-input-placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .selectric' => 'color: {{VALUE}}'
                ],
            ]
        );

        $this->add_control(
            'input_background_color',
            [
                'label' => esc_html__( 'Background Color', 'talemy' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .course-search .course-search__input' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .selectric' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input_border_color',
            [
                'label' => esc_html__( 'Border Color', 'talemy' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .course-search .course-search__input' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .selectric' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .selectric .button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_input_focus',
            [
                'label' => esc_html__( 'Focus', 'talemy' ),
            ]
        );

        $this->add_control(
            'input_text_color_focus',
            [
                'label' => esc_html__( 'Text Color', 'talemy' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .course-search .course-search__input:focus' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .selectric-open .selectric' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input_background_color_focus',
            [
                'label' => esc_html__( 'Background Color', 'talemy' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .course-search .course-search__input:focus' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .selectric-open .selectric' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input_border_color_focus',
            [
                'label' => esc_html__( 'Border Color', 'talemy' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .course-search .course-search__input:focus' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .selectric-open .selectric' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .course-search .selectric-open .selectric .button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'button_border_width',
            [
                'label' => esc_html__( 'Border Size', 'talemy' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .course-search .course-search__input:focus' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .course-search .selectric-open .selectric' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_button_style',
            [
                'label' => esc_html__( 'Search Button', 'talemy' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button_style',
            [
                'label' => esc_html__( 'Button Style', 'talemy' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'primary',
                'options' => sf_get_option_button_styles()
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings     = $this->get_settings_for_display();
        $button_class = !empty( $settings['button_style'] ) ? 'btn btn-block btn-'. $settings['button_style'] : 'btn btn-block btn-primary';
        $form_class   = ( isset( $settings['ajax_search'] ) && 'yes' === $settings['ajax_search'] ) ? 'course-search ajax-search-form has-search-button' : 'course-search has-search-button';

        $filter_counts = 3;
        $show_filter_category = true;
        if ( isset( $settings['filter_category'] ) && 'yes' !== $settings['filter_category'] ) {
            $show_filter_category = false;
            $filter_counts -= 1;
        }
        $show_filter_tag = true;
        if ( isset( $settings['filter_tag'] ) && 'yes' !== $settings['filter_tag'] ) {
            $show_filter_tag = false;
            $filter_counts -= 1;
        }
        $show_filter_price = true;
        if ( 'learndash' === \Talemy::$lms_plugin ) {
            if ( isset( $settings['filter_price'] ) && 'yes' !== $settings['filter_price'] ) {
                $show_filter_price = false;
                $filter_counts -= 1;
            }
        } else {
            $show_filter_price = false;
            $filter_counts -= 1;
        }

        if ( $filter_counts === 3 ) {
            $column_class_filters = 'col-12 col-md-6 col-lg';
            $column_class_input = 'col-12 col-md-6 col-lg';
            $column_class_submit = 'col-12 col-md-12 col-lg';
        } elseif ( $filter_counts === 2 ) {
            $column_class_filters = 'col-12 col-md-6 col-lg';
            $column_class_input = 'col-12 col-md-6 col-lg';
            $column_class_submit = 'col-12 col-md-6 col-lg';
        } elseif ( $filter_counts === 1 ) {
            $column_class_filters = 'col-12 col-md-4 col-lg';
            $column_class_input = 'col-12 col-md-4 col-lg-6';
            $column_class_submit = 'col-12 col-md-4 col-lg';
        } elseif ( $filter_counts === 0 ) {
            $column_class_filters = '';
            $column_class_input = 'col-12 col-md-8';
            $column_class_submit = 'col-12 col-md-4';
        }

        ?>
        <form class="<?php echo esc_attr( $form_class ); ?>" role="search" action="<?php echo esc_url( home_url() ); ?>" method="get">
            <div class="row sm-gutters">
                <?php if ( $show_filter_category ) : ?>
                    <div class="<?php echo esc_attr( $column_class_filters ); ?>">
                        <select name="<?php echo esc_attr( \Talemy::$lms_category ); ?>" class="course-select__category">
                            <option value="" selected><?php esc_html_e( 'All Categories', 'talemy' ); ?></option>
                        <?php foreach ( talemy_get_option_terms( \Talemy::$lms_category, 'slug' ) as $slug => $label ) : ?>
                            <option value="<?php echo esc_attr( $slug ); ?>"><?php echo esc_html( $label ); ?></option>
                        <?php endforeach; ?>
                        </select>
                    </div>
                <?php endif; ?>
                <?php if ( $show_filter_tag ) : ?>
                    <div class="<?php echo esc_attr( $column_class_filters ); ?>">
                        <select name="<?php echo esc_attr( \Talemy::$lms_tag ); ?>" class="course-select__tag">
                            <option value="" selected><?php esc_html_e( 'All Tags', 'talemy' ); ?></option>
                        <?php foreach ( talemy_get_option_terms( \Talemy::$lms_tag, 'slug' ) as $slug => $label ) : ?>
                            <option value="<?php echo esc_attr( $slug ); ?>"><?php echo esc_html( $label ); ?></option>
                        <?php endforeach; ?>
                        </select>
                    </div>
                <?php endif; ?>
                <?php if ( $show_filter_price ) : ?>
                    <div class="<?php echo esc_attr( $column_class_filters ); ?>">
                        <select name="ld_course_price" class="course-select__price">
                            <option value="" selected><?php esc_html_e( 'All Price', 'talemy' ); ?></option>
                            <option value="free"><?php esc_html_e( 'Free', 'talemy' ); ?></option>
                            <option value="paid"><?php esc_html_e( 'Paid', 'talemy' ); ?></option>
                        </select>
                    </div>
                <?php endif; ?>
                <div class="<?php echo esc_attr( $column_class_input ); ?>">
                    <div class="position-relative">
                        <input type="search" name="s" value="<?php echo get_search_query(); ?>" class="course-search__input" placeholder="<?php echo esc_attr( $settings['placeholder'] ); ?>" title="<?php esc_attr_e( 'Search', 'talemy' ) ?>">
                        <input type="hidden" name="post_type" value="<?php echo esc_attr( \Talemy::$lms_course ); ?>">
                        <?php do_action( 'wpml_add_language_form_field' ); ?>
                    </div>
                </div>
                <div class="<?php echo esc_attr( $column_class_submit ); ?>">
                    <button type="submit" class="<?php echo esc_attr( $button_class ); ?>"><?php echo esc_html( $settings['button_text'] ); ?></button>
                </div>
            </div>
        </form>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new Talemy_Course_Search() );