<?php
$logo_dimensions = get_theme_mod( 'logo_dimensions' );
$logo_alt_dimensions = get_theme_mod( 'logo_alt_dimensions' );
$logo_css = '';

if ( is_singular() ) {
	$page_logo  = talemy_get_post_meta( '_sf_logo' );
	if ( $page_logo ) {
		$logo_dimensions = [ 'width'  => talemy_get_post_meta( '_sf_logo_width' ) ];
	}
	$page_logo_alt  = talemy_get_post_meta( '_sf_logo_alt' );
	if ( $page_logo_alt ) {
		$logo_alt_dimensions = [ 'width'  => talemy_get_post_meta( '_sf_logo_alt_width' ) ];
	}
}

if ( ! empty( $logo_dimensions ) && is_array( $logo_dimensions ) ) {
	// logo width and height attribute
	if ( ! empty( $logo_dimensions['width'] ) ) {
		$logo_width = filter_var( $logo_dimensions['width'], FILTER_SANITIZE_NUMBER_INT );
		$logo_css .= '--logo-width: ' . $logo_width . 'px;';
	}

	if ( ! empty( $logo_dimensions['height'] ) ) {
		$logo_height = filter_var( $logo_dimensions['height'], FILTER_SANITIZE_NUMBER_INT );
		$logo_css .= '--logo-height: ' . $logo_height . 'px;';
	}
}

if ( ! empty( $logo_alt_dimensions ) && is_array( $logo_alt_dimensions ) ) {
	// logo width and height attribute
	if ( ! empty( $logo_alt_dimensions['width'] ) ) {
		$logo_alt_width = filter_var( $logo_alt_dimensions['width'], FILTER_SANITIZE_NUMBER_INT );
		$logo_css .= '--logo-alt-width: ' . $logo_alt_width . 'px;';
	}

	if ( ! empty( $logo_alt_dimensions['height'] ) ) {
		$logo_alt_height = filter_var( $logo_alt_dimensions['height'], FILTER_SANITIZE_NUMBER_INT );
		$logo_css .= '--logo-alt-height: ' . $logo_alt_height . 'px;';
	}
}

if ( ! empty( $logo_css ) ) {
	printf( '.logo-wrapper{%s}', $logo_css );
}