<?php

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'Kirki' ) ) {
    return;
}

/**
 * Default font choices.
 *
 * This exists so we can filter and extend the font choices in Kirki.
 *
 * @return array The default font choices.
 */
function talemy_default_font_choices() {
	return array(
		'fonts' => apply_filters( 'sf_kirki_font_choices', [] ),
	);
}

/* Panels & Sections ------------------------------------ */
function talemy_kirki_add_fields() {
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/site-identity.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/global.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/header.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/footer.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/templates.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/social.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/custom-css.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/advanced.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/lms.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/bbpress.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/buddypress.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/events.php' );
    require_once( TALEMY_THEME_DIR . 'includes/customizer/controls/woocommerce.php' );
}
add_action( 'init', 'talemy_kirki_add_fields', 999 );

/* Override Defaults ------------------------------------ */
function talemy_customize_register( $wp_customize ) {
	$wp_customize->get_section( 'title_tagline' )->panel = 'header';
	$wp_customize->get_section( 'title_tagline' )->priority = 9;
	$wp_customize->get_control( 'blogname' )->priority = 15;
	$wp_customize->get_control( 'blogdescription' )->priority = 15;
	$wp_customize->get_control( 'site_icon' )->priority = 10;
}
add_action( 'customize_register', 'talemy_customize_register', 99 );

/* Add custom CSS ------------------------------------ */
function talemy_dynamic_css( $css ) {
    ob_start();
	include TALEMY_THEME_DIR . '/includes/customizer/styles.php';
	$styles = ob_get_clean();
    $css .= $styles;
    $css = apply_filters( 'talemy_custom_css_styles', $css );

    return SF_Fonts::get_frontend_style() . $css . get_theme_mod( 'custom_css', '' );
}
add_filter( 'kirki_global_dynamic_css', 'talemy_dynamic_css' );

/* CSS style output mode ------------------------------------ */
if ( 'file' == talemy_get_option( 'dynamic_css_method' ) ) {
    add_filter( 'kirki_dynamic_css_method', function () {
        return 'file';
    } );
}
