<?php

if ( ! class_exists( 'WooCommerce' ) ) {
	return;
}

$defaults = Talemy_Options::get_default_options();

new \Kirki\Section( 'wc_shop', [
	'title'    => esc_html__( 'Shop', 'talemy' ),
	'panel'    => 'woocommerce',
	'priority' => 9,
] );

new \Kirki\Section( 'wc_product', [
	'title' => esc_html__( 'Product Page', 'talemy' ),
	'panel' => 'woocommerce',
] );

/* Shop page ------------------------------------ */

new \Kirki\Pro\Field\Headline( [
	'settings' => 'wc_heading_layout',
	'label'    => esc_html__( 'Layout', 'talemy' ),
	'section'  => 'wc_shop',
] );

new \Kirki\Field\Radio_Image( [
	'settings' => 'wc_layout',
	'label'    => esc_html__( 'Layout', 'talemy' ),
	'section'  => 'wc_shop',
	'default'  => $defaults['wc_layout'],
	'choices'  => talemy_get_option_layouts(),
] );

new \Kirki\Field\Select( [
	'settings' => 'wc_sidebar',
	'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
	'section'  => 'wc_shop',
	'default'  => $defaults['wc_sidebar'],
	'choices'  => talemy_get_option_sidebars(),
] );

new \Kirki\Pro\Field\Divider(
	[
		'settings' => 'wc_shop_div1',
		'section'  => 'wc_shop',
	]
);

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'wc_shop_sort',
	'label'    => esc_html__( 'Show Sort', 'talemy' ),
	'section'  => 'wc_shop',
	'default'  => $defaults['wc_shop_sort'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'wc_shop_results_count',
	'label'    => esc_html__( 'Show Results Count', 'talemy' ),
	'section'  => 'wc_shop',
	'default'  => $defaults['wc_shop_results_count'],
] );

new \Kirki\Field\Select( [
	'settings' => 'wc_add_to_cart_display',
	'label'    => esc_html__( 'Add to Cart style', 'talemy' ),
	'section'  => 'wc_shop',
	'default'  => $defaults['wc_add_to_cart_display'],
	'choices'  => [
		'hover' => esc_html__( 'Show on Hover', 'talemy' ),
		'always' => esc_html__( 'Show Always', 'talemy' )
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'wc_heading_page_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'wc_shop',
] );

new \Kirki\Field\Select( [
	'settings' => 'wc_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'wc_shop',
	'default'  => $defaults['wc_banner'],
	'choices'  => talemy_get_option_page_banner_options(),
] );

new \Kirki\Field\Image( [
	'settings'        => 'wc_banner_image',
	'label'           => esc_html__( 'Banner Image', 'talemy' ),
	'section'         => 'wc_shop',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'wc_banner',
			'operator' => '==',
			'value'    => '',
		],
	],
	'output'          => [
		[
			'element'  => ['.content-banner'],
			'property' => 'background-image',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'wc_banner_shortcode',
	'label'           => esc_html__( 'Banner Shortcode', 'talemy' ),
	'section'         => 'wc_shop',
	'active_callback' => [
		[
			'setting'  => 'wc_banner',
			'operator' => '==',
			'value'    => 'shortcode',
		],
	],
] );

/* Product Page ------------------------------------ */

new \Kirki\Field\Radio_Image( [
	'settings' => 'wc_product_layout',
	'label'    => esc_html__( 'Layout', 'talemy' ),
	'section'  => 'wc_product',
	'default'  => $defaults['wc_product_layout'],
	'choices'  => talemy_get_option_layouts(),
] );

new \Kirki\Field\Select( [
	'settings' => 'wc_product_sidebar',
	'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
	'section'  => 'wc_product',
	'default'  => $defaults['wc_product_sidebar'],
	'choices'  => talemy_get_option_sidebars(),
] );

new \Kirki\Field\Select( [
	'settings' => 'wc_product_button_style',
	'label'    => esc_html__( 'Add To Cart Button Style', 'talemy' ),
	'section'  => 'wc_product',
	'default'  => $defaults['wc_product_button_style'],
	'choices'  => [
		'text' => esc_html__( 'Text', 'talemy' ),
		'icon' => esc_html__( 'Icon', 'talemy' ),
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'wc_product_heading_page_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'wc_product',
] );

new \Kirki\Field\Select( [
	'settings' => 'wc_product_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'wc_product',
	'default'  => $defaults['wc_product_banner'],
	'choices'  => talemy_get_option_page_banner_options(),
] );

new \Kirki\Field\Image( [
	'settings'        => 'wc_product_banner_image',
	'label'           => esc_html__( 'Banner Image', 'talemy' ),
	'section'         => 'wc_product',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'wc_product_banner',
			'operator' => '==',
			'value'    => '',
		],
	],
	'output'          => [
		[
			'element'  => ['.single-product .content-banner'],
			'property' => 'background-image',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'wc_product_banner_shortcode',
	'label'           => esc_html__( 'Banner Shortcode', 'talemy' ),
	'section'         => 'wc_product',
	'active_callback' => [
		[
			'setting'  => 'wc_product_banner',
			'operator' => '==',
			'value'    => 'shortcode',
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'wc_product_heading_related',
	'label'    => esc_html__( 'Related Products', 'talemy' ),
	'section'  => 'wc_product',
] );

new \Kirki\Field\Slider( [
	'settings' => 'wc_related_columns',
	'label'    => esc_html__( 'Related Products Columns', 'talemy' ),
	'section'  => 'wc_product',
	'default'  => $defaults['wc_related_columns'],
	'choices'  => [
		'min'  => 0,
		'max'  => 6,
		'step' => 1,
	],
] );

new \Kirki\Field\Number( [
	'settings' => 'wc_related_count',
	'label'    => esc_html__( 'Related Products Count', 'talemy' ),
	'section'  => 'wc_product',
	'default'  => $defaults['wc_related_count'],
	'choices'  => [
		'min'  => 0,
		'step' => 1,
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'wc_product_heading_upsell',
	'label'    => esc_html__( 'Upsell Products', 'talemy' ),
	'section'  => 'wc_product',
] );

new \Kirki\Field\Slider( [
	'settings' => 'wc_upsell_columns',
	'label'    => esc_html__( 'Upsell Products Columns', 'talemy' ),
	'section'  => 'wc_product',
	'default'  => $defaults['wc_upsell_columns'],
	'choices'  => [
		'min'  => 0,
		'max'  => 6,
		'step' => 1,
	],
] );

new \Kirki\Field\Number( [
	'settings' => 'wc_upsell_count',
	'label'    => esc_html__( 'Upsell Products Count', 'talemy' ),
	'section'  => 'wc_product',
	'default'  => $defaults['wc_upsell_count'],
	'choices'  => [
		'min'  => 0,
		'step' => 1,
	],
] );