<?php

$defaults = Talemy_Options::get_default_options();

new \Kirki\Panel( 'templates', [
	'title'    => esc_html__( 'Templates', 'talemy' ),
	'priority' => 23,
] );

new \Kirki\Section( 'template_post', [
	'title' => esc_html__( 'Post', 'talemy' ),
	'panel' => 'templates',
] );

new \Kirki\Section( 'template_page', [
	'title' => esc_html__( 'Page', 'talemy' ),
	'panel' => 'templates',
] );

new \Kirki\Section( 'template_category', [
	'title' => esc_html__( 'Category', 'talemy' ),
	'panel' => 'templates',
] );

new \Kirki\Section( 'template_tag', [
	'title' => esc_html__( 'Tag', 'talemy' ),
	'panel' => 'templates',
] );

new \Kirki\Section( 'template_author', [
	'title' => esc_html__( 'Author', 'talemy' ),
	'panel' => 'templates',
] );

new \Kirki\Section( 'template_archive', [
	'title' => esc_html__( 'Archive', 'talemy' ),
	'panel' => 'templates',
] );

new \Kirki\Section( 'template_search', [
	'title' => esc_html__( 'Search', 'talemy' ),
	'panel' => 'templates',
] );

new \Kirki\Section( 'template_home', [
	'title' => esc_html__( 'Blog', 'talemy' ),
	'panel' => 'templates',
] );

new \Kirki\Section( 'template_attachment', [
	'title' => esc_html__( 'Attachment', 'talemy' ),
	'panel' => 'templates',
] );

new \Kirki\Section( 'template_error', [
	'title' => esc_html__( '404 Page', 'talemy' ),
	'panel' => 'templates',
] );

/* Post ------------------------------------ */

new \Kirki\Field\Radio_Image( [
	'settings' => 'post_style',
	'label'    => esc_html__( 'Global Post Style', 'talemy' ),
	'section'  => 'template_post',
	'default'  => '2',
	'choices'  => talemy_get_option_post_styles(),
] );

new \Kirki\Field\Radio_Image( [
	'settings' => 'post_layout',
	'label'    => esc_html__( 'Content Layout', 'talemy' ),
	'section'  => 'template_post',
	'default'  => 'sidebar-right',
	'choices'  => talemy_get_option_post_layouts(),
] );

new \Kirki\Field\Select( [
	'settings' => 'post_sidebar',
	'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
	'section'  => 'template_post',
	'default'  => 'default-sidebar',
	'choices'  => talemy_get_option_sidebars(),
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'post_heading_1',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'template_post',
	'priority' => 10,
] );

new \Kirki\Field\Select( [
	'settings' => 'post_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'template_post',
	'default'  => '',
	'choices'  => talemy_get_option_page_banner_options(),
] );

new \Kirki\Field\Image( [
	'settings'        => 'post_banner_image',
	'label'           => esc_html__( 'Banner Image', 'talemy' ),
	'section'         => 'template_post',
	'default'         => '',
	'transport'       => 'auto',
	'active_callback' => [
		[
			'setting'  => 'post_banner',
			'operator' => '==',
			'value'    => '',
		],
	],
	'output'          => [
		[
			'element'  => [ '.single-post .content-banner' ],
			'property' => 'background-image',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'post_banner_shortcode',
	'label'           => esc_html__( 'Banner Shortcode', 'talemy' ),
	'section'         => 'template_post',
	'active_callback' => [
		[
			'setting'  => 'post_banner',
			'operator' => '==',
			'value'    => 'shortcode',
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'post_heading_2',
	'label'    => esc_html__( 'Post Settings', 'talemy' ),
	'section'  => 'template_post',
	'priority' => 10,
] );

new \Kirki\Field\Multicheck( [
	'settings' => 'post_meta_data',
	'label'    => esc_html__( 'Meta Data', 'talemy' ),
	'section'  => 'template_post',
	'default'  => [ 'avatar', 'author', 'date', 'cats', 'comment' ],
	'choices'  => [
		'avatar'  => esc_html__( 'Avatar', 'talemy' ),
		'author'  => esc_html__( 'Author', 'talemy' ),
		'date'    => esc_html__( 'Date', 'talemy' ),
		'cats'    => esc_html__( 'Categories', 'talemy' ),
		'comment' => esc_html__( 'Comment Count', 'talemy' ),
	],
] );

new \Kirki\Field\Select( [
	'settings' => 'post_time_filter',
	'label'    => esc_html__( 'Time Filter ( Time Ago )', 'talemy' ),
	'section'  => 'template_post',
	'default'  => '86400',
	'choices'  => [
		'none'     => esc_html__( 'None', 'talemy' ),
		'86400'    => esc_html__( '1 Day', 'talemy' ),
		'604800'   => esc_html__( '1 Week', 'talemy' ),
		'2592000'  => esc_html__( '1 Month', 'talemy' ),
		'7776000'  => esc_html__( '3 Months', 'talemy' ),
		'15552000' => esc_html__( '6 Months', 'talemy' ),
		'31536000' => esc_html__( '1 Year', 'talemy' ),
	],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'post_tags',
	'label'    => esc_html__( 'Show Post Tags', 'talemy' ),
	'section'  => 'template_post',
	'default'  => 1,
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'post_adjacent',
	'label'    => esc_html__( 'Show Next & Previous Posts', 'talemy' ),
	'section'  => 'template_post',
	'default'  => 1,
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'post_adjacent_same_term',
	'label'    => esc_html__( 'Next & Previous posts in the same category', 'talemy' ),
	'section'  => 'template_post',
	'default'  => 0,
	'active_callback' => [
		[
			'setting'  => 'post_adjacent',
			'operator' => '==',
			'value'    => true,
		],
	],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'post_author_box',
	'label'    => esc_html__( 'Show Author Box', 'talemy' ),
	'section'  => 'template_post',
	'default'  => 1,
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'post_comments',
	'label'    => esc_html__( 'Show Post Comments', 'talemy' ),
	'section'  => 'template_post',
	'default'  => 1,
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'post_share',
	'label'    => esc_html__( 'Show Social Share Buttons', 'talemy' ),
	'section'  => 'template_post',
	'default'  => true,
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'post_related',
	'label'    => esc_html__( 'Show Related Posts', 'talemy' ),
	'section'  => 'template_post',
	'default'  => 1,
] );

new \Kirki\Field\Select( [
	'settings' => 'post_related_type',
	'label'    => esc_html__( 'Related Type', 'talemy' ),
	'section'  => 'template_post',
	'default'  => '',
	'choices'  => [
		'cat'        => esc_html__( 'Category', 'talemy' ),
		'tag'        => esc_html__( 'Tag', 'talemy' ),
		'cat_or_tag' => esc_html__( 'Category or Tag', 'talemy' ),
		'author'     => esc_html__( 'Author', 'talemy' ),
		'rand'       => esc_html__( 'All ( Random Order )', 'talemy' ),
		''           => esc_html__( 'All', 'talemy' ),
	],
] );

new \Kirki\Field\Number( [
	'settings' => 'post_related_count',
	'label'    => esc_html__( 'Number of related posts', 'talemy' ),
	'section'  => 'template_post',
	'default'  => 3,
	'choices'  => [
		'min'  => 0,
		'step' => 1,
	],
] );

/* Page ------------------------------------ */

new \Kirki\Field\Radio_Image( [
	'settings' => 'page_layout',
	'label'    => esc_html__( 'Content Layout', 'talemy' ),
	'section'  => 'template_page',
	'default'  => 'sidebar-right',
	'choices'  => talemy_get_option_layouts(),
] );

new \Kirki\Field\Select( [
	'settings' => 'page_sidebar',
	'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
	'section'  => 'template_page',
	'default'  => 'default-sidebar',
	'choices'  => talemy_get_option_sidebars(),
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'page_comments',
	'label'    => esc_html__( 'Show Comments', 'talemy' ),
	'section'  => 'template_page',
	'default'  => true,
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'page_heading_1',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'template_page',
	'priority' => 10,
] );

new \Kirki\Field\Select( [
	'settings' => 'page_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'template_page',
	'default'  => '',
	'choices'  => talemy_get_option_page_banner_options(),
] );

new \Kirki\Field\Image( [
	'settings'        => 'page_banner_image',
	'label'           => esc_html__( 'Banner Image', 'talemy' ),
	'section'         => 'template_page',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'page_banner',
			'operator' => '==',
			'value'    => '',
		],
	],
	'output'          => [
		[
			'element'  => [ '.single-post .content-banner' ],
			'property' => 'background-image',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'page_banner_shortcode',
	'label'           => esc_html__( 'Banner Shortcode', 'talemy' ),
	'section'         => 'template_page',
	'active_callback' => [
		[
			'setting'  => 'page_banner',
			'operator' => '==',
			'value'    => 'shortcode',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings' => 'home_title',
	'label'    => esc_html__( 'Blog Title', 'talemy' ),
	'section'  => 'template_home',
	'default'  => esc_html__( 'Blog', 'talemy' ),
] );

/* Archives ------------------------------------ */

$templates = [ 'archive', 'author', 'home', 'category', 'tag', 'search' ];

foreach ( $templates as $template ) {

	new \Kirki\Field\Radio_Image( [
		'settings' => $template . '_layout',
		'label'    => esc_html__( 'Content Layout', 'talemy' ),
		'section'  => 'template_' . $template,
		'default'  => 'sidebar-right',
		'choices'  => talemy_get_option_layouts(),
	] );

	new \Kirki\Field\Select( [
		'settings' => $template . '_sidebar',
		'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
		'section'  => 'template_' . $template,
		'default'  => 'default-sidebar',
		'choices'  => talemy_get_option_sidebars(),
	] );

	new \Kirki\Pro\Field\Headline( [	
		'settings' => $template . '_heading_1',
		'label'    => esc_html__( 'List', 'talemy' ),
		'section'  => 'template_' . $template,
		'priority' => 10,
	] );

	new \Kirki\Field\Select( [
		'settings' => $template . '_list_style',
		'label'    => esc_html__( 'Listing Style', 'talemy' ),
		'section'  => 'template_' . $template,
		'default'  => 'list',
		'choices'  => talemy_get_option_list_styles(),
	] );

	new \Kirki\Field\Select( [
		'settings' => $template . '_thumb_size',
		'label'    => esc_html__( 'Image Size', 'talemy' ),
		'section'  => 'template_' . $template,
		'default'  => 'talemy_thumb_small',
		'choices'  => talemy_get_option_image_sizes(),
	] );

	new \Kirki\Field\Select( [
		'settings'        => $template . '_columns',
		'label'           => esc_html__( 'Columns', 'talemy' ),
		'section'         => 'template_' . $template,
		'default'         => '3',
		'choices'         => talemy_get_option_columns(),
		'active_callback' => [
			[
				'setting'  => $template . '_list_style',
				'operator' => 'in',
				'value'    => [ 'grid', 'masonry' ],
			],
		],
	] );

	new \Kirki\Field\Select( [
		'settings'        => $template . '_tablet_columns',
		'label'           => esc_html__( 'Tablet Columns', 'talemy' ),
		'section'         => 'template_' . $template,
		'default'         => '2',
		'choices'         => talemy_get_option_tablet_columns(),
		'active_callback' => [
			[
				'setting'  => $template . '_list_style',
				'operator' => 'in',
				'value'    => [ 'grid', 'masonry' ],
			],
		],
	] );

	new \Kirki\Field\Select( [
		'settings'        => $template . '_mobile_columns',
		'label'           => esc_html__( 'Mobile Columns', 'talemy' ),
		'section'         => 'template_' . $template,
		'default'         => '1',
		'choices'         => talemy_get_option_mobile_columns(),
		'active_callback' => [
			[
				'setting'  => $template . '_list_style',
				'operator' => 'in',
				'value'    => [ 'grid', 'masonry' ],
			],
		],
	] );

	new \Kirki\Pro\Field\Headline( [	
		'settings' => $template . '_heading_2',
		'label'    => esc_html__( 'Page Banner', 'talemy' ),
		'section'  => 'template_' . $template,
		'priority' => 10,
	] );

	new \Kirki\Field\Select( [
		'settings' => $template . '_banner',
		'label'    => esc_html__( 'Page Banner', 'talemy' ),
		'section'  => 'template_' . $template,
		'default'  => $defaults[ $template . '_banner' ],
		'choices'  => talemy_get_option_page_banner_options_page(),
	] );

	new \Kirki\Field\Image( [
		'settings'        => $template . '_banner_image',
		'label'           => esc_html__( 'Banner Image', 'talemy' ),
		'section'         => 'template_' . $template,
		'active_callback' => [
			[
				'setting'  => $template . '_banner',
				'operator' => '==',
				'value'    => '',
			],
		]
	] );

	new \Kirki\Field\Text( [
		'settings'        => $template . '_banner_shortcode',
		'label'           => esc_html__( 'Banner Shortcode', 'talemy' ),
		'section'         => 'template_' . $template,
		'active_callback' => [
			[
				'setting'  => $template . '_banner',
				'operator' => '==',
				'value'    => 'shortcode',
			],
		],
	] );

	new \Kirki\Pro\Field\Headline( [	
		'settings' => $template . '_heading_3',
		'label'    => esc_html__( 'Pagination', 'talemy' ),
		'section'  => 'template_' . $template,
	] );

	new \Kirki\Field\Select( [
		'settings' => $template . '_pagination',
		'label'    => esc_html__( 'Pagination Type', 'talemy' ),
		'section'  => 'template_' . $template,
		'default'  => 'numeric',
		'choices'  => talemy_get_option_pagination_type(),
	] );

	new \Kirki\Field\Number( [
		'settings' => $template . '_ppl',
		'label'    => esc_html__( 'Posts Per Load', 'talemy' ),
		'default'  => 5,
		'section'  => 'template_' . $template,
		'choices'  => [
			'min'  => 0,
			'step' => 1,
		],
	] );

	new \Kirki\Field\Slider( [
		'settings'    => $template . '_max_loads',
		'label'       => esc_html__( 'Max Loads ( Infinite Scroll )', 'talemy' ),
		'description' => esc_html__( 'The number of loads before a load more button will appear. Set 0 to always use infinite scroll.', 'talemy' ),
		'section'     => 'template_' . $template,
		'default'     => 3,
		'choices'     => [
			'min'  => 0,
			'max'  => 50,
			'step' => 1,
		],
	] );
}

/* Attachment ------------------------------------ */

new \Kirki\Field\Radio_Image( [
	'settings' => 'attachment_layout',
	'label'    => esc_html__( 'Content Layout', 'talemy' ),
	'section'  => 'template_attachment',
	'default'  => 'sidebar-right',
	'choices'  => talemy_get_option_layouts(),
] );

new \Kirki\Field\Select( [
	'settings' => 'attachment_sidebar',
	'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
	'section'  => 'template_attachment',
	'default'  => 'default-sidebar',
	'choices'  => talemy_get_option_sidebars(),
] );

/* 404 ------------------------------------ */

new \Kirki\Field\Background( [
	'settings' => 'error_bg',
	'label'    => esc_html__( 'Background', 'talemy' ),
	'section'  => 'template_error',
	'output'   => [ [ 'element' => [ '#error' ] ] ],
] );