<?php

$defaults = Talemy_Options::get_default_options();

if ( ! defined( 'TALEMY_LMS_PLUGIN' ) ) {
	return;
}

if ( 'lifterlms' === Talemy::$lms_plugin ) {
	$lms_plugin  = 'lifterlms';
	$panel_name  = 'lifterlms';
	$panel_label = esc_html__( 'LifterLMS', 'talemy' );
} else if ( 'learndash' === Talemy::$lms_plugin ) {
	$lms_plugin  = 'learndash';
	$panel_name  = 'learndash';
	$panel_label = esc_html__( 'Learndash', 'talemy' );
}

new \Kirki\Panel( $panel_name, [
	'title'    => $panel_label,
	'priority' => 50,
] );

new \Kirki\Section( 'ld_general', [
	'title' => esc_html__( 'General', 'talemy' ),
	'panel' => $panel_name,
] );

new \Kirki\Section( 'ld_courses', [
	'title' => esc_html__( 'Course Archive', 'talemy' ),
	'panel' => $panel_name,
] );

new \Kirki\Section( 'ld_course', [
	'title' => esc_html__( 'Course Single', 'talemy' ),
	'panel' => $panel_name,
	'tabs'  => talemy_get_options_tab_sections(),
] );

new \Kirki\Section( 'ld_lesson', [
	'title' => esc_html__( 'Lesson Single', 'talemy' ),
	'panel' => $panel_name,
] );

new \Kirki\Section( 'ld_memberships', [
	'title' => esc_html__( 'Membership Archive', 'talemy' ),
	'panel' => $panel_name,
] );

new \Kirki\Section( 'ld_membership', [
	'title' => esc_html__( 'Membership Single', 'talemy' ),
	'panel' => $panel_name,
] );

if ( 'learndash' === $lms_plugin ) {
	new \Kirki\Section( 'ld_groups', [
		'title' => esc_html__( 'Groups Archive', 'talemy' ),
		'panel' => $panel_name,
	] );

	new \Kirki\Section( 'ld_group', [
		'title' => esc_html__( 'Group Single', 'talemy' ),
		'panel' => $panel_name,
	] );
}

/* General ------------------------------------ */

new \Kirki\Field\Radio_Image( [
	'settings' => 'ld_layout',
	'label'    => esc_html__( 'Layout', 'talemy' ),
	'section'  => 'ld_general',
	'default'  => 'sidebar-right',
	'choices'  => talemy_get_option_layouts(),
] );

new \Kirki\Field\Select( [
	'settings' => 'ld_sidebar',
	'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
	'section'  => 'ld_general',
	'default'  => '',
	'choices'  => talemy_get_option_sidebars( true ),
] );

new \Kirki\Field\Code( [
	'settings' => 'ld_thumb_hover_text',
	'label'    => esc_html__( 'Thumbnail Hover Text', 'talemy' ),
	'section'  => 'ld_general',
	'default'  => '<i class="fas fa-eye"></i>' . esc_html__( 'Watch Now', 'talemy' ),
	'choices'  => [
		'language' => 'html',
		'theme'    => 'monokai',
	],
] );

new \Kirki\Field\Select( [
	'settings' => 'ld_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'ld_general',
	'default'  => '',
	'choices'  => talemy_get_option_page_banner_options(),
] );

new \Kirki\Field\Image( [
	'settings'        => 'ld_banner_image',
	'label'           => esc_html__( 'Banner Image', 'talemy' ),
	'section'         => 'ld_general',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'ld_banner',
			'operator' => '==',
			'value'    => '',
		],
	],
	'output'          => [
		[
			'element'  => ['.content-banner'],
			'property' => 'background-image',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'ld_banner_shortcode',
	'label'           => esc_html__( 'Banner Shortcode', 'talemy' ),
	'section'         => 'ld_general',
	'active_callback' => [
		[
			'setting'  => 'ld_archive_banner',
			'operator' => '==',
			'value'    => 'shortcode',
		],
	],
] );


new \Kirki\Pro\Field\Divider(
	[
		'settings' => 'ld_general_title_div1',
		'section'  => 'ld_general',
	]
);

new \Kirki\Field\Multicheck( [
	'settings' => 'ld_courses_search_filters',
	'label'    => esc_html__( 'Course Search filters', 'talemy' ),
	'section'  => 'ld_general',
	'default'  => [ 'category' ],
	'choices'  => [
		'category' => esc_html__( 'Category', 'talemy' ),
		'tag'      => esc_html__( 'Tag', 'talemy' ),
		'price'    => esc_html__( 'Price', 'talemy' ),
	],
] );

/* Course Archive ------------------------------------ */

new \Kirki\Field\Select( [
	'settings' => 'ld_courses_list_style',
	'label'    => esc_html__( 'Listing Style', 'talemy' ),
	'section'  => 'ld_courses',
	'default'  => 'list',
	'choices'  => talemy_get_option_course_list_styles(),
] );

new \Kirki\Field\Select( [
	'settings' => 'ld_courses_thumb_size',
	'label'    => esc_html__( 'Image Size', 'talemy' ),
	'section'  => 'ld_courses',
	'default'  => 'talemy_thumb_small',
	'choices'  => talemy_get_option_image_sizes(),
] );

new \Kirki\Field\Select( [
	'settings'        => 'ld_courses_columns',
	'label'           => esc_html__( 'Columns', 'talemy' ),
	'section'         => 'ld_courses',
	'default'         => '4',
	'choices'         => talemy_get_option_columns(),
	'active_callback' => [
		[
			'setting'  => 'ld_courses_list_style',
			'operator' => 'in',
			'value'    => ['grid', 'grid2', 'masonry'],
		],
	],
] );

new \Kirki\Field\Select( [
	'settings'        => 'ld_courses_tablet_columns',
	'label'           => esc_html__( 'Tablet Columns', 'talemy' ),
	'section'         => 'ld_courses',
	'default'         => '3',
	'choices'         => talemy_get_option_tablet_columns(),
	'active_callback' => [
		[
			'setting'  => 'ld_courses_list_style',
			'operator' => 'in',
			'value'    => ['grid', 'grid2', 'masonry'],
		],
	],
] );

new \Kirki\Field\Select( [
	'settings'        => 'ld_courses_mobile_columns',
	'label'           => esc_html__( 'Mobile Columns', 'talemy' ),
	'section'         => 'ld_courses',
	'default'         => '1',
	'choices'         => talemy_get_option_mobile_columns(),
	'active_callback' => [
		[
			'setting'  => 'ld_courses_list_style',
			'operator' => 'in',
			'value'    => ['grid', 'grid2', 'masonry'],
		],
	],
] );

new \Kirki\Field\Radio_Image( [
	'settings' => 'ld_courses_layout',
	'label'    => esc_html__( 'Layout', 'talemy' ),
	'section'  => 'ld_courses',
	'default'  => 'full-width',
	'choices'  => talemy_get_option_layouts(),
] );

new \Kirki\Field\Select( [
	'settings' => 'ld_courses_sidebar',
	'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
	'section'  => 'ld_courses',
	'default'  => '',
	'choices'  => talemy_get_option_sidebars(),
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'ld_courses_heading_content',
	'label'    => esc_html__( 'Content', 'talemy' ),
	'section'  => 'ld_courses',
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'ld_courses_video_preview',
	'label'    => esc_html__( 'Show Video Preview', 'talemy' ),
	'section'  => 'ld_courses',
	'default'  => false,
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'ld_courses_show_price',
	'label'    => esc_html__( 'Show Price', 'talemy' ),
	'section'  => 'ld_courses',
	'default'  => true,
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'ld_courses_show_author',
	'label'    => esc_html__( 'Show Author', 'talemy' ),
	'section'  => 'ld_courses',
	'default'  => true,
] );

new \Kirki\Field\Multicheck( [
	'settings' => 'ld_courses_meta_data',
	'label'    => esc_html__( 'Meta Data', 'talemy' ),
	'section'  => 'ld_courses',
	'default'  => ['level', 'duration'],
	'choices'  => talemy_get_option_course_list_meta_data(),
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'ld_courses_heading_pagination',
	'label'    => esc_html__( 'Pagination', 'talemy' ),
	'section'  => 'ld_courses',
] );

new \Kirki\Field\Select( [
	'settings' => 'ld_courses_pagination',
	'label'    => esc_html__( 'Pagination Type', 'talemy' ),
	'section'  => 'ld_courses',
	'default'  => 'numeric',
	'choices'  => talemy_get_option_pagination_type(),
] );

new \Kirki\Field\Number( [
	'settings' => 'ld_courses_ppl',
	'label'    => esc_html__( 'Posts Per Load', 'talemy' ),
	'default'  => 5,
	'section'  => 'ld_courses',
	'choices'  => [
		'min'  => 0,
		'step' => 1,
	],
] );

new \Kirki\Field\Slider( [
	'settings'    => 'ld_courses_max_loads',
	'label'       => esc_html__( 'Max Loads ( Infinite Scroll )', 'talemy' ),
	'description' => esc_html__( 'The number of loads before a load more button will appear. Set 0 to always use infinite scroll.', 'talemy' ),
	'section'     => 'ld_courses',
	'default'     => 3,
	'choices'     => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
] );

/* Course Single ------------------------------------ */

new \Kirki\Field\Select( [
	'settings' => 'ld_course_style',
	'label'    => esc_html__( 'Template', 'talemy' ),
	'section'  => 'ld_course',
	'default'  => '2',
	'choices'  => [
		'1' => esc_html__( 'Template 1', 'talemy' ),
		'2' => esc_html__( 'Template 2', 'talemy' ),
	],
	'tab' => 'general'
] );

new \Kirki\Field\Radio_Image( [
	'settings' => 'ld_course_layout',
	'label'    => esc_html__( 'Content Layout', 'talemy' ),
	'section'  => 'ld_course',
	'default'  => 'sidebar-right',
	'choices'  => talemy_get_option_post_layouts(),
	'tab' => 'general'
] );

if ( 'lifterlms' === $lms_plugin ) {
	$course_meta_options = [
		'enrolled' => esc_html__( 'Students', 'talemy' ),
		'author'   => esc_html__( 'Author', 'talemy' ),
		'modified' => esc_html__( 'Modified Date', 'talemy' ),
		'level'    => esc_html__( 'Level', 'talemy' ),
		'cats'     => esc_html__( 'Categories', 'talemy' ),
		'duration' => esc_html__( 'Duration', 'talemy' ),
	];
	$default_course_meta = [
		'rating',
		'enrolled',
		'author',
		'modified',
		'level',
		'language',
		'cats',
	];
} else {
	$course_meta_options = [
		'rating'   => esc_html__( 'Rating', 'talemy' ),
		'enrolled' => esc_html__( 'Students', 'talemy' ),
		'author'   => esc_html__( 'Author', 'talemy' ),
		'modified' => esc_html__( 'Modified Date', 'talemy' ),
		'level'    => esc_html__( 'Level', 'talemy' ),
		'language' => esc_html__( 'Language', 'talemy' ),
		'cats'     => esc_html__( 'Categories', 'talemy' ),
		'duration' => esc_html__( 'Duration', 'talemy' ),
	];
	$default_course_meta = [
		'enrolled',
		'author',
		'modified',
		'level',
		'cats',
	];
}

new \Kirki\Field\Sortable( [
	'settings' => 'ld_course_meta_data',
	'label'    => esc_html__( 'Meta Data', 'talemy' ),
	'section'  => 'ld_course',
	'default'  => $default_course_meta,
	'choices'  => $course_meta_options,
	'tab' => 'general'
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'ld_course_share',
	'label'    => esc_html__( 'Show Social Share Buttons', 'talemy' ),
	'section'  => 'ld_course',
	'default'  => true,
	'tab' => 'general'
] );

if ( 'learndash' === $lms_plugin ) {

	new \Kirki\Field\Checkbox_Toggle( [
		'settings' => 'ld_course_retake_button',
		'label'    => esc_html__( 'Show Retake Course Button', 'talemy' ),
		'section'  => 'ld_course',
		'default'  => false,
		'tab' => 'general'
	] );

	if ( defined( 'LEARNDASH_WOOCOMMERCE_FILE' ) ) {
		new \Kirki\Field\Checkbox_Toggle( [
			'settings' => 'ld_course_add_to_cart_button',
			'label'    => esc_html__( 'Show Add to Cart Button', 'talemy' ),
			'section'  => 'ld_course',
			'default'  => true,
			'tab' => 'general'
		] );
	}

	new \Kirki\Pro\Field\Headline( [

		'settings' => 'ld_course_heading_sections',
		'label'    => esc_html__( 'Sections', 'talemy' ),
		'section'  => 'ld_course',
		'tab' => 'general'
	] );

	new \Kirki\Field\Sortable( [
		'settings' => 'ld_course_sections',
		'label'    => esc_html__( 'Sections', 'talemy' ),
		'section'  => 'ld_course',
		'default'  => ['overview', 'curriculum', 'instructors', 'reviews'],
		'choices'  => talemy_get_option_course_sections(),
		'tooltip'  => esc_html__( 'Show or hide an item by clicking the eye icon. Drag and drop the items to sort the display order.', 'talemy' ),
		'tab' => 'general'
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_course_sections_layout',
		'label'    => esc_html__( 'Section Layout', 'talemy' ),
		'section'  => 'ld_course',
		'default'  => 'toggles',
		'choices'  => [
			'tabs'    => esc_html__( 'Tabs', 'talemy' ),
			'toggles' => esc_html__( 'Toggles', 'talemy' ),
			'default' => esc_html__( 'Default', 'talemy' ),
		],
		'tab' => 'general'
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_course_default_tab',
		'label'    => esc_html__( 'Default Tab', 'talemy' ),
		'section'  => 'ld_course',
		'default'  => 'overview',
		'choices'  => talemy_get_option_course_sections(),
		'active_callback' => [
			[
				'setting'  => 'ld_course_sections_layout',
				'operator' => '==',
				'value'    => 'tabs',
			]
		],
		'tab' => 'general'
	] );

	new \Kirki\Field\Text( [
		'settings' => 'ld_course_section_title_overview',
		'label'    => esc_html__( 'Title - Overview', 'talemy' ),
		'section'  => 'ld_course',
		'default'  => esc_html__( 'Overview', 'talemy' ),
		'tab' => 'general'
	] );

	new \Kirki\Field\Text( [
		'settings' => 'ld_course_section_title_curriculum',
		'label'    => esc_html__( 'Title - Curriculum', 'talemy' ),
		'section'  => 'ld_course',
		'default'  => esc_html__( 'Curriculum', 'talemy' ),
		'tab' => 'general'
	] );

	new \Kirki\Field\Text( [
		'settings' => 'ld_course_section_title_instructors',
		'label'    => esc_html__( 'Title - Instructors', 'talemy' ),
		'section'  => 'ld_course',
		'default'  => esc_html__( 'Instructors', 'talemy' ),
		'tab' => 'general'
	] );

	new \Kirki\Field\Text( [
		'settings' => 'ld_course_section_title_reviews',
		'label'    => esc_html__( 'Title - Reviews', 'talemy' ),
		'section'  => 'ld_course',
		'default'  => esc_html__( 'Reviews', 'talemy' ),
		'tab' => 'general'
	] );
}

new \Kirki\Pro\Field\Headline( [
	'settings' => 'ld_course_heading_related',
	'label'    => esc_html__( 'Related Courses', 'talemy' ),
	'section'  => 'ld_course',
	'tab' => 'general'
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'ld_course_related',
	'label'    => esc_html__( 'Show Related Courses', 'talemy' ),
	'section'  => 'ld_course',
	'default'  => 1,
	'tab' => 'general'
] );

new \Kirki\Field\Select( [
	'settings' => 'ld_course_related_type',
	'label'    => esc_html__( 'Related Type', 'talemy' ),
	'section'  => 'ld_course',
	'default'  => '',
	'choices'  => [
		'cat'        => esc_html__( 'Category', 'talemy' ),
		'tag'        => esc_html__( 'Tag', 'talemy' ),
		'cat_or_tag' => esc_html__( 'Category or Tag', 'talemy' ),
		'author'     => esc_html__( 'Author', 'talemy' ),
		''           => esc_html__( 'All', 'talemy' ),
	],
	'tab' => 'general'
] );

new \Kirki\Field\Number( [
	'settings' => 'ld_course_related_count',
	'label'    => esc_html__( 'Number of related posts', 'talemy' ),
	'section'  => 'ld_course',
	'default'  => 3,
	'choices'  => [
		'min'  => 0,
		'step' => 1,
	],
	'tab' => 'general'
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'ld_course_heading_page_title',
	'label'    => esc_html__( 'Page Title', 'talemy' ),
	'section'  => 'ld_course',
	'tab'      => 'design',
] );

new \Kirki\Field\Background( [
	'settings'  => 'ld_course_bg',
	'label'     => esc_html__( 'Background', 'talemy' ),
	'section'   => 'ld_course',
	'default'   => ['background-color' => ''],
	'transport' => 'auto',
	'tab'       => 'design',
	'output'    => [
		[
			'element' => [
				'.single-sfwd-courses .course-intro',
				'.singe-group .course-intro',
			],
		],
	],
] );

new \Kirki\Pro\Field\Divider(
	[
		'settings' => 'ld_course_title_div3',
		'section'  => 'ld_course',
		'tab'      => 'design',
	]
);

new \Kirki\Field\Color( [
	'settings'  => 'ld_course_title_color',
	'label'     => esc_html__( 'Title Color', 'talemy' ),
	'section'   => 'ld_course',
	'transport' => 'auto',
	'choices'   => [
		'alpha' => true,
	],
	'tab'       => 'design',
	'output'    => [
		[
			'element'  => '.course-intro__content .post-title',
			'property' => 'color',
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'ld_course_breadcrumb_color',
	'label'     => esc_html__( 'Breadcrumb Color', 'talemy' ),
	'section'   => 'ld_course',
	'alpha'     => true,
	'transport' => 'auto',
	'tab'       => 'design',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'.course-intro .breadcrumbs',
				'.course-intro .breadcrumbs a',
			],
			'property' => 'color',
		],
		[
			'choice'   => 'hover',
			'element'  => '.course-intro .breadcrumbs a:hover',
			'property' => 'color',
		]
	]
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'ld_course_meta_color',
	'label'     => esc_html__( 'Meta Color', 'talemy' ),
	'section'   => 'ld_course',
	'alpha'     => true,
	'transport' => 'auto',
	'tab'       => 'design',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'.course-intro__meta .course-meta__item',
				'.course-intro__meta .course-meta__item a',
			],
			'property' => 'color',
		],
		[
			'choice'   => 'hover',
			'element'  => '.course-intro__meta .course-meta__item a:hover',
			'property' => 'color',
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'ld_course_meta_icon_color',
	'label'     => esc_html__( 'Meta Icon Color', 'talemy' ),
	'section'   => 'ld_course',
	'transport' => 'auto',
	'choices'   => [
		'alpha' => true,
	],
	'tab'       => 'design',
	'output'    => [
		[
			'element'  => '.course-intro__meta .course-meta__item i',
			'property' => 'color',
		],
	],
] );

if ( 'lifterlms' === $lms_plugin ) {

	/* Lesson ------------------------------------ */
	new \Kirki\Field\Select( [
		'settings' => 'ld_lesson_template',
		'label'    => esc_html__( 'Template', 'talemy' ),
		'section'  => 'ld_lesson',
		'default'  => '2',
		'choices'  => [
			'1' => esc_html__( 'Template 1', 'talemy' ),
			'2' => esc_html__( 'Template 2', 'talemy' ),
		],
	] );

	new \Kirki\Field\Radio_Image( [
		'settings'        => 'ld_lesson_layout',
		'label'           => esc_html__( 'Layout', 'talemy' ),
		'section'         => 'ld_lesson',
		'default'         => 'thin-width',
		'choices'         => talemy_get_option_post_layouts(),
		'active_callback' => [
			[
				'setting'  => 'ld_lesson_template',
				'operator' => '==',
				'value'    => '2',
			],
		],
	] );

	new \Kirki\Field\Select( [
		'settings'        => 'ld_lesson_sidebar',
		'label'           => esc_html__( 'Default Sidebar', 'talemy' ),
		'section'         => 'ld_lesson',
		'default'         => '',
		'choices'         => talemy_get_option_sidebars( true ),
		'active_callback' => [
			[
				'setting'  => 'ld_lesson_template',
				'operator' => '==',
				'value'    => '2',
			],
		],
	] );

	/* Membership ------------------------------------ */

	new \Kirki\Field\Radio_Image( [
		'settings' => 'ld_membership_layout',
		'label'    => esc_html__( 'Layout', 'talemy' ),
		'section'  => 'ld_membership',
		'default'  => 'thin-width',
		'choices'  => talemy_get_option_post_layouts(),
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_membership_sidebar',
		'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
		'section'  => 'ld_membership',
		'default'  => '',
		'choices'  => talemy_get_option_sidebars( true ),
	] );

	/* Memberships ------------------------------------ */

	new \Kirki\Field\Select( [
		'settings' => 'ld_memberships_list_style',
		'label'    => esc_html__( 'Listing Style', 'talemy' ),
		'section'  => 'ld_memberships',
		'default'  => 'list',
		'choices'  => talemy_get_option_course_list_styles(),
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_memberships_thumb_size',
		'label'    => esc_html__( 'Image Size', 'talemy' ),
		'section'  => 'ld_memberships',
		'default'  => 'talemy_thumb_small',
		'choices'  => talemy_get_option_image_sizes(),
	] );

	new \Kirki\Field\Select( [
		'settings'        => 'ld_memberships_columns',
		'label'           => esc_html__( 'Columns', 'talemy' ),
		'section'         => 'ld_memberships',
		'default'         => '4',
		'choices'         => talemy_get_option_columns(),
		'active_callback' => [
			[
				'setting'  => 'ld_memberships_list_style',
				'operator' => 'in',
				'value'    => ['grid', 'grid2', 'masonry'],
			],
		],
	] );

	new \Kirki\Field\Select( [
		'settings'        => 'ld_memberships_tablet_columns',
		'label'           => esc_html__( 'Tablet Columns', 'talemy' ),
		'section'         => 'ld_memberships',
		'default'         => '3',
		'choices'         => talemy_get_option_tablet_columns(),
		'active_callback' => [
			[
				'setting'  => 'ld_memberships_list_style',
				'operator' => 'in',
				'value'    => ['grid', 'grid2', 'masonry'],
			],
		],
	] );

	new \Kirki\Field\Select( [
		'settings'        => 'ld_memberships_mobile_columns',
		'label'           => esc_html__( 'Mobile Columns', 'talemy' ),
		'section'         => 'ld_memberships',
		'default'         => '1',
		'choices'         => talemy_get_option_mobile_columns(),
		'active_callback' => [
			[
				'setting'  => 'ld_memberships_list_style',
				'operator' => 'in',
				'value'    => ['grid', 'grid2', 'masonry'],
			],
		],
	] );

	new \Kirki\Field\Radio_Image( [
		'settings' => 'ld_memberships_layout',
		'label'    => esc_html__( 'Layout', 'talemy' ),
		'section'  => 'ld_memberships',
		'default'  => 'full-width',
		'choices'  => talemy_get_option_layouts(),
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_memberships_sidebar',
		'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
		'section'  => 'ld_memberships',
		'default'  => '',
		'choices'  => talemy_get_option_sidebars(),
	] );

	new \Kirki\Pro\Field\Headline( [
		'settings' => 'ld_memberships_heading_pagination',
		'label'    => esc_html__( 'Pagination', 'talemy' ),
		'section'  => 'ld_memberships',
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_memberships_pagination',
		'label'    => esc_html__( 'Pagination Type', 'talemy' ),
		'section'  => 'ld_memberships',
		'default'  => 'numeric',
		'choices'  => talemy_get_option_pagination_type(),
	] );

	new \Kirki\Field\Number( [
		'settings' => 'ld_memberships_ppl',
		'label'    => esc_html__( 'Posts Per Load', 'talemy' ),
		'default'  => 5,
		'section'  => 'ld_memberships',
		'choices'  => [
			'min'  => 0,
			'step' => 1,
		],
	] );

	new \Kirki\Field\Slider( [
		'settings'    => 'ld_memberships_max_loads',
		'label'       => esc_html__( 'Max Loads ( Infinite Scroll )', 'talemy' ),
		'description' => esc_html__( 'The number of loads before a load more button will appear. Set 0 to always use infinite scroll.', 'talemy' ),
		'section'     => 'ld_memberships',
		'default'     => 3,
		'choices'     => [
			'min'  => 0,
			'max'  => 50,
			'step' => 1,
		],
	] );
}

if ( 'learndash' === $lms_plugin ) {

	/* Group Archive ------------------------------------ */

	new \Kirki\Field\Select( [
		'settings' => 'ld_groups_list_style',
		'label'    => esc_html__( 'Listing Style', 'talemy' ),
		'section'  => 'ld_groups',
		'default'  => 'list',
		'choices'  => talemy_get_option_course_list_styles(),
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_groups_thumb_size',
		'label'    => esc_html__( 'Image Size', 'talemy' ),
		'section'  => 'ld_groups',
		'default'  => 'talemy_thumb_small',
		'choices'  => talemy_get_option_image_sizes(),
	] );

	new \Kirki\Field\Select( [
		'settings'        => 'ld_groups_columns',
		'label'           => esc_html__( 'Columns', 'talemy' ),
		'section'         => 'ld_groups',
		'default'         => '4',
		'choices'         => talemy_get_option_columns(),
		'active_callback' => [
			[
				'setting'  => 'ld_groups_list_style',
				'operator' => 'in',
				'value'    => ['grid', 'grid2', 'masonry'],
			],
		],
	] );

	new \Kirki\Field\Select( [
		'settings'        => 'ld_groups_tablet_columns',
		'label'           => esc_html__( 'Tablet Columns', 'talemy' ),
		'section'         => 'ld_groups',
		'default'         => '3',
		'choices'         => talemy_get_option_tablet_columns(),
		'active_callback' => [
			[
				'setting'  => 'ld_groups_list_style',
				'operator' => 'in',
				'value'    => ['grid', 'grid2', 'masonry'],
			],
		],
	] );

	new \Kirki\Field\Select( [
		'settings'        => 'ld_groups_mobile_columns',
		'label'           => esc_html__( 'Mobile Columns', 'talemy' ),
		'section'         => 'ld_groups',
		'default'         => '1',
		'choices'         => talemy_get_option_mobile_columns(),
		'active_callback' => [
			[
				'setting'  => 'ld_groups_list_style',
				'operator' => 'in',
				'value'    => ['grid', 'grid2', 'masonry'],
			],
		],
	] );

	new \Kirki\Field\Radio_Image( [
		'settings' => 'ld_groups_layout',
		'label'    => esc_html__( 'Layout', 'talemy' ),
		'section'  => 'ld_groups',
		'default'  => 'full-width',
		'choices'  => talemy_get_option_layouts(),
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_groups_sidebar',
		'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
		'section'  => 'ld_groups',
		'default'  => '',
		'choices'  => talemy_get_option_sidebars(),
	] );

	new \Kirki\Field\Checkbox_Toggle( [
		'settings' => 'ld_groups_video_preview',
		'label'    => esc_html__( 'Show Video Preview', 'talemy' ),
		'section'  => 'ld_groups',
		'default'  => false,
	] );

	new \Kirki\Field\Checkbox_Toggle( [
		'settings' => 'ld_groups_show_price',
		'label'    => esc_html__( 'Show Price', 'talemy' ),
		'section'  => 'ld_groups',
		'default'  => true,
	] );

	new \Kirki\Field\Checkbox_Toggle( [
		'settings' => 'ld_groups_show_author',
		'label'    => esc_html__( 'Show Author', 'talemy' ),
		'section'  => 'ld_groups',
		'default'  => true,
	] );

	new \Kirki\Field\Multicheck( [
		'settings' => 'ld_groups_meta_data',
		'label'    => esc_html__( 'Meta Data', 'talemy' ),
		'section'  => 'ld_groups',
		'default'  => ['level', 'duration', 'language'],
		'choices'  => [
			'level'    => esc_html__( 'Level', 'talemy' ),
			'language' => esc_html__( 'Language', 'talemy' ),
			'duration' => esc_html__( 'Duration', 'talemy' ),
			'enrolled' => esc_html__( 'Students', 'talemy' ),
		],
	] );

	new \Kirki\Pro\Field\Headline( [
		'settings' => 'ld_groups_heading_pagination',
		'label'    => esc_html__( 'Pagination', 'talemy' ),
		'section'  => 'ld_groups',
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_groups_pagination',
		'label'    => esc_html__( 'Pagination Type', 'talemy' ),
		'section'  => 'ld_groups',
		'default'  => 'numeric',
		'choices'  => talemy_get_option_pagination_type(),
	] );

	new \Kirki\Field\Number( [
		'settings' => 'ld_groups_ppl',
		'label'    => esc_html__( 'Posts Per Load', 'talemy' ),
		'default'  => 5,
		'section'  => 'ld_groups',
		'choices'  => [
			'min'  => 0,
			'step' => 1,
		],
	] );

	new \Kirki\Field\Slider( [
		'settings'    => 'ld_groups_max_loads',
		'label'       => esc_html__( 'Max Loads ( Infinite Scroll )', 'talemy' ),
		'description' => esc_html__( 'The number of loads before a load more button will appear. Set 0 to always use infinite scroll.', 'talemy' ),
		'section'     => 'ld_groups',
		'default'     => 3,
		'choices'     => [
			'min'  => 0,
			'max'  => 50,
			'step' => 1,
		],
	] );

	/* Group Single ------------------------------------ */

	new \Kirki\Field\Radio_Image( [
		'settings' => 'ld_group_layout',
		'label'    => esc_html__( 'Content Layout', 'talemy' ),
		'section'  => 'ld_group',
		'default'  => 'sidebar-right',
		'choices'  => talemy_get_option_layouts(),
	] );

	new \Kirki\Field\Sortable( [
		'settings' => 'ld_group_meta_data',
		'label'    => esc_html__( 'Meta Data', 'talemy' ),
		'section'  => 'ld_group',
		'default'  => [
			'rating',
			'enrolled',
			'author',
			'modified',
			'level',
			'language',
			'cats',
		],
		'choices'  => [
			'rating'   => esc_html__( 'Rating', 'talemy' ),
			'enrolled' => esc_html__( 'Students', 'talemy' ),
			'author'   => esc_html__( 'Author', 'talemy' ),
			'modified' => esc_html__( 'Modified Date', 'talemy' ),
			'level'    => esc_html__( 'Level', 'talemy' ),
			'language' => esc_html__( 'Language', 'talemy' ),
			'cats'     => esc_html__( 'Categories', 'talemy' ),
			'duration' => esc_html__( 'Duration', 'talemy' ),
		],
	] );

	new \Kirki\Field\Checkbox_Toggle( [
		'settings' => 'ld_group_share',
		'label'    => esc_html__( 'Show Social Share Buttons', 'talemy' ),
		'section'  => 'ld_group',
		'default'  => true,
	] );

	new \Kirki\Pro\Field\Headline( [
		'settings' => 'ld_group_heading_sections',
		'label'    => esc_html__( 'Sections', 'talemy' ),
		'section'  => 'ld_group',
	] );

	new \Kirki\Field\Sortable( [
		'settings' => 'ld_group_sections',
		'label'    => esc_html__( 'Sections', 'talemy' ),
		'section'  => 'ld_group',
		'default'  => ['overview', 'courses', 'instructors', 'reviews'],
		'choices'  => [
			'overview'    => esc_html__( 'Overview', 'talemy' ),
			'courses'     => esc_html__( 'Courses', 'talemy' ),
			'instructors' => esc_html__( 'Instructors', 'talemy' ),
			'reviews'     => esc_html__( 'Reviews', 'talemy' ),
		],
		'tooltip'  => esc_html__( 'Show or hide an item by clicking the eye icon. Drag and drop the items to sort the display order.', 'talemy' ),
	] );

	new \Kirki\Field\Select( [
		'settings' => 'ld_group_sections_layout',
		'label'    => esc_html__( 'Section Layout', 'talemy' ),
		'section'  => 'ld_group',
		'default'  => 'toggles',
		'choices'  => [
			'tabs'    => esc_html__( 'Tabs', 'talemy' ),
			'toggles' => esc_html__( 'Toggles', 'talemy' ),
			'default' => esc_html__( 'Default', 'talemy' ),
		],
	] );

	new \Kirki\Field\Text( [
		'settings' => 'ld_group_section_title_overview',
		'label'    => esc_html__( 'Title - Overview', 'talemy' ),
		'section'  => 'ld_group',
		'default'  => esc_html__( 'Overview', 'talemy' ),
	] );

	new \Kirki\Field\Text( [
		'settings' => 'ld_group_section_title_courses',
		'label'    => esc_html__( 'Title - Courses', 'talemy' ),
		'section'  => 'ld_group',
		'default'  => esc_html__( 'Courses', 'talemy' ),
	] );

	new \Kirki\Field\Text( [
		'settings' => 'ld_group_section_title_instructors',
		'label'    => esc_html__( 'Title - Instructors', 'talemy' ),
		'section'  => 'ld_group',
		'default'  => esc_html__( 'Instructors', 'talemy' ),
	] );

	new \Kirki\Field\Text( [
		'settings' => 'ld_group_section_title_reviews',
		'label'    => esc_html__( 'Title - Reviews', 'talemy' ),
		'section'  => 'ld_group',
		'default'  => esc_html__( 'Reviews', 'talemy' ),
	] );

	if ( defined( 'LEARNDASH_BBPRESS_FILE' ) ) {
		new \Kirki\Field\Checkbox_Toggle( [
			'settings' => 'ld_group_section_forums',
			'label'    => esc_html__( 'Show Associated Forums', 'talemy' ),
			'section'  => 'ld_group',
			'default'  => 1,
		] );
	}
}