<?php

$defaults = Talemy_Options::get_default_options();

new \Kirki\Panel( 'header', [
	'title'    => esc_html__( 'Header', 'talemy' ),
	'priority' => 22,
] );

new \Kirki\Section( 'header_header', [
	'title' => esc_html__( 'Header', 'talemy' ),
	'panel' => 'header',
] );

new \Kirki\Section( 'header_topbar', [
	'title' => esc_html__( 'Top Bar', 'talemy' ),
	'panel' => 'header',
] );

new \Kirki\Section( 'header_navbar', [
	'title' => esc_html__( 'Nav Bar', 'talemy' ),
	'panel' => 'header',
] );

new \Kirki\Section( 'header_main_menu', [
	'title' => esc_html__( 'Main Menu', 'talemy' ),
	'panel' => 'header',
] );

new \Kirki\Section( 'header_off_canvas', [
	'title' => esc_html__( 'Off Canvas', 'talemy' ),
	'panel' => 'header',
] );

/* Header ------------------------------------ */

new \Kirki\Field\Select( [
	'settings' => 'header_style',
	'label'    => esc_html__( 'Header Style', 'talemy' ),
	'section'  => 'header_header',
	'default'  => $defaults['header_style'],
	'choices'  => talemy_get_option_header_styles(),
] );

new \Kirki\Field\Radio_Buttonset( [
	'settings' => 'header_position',
	'label'    => esc_html__( 'Header Position', 'talemy' ),
	'section'  => 'header_header',
	'default'  => $defaults['header_position'],
	'choices'  => [
		''         => esc_html__( 'Default', 'talemy' ),
		'absolute' => esc_html__( 'Merge with content', 'talemy' ),
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings'        => 'header_heading_header_info',
	'label'           => esc_html__( 'Header Info', 'talemy' ),
	'section'         => 'header_header',
	'priority'        => 10,
	'active_callback' => [
		[
			'setting'  => 'header_style',
			'operator' => '==',
			'value'    => '4',
		],
	],
] );

new \Kirki\Field\Textarea( [
	'settings'        => 'header_info_address',
	'label'           => esc_html__( 'Header Address', 'talemy' ),
	'section'         => 'header_header',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'header_style',
			'operator' => '==',
			'value'    => '4',
		],
	],
] );

new \Kirki\Field\Textarea( [
	'settings'        => 'header_info_email',
	'label'           => esc_html__( 'Header Email', 'talemy' ),
	'section'         => 'header_header',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'header_style',
			'operator' => '==',
			'value'    => '4',
		],
	],
] );

new \Kirki\Field\Textarea( [
	'settings'        => 'header_info_phone',
	'label'           => esc_html__( 'Header Phone', 'talemy' ),
	'section'         => 'header_header',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'header_style',
			'operator' => '==',
			'value'    => '4',
		],
	],
] );

new \Kirki\Field\Code( [
	'settings'        => 'header_ads_code',
	'label'           => esc_html__( 'Header Ads code', 'talemy' ),
	'section'         => 'header_header',
	'default'         => '',
	'choices'         => [
		'language' => 'html',
		'theme'    => 'monokai',
	],
	'active_callback' => [
		[
			'setting'  => 'header_style',
			'operator' => '==',
			'value'    => '4',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'header_search_placeholder',
	'label'           => esc_html__( 'Search Text', 'talemy' ),
	'section'         => 'header_header',
	'default'         => $defaults['header_search_placeholder'],
	'active_callback' => [
		[
			'setting'  => 'header_style',
			'operator' => '==',
			'value'    => '9',
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'header_heading_background',
	'label'    => esc_html__( 'Background', 'talemy' ),
	'section'  => 'header_header',
] );

new \Kirki\Field\Background( [
	'settings'  => 'header_bg',
	'label'     => esc_html__( 'Background', 'talemy' ),
	'section'   => 'header_header',
	'default'   => ['background-color' => '#FFFFFF'],
	'transport' => 'auto',
	'output'    => [['element' => '#header']],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'header_heading_colors',
	'label'    => esc_html__( 'Colors', 'talemy' ),
	'section'  => 'header_header',
] );

new \Kirki\Field\Color( [
	'settings'  => 'header_text_color',
	'label'     => esc_html__( 'Text Color', 'talemy' ),
	'section'   => 'header_header',
	'default'   => '#222222',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => ['#header'],
			'property' => 'color',
			'exclude'  => ['#222222'],
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'header_link_color',
	'label'     => esc_html__( 'Link Color', 'talemy' ),
	'section'   => 'header_header',
	'alpha'     => true,
	'transport' => 'auto',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'default'   => [
		'default' => '#222222',
		'hover'   => '#f5b417'
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'.header-wrapper a',
				'.header-wrapper .nav-btns i',
			],
			'property' => 'color',
			'exclude'  => ['#222222'],
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'.header-wrapper a:not(.btn):hover',
				'.header-wrapper .nav-btns i:hover',
			],
			'property' => 'color',
			'exclude'  => ['#f5b417'],
		],
	],
] );

/* Top Bar ------------------------------------ */

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'topbar',
	'label'    => esc_html__( 'Show Topbar', 'talemy' ),
	'section'  => 'header_topbar',
	'default'  => $defaults['topbar'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'topbar_cta_btn',
	'label'    => esc_html__( 'Show CTA Button', 'talemy' ),
	'section'  => 'header_topbar',
	'default'  => $defaults['topbar_cta_btn'],
] );

new \Kirki\Field\Text( [
	'settings'        => 'topbar_btn_text',
	'label'           => esc_html__( 'CTA Button Text', 'talemy' ),
	'section'         => 'header_topbar',
	'default'         => $defaults['topbar_btn_text'],
	'active_callback' => [
		[
			'setting'  => 'topbar_cta_btn',
			'operator' => '==',
			'value'    => 1,
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'topbar_btn_url',
	'label'           => esc_html__( 'CTA Button URL', 'talemy' ),
	'section'         => 'header_topbar',
	'default'         => $defaults['topbar_btn_url'],
	'active_callback' => [
		[
			'setting'  => 'topbar_cta_btn',
			'operator' => '==',
			'value'    => 1,
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'topbar_btn_class',
	'label'           => esc_html__( 'CTA Button Class', 'talemy' ),
	'section'         => 'header_topbar',
	'default'         => $defaults['topbar_btn_class'],
	'active_callback' => [
		[
			'setting'  => 'topbar_cta_btn',
			'operator' => '==',
			'value'    => 1,
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'topbar_heading_1',
	'label'    => esc_html__( 'Colors', 'talemy' ),
	'section'  => 'header_topbar',
] );

new \Kirki\Field\Color( [
	'settings'  => 'topbar_bg_color',
	'label'     => esc_html__( 'Background Color', 'talemy' ),
	'section'   => 'header_topbar',
	'default'   => '#41246d',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => '.topbar',
			'property' => 'background',
			'exclude'  => ['#41246d'],
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'topbar_text_color',
	'label'     => esc_html__( 'Text Color', 'talemy' ),
	'section'   => 'header_topbar',
	'default'   => '#FFFFFF',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => '.topbar',
			'property' => 'color',
			'exclude'  => ['#FFFFFF'],
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'topbar_link_color',
	'label'     => esc_html__( 'Link Color', 'talemy' ),
	'section'   => 'header_topbar',
	'alpha'     => true,
	'transport' => 'auto',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'default'   => [
		'default' => '#FFFFFF',
		'hover'   => '#f5b417',
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'.topbar a',
				'.topbar-search .fa',
			],
			'property' => 'color',
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'.topbar a:hover',
				'.topbar-search:hover .fa',
				'.topbar-menu a:hover',
			],
			'property' => 'color',
		],
	],
] );

/* Nav Bar ------------------------------------ */

new \Kirki\Field\Select( [
	'settings' => 'nav_sticky_style',
	'label'    => esc_html__( 'Sticky Navbar', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['nav_sticky_style'],
	'choices'  => [
		'disable' => esc_html__( 'Disable', 'talemy' ),
		'always'  => esc_html__( 'Always', 'talemy' ),
		'smart'   => esc_html__( 'Smart', 'talemy' ),
	],
] );

new \Kirki\Field\Multicheck( [
    'settings'    => 'sticky_navbar_on',
    'label'       => esc_html__( 'Sticky On', 'talemy' ),
    'section'     => 'header_navbar',
    'default'     => $defaults['nav_sticky_on'],
    'choices'     => talemy_get_option_screens()
] );

new \Kirki\Field\Number( [
	'settings'  => 'nav_top_padding',
	'label'     => esc_html__( 'Top Padding', 'talemy' ),
	'section'   => 'header_navbar',
	'transport' => 'auto',
	'default'   => 15,
	'choices'   => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'output'    => [
		[
			'element'     => [
				'.header-style-1 .nav-menu>li>a',
				'.header-style-1 .nav .nav-btns .nav-btn',
				'.header-style-2 .nav-menu>li>a',
				'.header-style-2 .nav .nav-btns .nav-btn',
				'.header-style-3 .nav-menu>li>a',
				'.header-style-3 .nav .nav-btns .nav-btn',
				'.header-style-3 .nav-btn-cat',
				'.header-style-4 .nav-menu>li>a',
				'.header-style-4 .nav .nav-btns .nav-btn',
				'.header-style-9 .nav-menu>li>a',
				'.header-style-9 .nav .nav-btns .nav-btn',
				'.header-style-8 .navbar',
				'.header-style-2 .navbar:not(.nav-is-fixed) .logo-wrapper',
				'.navbar:not(.nav-is-fixed) .btn-login-wrapper',
			],
			'property'    => 'padding-top',
			'media_query' => '@media (min-width: 768px)',
			'suffix'      => 'px',
			'exclude'     => [15],
		],
	],
] );

new \Kirki\Field\Number( [
	'settings'  => 'nav_bottom_padding',
	'label'     => esc_html__( 'Bottom Padding', 'talemy' ),
	'section'   => 'header_navbar',
	'transport' => 'auto',
	'default'   => 15,
	'choices'   => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'output'    => [
		[
			'element'     => [
				'.header-style-1 .nav-menu>li>a',
				'.header-style-1 .nav .nav-btns .nav-btn',
				'.header-style-2 .nav-menu>li>a',
				'.header-style-2 .nav .nav-btns .nav-btn',
				'.header-style-3 .nav-menu>li>a',
				'.header-style-3 .nav .nav-btns .nav-btn',
				'.header-style-3 .nav-btn-cat',
				'.header-style-4 .nav-menu>li>a',
				'.header-style-4 .nav .nav-btns .nav-btn',
				'.header-style-9 .nav-menu>li>a',
				'.header-style-9 .nav .nav-btns .nav-btn',
				'.header-style-8 .navbar',
				'.header-style-2 .navbar:not(.nav-is-fixed) .logo-wrapper',
				'.navbar:not(.nav-is-fixed) .btn-login-wrapper',
			],
			'property'    => 'padding-bottom',
			'media_query' => '@media (min-width: 768px)',
			'suffix'      => 'px',
			'exclude'     => [15],
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'navbar_heading_buttons',
	'label'    => esc_html__( 'Buttons', 'talemy' ),
	'section'  => 'header_navbar',
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'wc_nav_cart',
	'label'    => esc_html__( 'Show Shopping Cart', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['wc_nav_cart'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'nav_search',
	'label'    => esc_html__( 'Show Search', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['nav_search'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'nav_login',
	'label'    => esc_html__( 'Show Login', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['nav_login'],
] );

new \Kirki\Field\Select( [
	'settings'        => 'nav_login_button_style',
	'label'           => esc_html__( 'Login Button Style', 'talemy' ),
	'section'         => 'header_navbar',
	'default'         => $defaults['nav_login_button_style'],
	'choices'         => [
		''       => esc_html__( 'Icon', 'talemy' ),
		'button' => esc_html__( 'Button', 'talemy' ),
	],
	'active_callback' => [
		[
			'setting'  => 'nav_login',
			'operator' => '==',
			'value'    => true,
		],
	],
] );

new \Kirki\Field\Select( [
	'settings'        => 'custom_user_page',
	'label'           => esc_html__( 'Custom User\'s Page', 'talemy' ),
	'section'         => 'header_navbar',
	'choices'         => talemy_get_option_pages(),
	'default'         => $defaults['custom_user_page'],
	'active_callback' => [
		[
			'setting'  => 'nav_login',
			'operator' => '==',
			'value'    => true,
		],
	],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'nav_hamburger',
	'label'    => esc_html__( 'Show Hamburger', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['nav_hamburger'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'nav_wishlist',
	'label'    => esc_html__( 'Show Wish List', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['nav_wishlist'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'nav_cta_btn',
	'label'    => esc_html__( 'Show CTA Button', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['nav_cta_btn'],
] );

new \Kirki\Field\Text( [
	'settings'        => 'nav_btn_text',
	'label'           => esc_html__( 'CTA Button Text', 'talemy' ),
	'section'         => 'header_navbar',
	'default'         => $defaults['nav_btn_text'],
	'active_callback' => [
		[
			'setting'  => 'nav_cta_btn',
			'operator' => '==',
			'value'    => 1,
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'nav_btn_url',
	'label'           => esc_html__( 'CTA Button URL', 'talemy' ),
	'section'         => 'header_navbar',
	'default'         => $defaults['nav_btn_url'],
	'active_callback' => [
		[
			'setting'  => 'nav_cta_btn',
			'operator' => '==',
			'value'    => 1,
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'nav_btn_class',
	'label'           => esc_html__( 'CTA Button Class', 'talemy' ),
	'section'         => 'header_navbar',
	'default'         => $defaults['nav_btn_class'],
	'active_callback' => [
		[
			'setting'  => 'nav_cta_btn',
			'operator' => '==',
			'value'    => 1,
		],
	],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'nav_btn_hide_on_mobile',
	'label'    => esc_html__( 'Hide CTA Button On Mobile', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['nav_btn_hide_on_mobile'],
	'active_callback' => [
		[
			'setting'  => 'nav_cta_btn',
			'operator' => '==',
			'value'    => 1,
		],
	],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings'        => 'nav_show_course_cats',
	'label'           => esc_html__( 'Show Course Categories', 'talemy' ),
	'section'         => 'header_navbar',
	'default'         => $defaults['nav_show_course_cats'],
	'active_callback' => [
		[
			'setting'  => 'header_style',
			'operator' => '==',
			'value'    => '3',
		],
	],
] );

new \Kirki\Field\Multicheck( [
	'settings'        => 'nav_course_cats',
	'label'           => esc_html__( 'Course Categories', 'talemy' ),
	'section'         => 'header_navbar',
	'default'         => $defaults['nav_course_cats'],
	'choices'         => talemy_get_option_terms( Talemy::$lms_category ),
	'active_callback' => [
		[
			'setting'  => 'nav_show_course_cats',
			'operator' => '==',
			'value'    => 1,
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'navbar_heading_mobile_buttons',
	'label'    => esc_html__( 'Buttons ( Mobile View )', 'talemy' ),
	'section'  => 'header_navbar',
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'mobile_wc_nav_cart',
	'label'    => esc_html__( 'Show Shopping Cart', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['mobile_wc_nav_cart'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'mobile_nav_search',
	'label'    => esc_html__( 'Show Search', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['mobile_nav_search'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'mobile_nav_login',
	'label'    => esc_html__( 'Show Login', 'talemy' ),
	'section'  => 'header_navbar',
	'default'  => $defaults['mobile_nav_login'],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'navbar_heading_colors',
	'label'    => esc_html__( 'Colors', 'talemy' ),
	'section'  => 'header_navbar',
	'priority' => 10,
] );

new \Kirki\Field\Color( [
	'settings'  => 'navbar_bg_color',
	'label'     => esc_html__( 'Background Color', 'talemy' ),
	'section'   => 'header_navbar',
	'default'   => '#ffffff',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => [
				'.navbar',
				'.header-style-3 .navbar',
				'.header-style-4 .navbar',
				'.header-style-6 .navbar .nav',
			],
			'property' => 'background-color',
			'exclude'  => ['#ffffff'],
		],
		[
			'element'  => [
				'.header-style-3 .navbar',
				'.header-style-4 .navbar',
			],
			'property' => 'border-color',
			'exclude'  => ['#ffffff'],
		],
		[
			'element'     => [
				'.header-style-6 .navbar',
			],
			'property'    => 'background-color',
			'media_query' => '@media (max-width:767px)',
			'exclude'     => ['#ffffff'],
			'suffix'      => '!important',
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'navbar_sticky_bg_color',
	'label'     => esc_html__( 'Sticky Background Color', 'talemy' ),
	'section'   => 'header_navbar',
	'default'   => '#FFFFFF',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => [
				'.navbar.nav-is-fixed',
			],
			'property' => 'background-color',
			'suffix'   => '!important',
			'exclude'  => ['#FFFFFF'],
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'navbar_link_color',
	'label'     => esc_html__( 'Nav Bar Link Color', 'talemy' ),
	'section'   => 'header_navbar',
	'alpha'     => true,
	'transport' => 'auto',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'default'   => [
		'default' => '#222222',
		'hover'   => '#f5b417',
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'.navbar .nav-btns .nav-btn',
				'.navbar .nav-btns .nav-btn i',
				'.navbar .nav-btn-cat .text',
			],
			'property' => 'color',
		],
		[
			'choice'   => 'default',
			'element'  => [
				'.hamburger .menu-icon span',
				'.hamburger-2 .menu-icon span',
			],
			'property' => 'background',
		],
		[
			'choice'   => 'default',
			'element'  => [
				'.icon-category .square',
			],
			'property' => 'border-color',
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'.navbar .nav-btns .nav-btn:hover',
				'.navbar .nav-btns .nav-btn:hover i',
				'.navbar .nav-btn-cat:hover .text',
			],
			'property' => 'color',
			'suffix'   => '!important',
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'.hamburger:hover .menu-icon span',
				'.hamburger-2:hover .menu-icon span',
				'.nav-btn-cat:hover .icon-category .square',

			],
			'property' => 'background',
		],
	],
] );

new \Kirki\Field\Radio_Buttonset( [
	'settings'    => 'menu_alignment',
	'label'       => esc_html__( 'Menu Alignment', 'talemy' ),
	'description' => esc_html__( 'For header style 1, 2, 5, 7', 'talemy' ),
	'section'     => 'header_main_menu',
	'default'     => $defaults['menu_alignment'],
	'choices'     => [
		'left'   => esc_html__( 'Left', 'talemy' ),
		'center' => esc_html__( 'Center', 'talemy' ),
		'right'  => esc_html__( 'Right', 'talemy' ),
	],
] );

new \Kirki\Field\Select( [
	'settings' => 'menu_icons_position',
	'label'    => esc_html__( 'Menu Icons Position', 'talemy' ),
	'section'  => 'header_main_menu',
	'default'  => $defaults['menu_icons_position'],
	'choices'  => [
		'left' => esc_html__( 'Left', 'talemy' ),
		'top'  => esc_html__( 'Top', 'talemy' ),
	],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'menu_dropdown_indicator',
	'label'    => esc_html__( 'Show Dropdown Indicator', 'talemy' ),
	'section'  => 'header_main_menu',
	'default'  => $defaults['menu_dropdown_indicator'],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'menu_heading_main_menu',
	'label'    => esc_html__( 'Main Menu', 'talemy' ),
	'section'  => 'header_main_menu',
] );

new \Kirki\Field\Typography( [
	'settings'  => 'main_menu_typo',
	'label'     => esc_html__( 'Main Menu', 'talemy' ),
	'section'   => 'header_main_menu',
	'transport' => 'auto',
	'choices'	=> talemy_default_font_choices(),
	'default'   => [
		'font-family'    => 'Poppins',
		'variant'        => '600',
		'letter-spacing' => '0',
		'text-transform' => 'none',
	],
	'output'    => [
		[
			'element' => ['.nav-menu>li>a'],
		],
	],
] );

new \Kirki\Field\Dimension( [
	'settings'  => 'main_menu_size',
	'label'     => esc_html__( 'Font Size', 'talemy' ),
	'section'   => 'header_main_menu',
	'transport' => 'auto',
	'default'   => '14px',
	'output'    => [
		[
			'element'  => [
				'.nav-menu>li>a',
			],
			'property' => 'font-size',
			'exclude'  => ['14px'],
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'main_menu_link_color',
	'label'     => esc_html__( 'Link Color', 'talemy' ),
	'section'   => 'header_main_menu',
	'alpha'     => true,
	'transport' => 'auto',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'default'   => [
		'default' => '#000000',
		'hover'   => '#f5b417',
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'.nav-menu>li>a',
			],
			'property' => 'color',
			'suffix'   => '!important',
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'.nav-menu>li>a:hover',
				'.header-style-6 .nav-menu>.current-menu-ancestor>a',
				'.header-style-6 .nav-menu>.current-menu-parent>a',
				'.header-style-6 .nav-menu>.current-menu-item>a',
			],
			'property' => 'color',
			'suffix'   => '!important',
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'menu_heading_submenu',
	'label'    => esc_html__( 'Submenu', 'talemy' ),
	'section'  => 'header_main_menu',
] );

new \Kirki\Field\Typography( [
	'settings'  => 'submenu_typo',
	'label'     => esc_html__( 'Submenu', 'talemy' ),
	'section'   => 'header_main_menu',
	'transport' => 'auto',
	'choices'	=> talemy_default_font_choices(),
	'default'   => [
		'font-family'    => 'Poppins',
		'variant'        => '600',
		'letter-spacing' => '0',
		'text-transform' => 'none',
	],
	'output'    => [
		[
			'element' => [
				'.nav-menu .megamenu-submenu a',
				'.nav-menu .sub-menu a',
			],
		],
	],
] );

new \Kirki\Field\Dimension( [
	'settings'  => 'submenu_size',
	'label'     => esc_html__( 'Font Size', 'talemy' ),
	'section'   => 'header_main_menu',
	'transport' => 'auto',
	'default'   => '13px',
	'output'    => [
		[
			'element'  => [
				'.nav-menu .sub-menu a',
				'.nav-menu .megamenu-submenu a',
			],
			'property' => 'font-size',
			'exclude'  => ['13px'],
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'submenu_link_color',
	'label'     => esc_html__( 'Link Color', 'talemy' ),
	'section'   => 'header_main_menu',
	'alpha'     => true,
	'transport' => 'auto',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'default'   => [
		'default' => '#7f7f7f',
		'hover'   => '#f5b417',
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'.nav-menu .sub-menu a',
				'.nav-menu .megamenu-submenu a',
			],
			'property' => 'color',
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'.nav-menu .sub-menu>li.active>a',
				'.nav-menu .sub-menu .current-menu-parent>a',
				'.nav-menu .sub-menu .current-menu-item>a',
				'.nav-menu .sub-menu a:hover',
				'.nav-menu .megamenu-submenu a:hover',
			],
			'property' => 'color',
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'submenu_bg_color',
	'label'     => esc_html__( 'Background Color', 'talemy' ),
	'section'   => 'header_main_menu',
	'alpha'     => true,
	'transport' => 'auto',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'default'   => [
		'default' => '#FFFFFF',
		'hover'   => '#FFFFFF',
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => ['.nav-menu .sub-menu'],
			'property' => 'background-color',
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'.nav-menu .sub-menu>li.active>a',
				'.nav-menu .sub-menu .current-menu-parent>a',
				'.nav-menu .sub-menu .current-menu-item>a',
				'.nav-menu .sub-menu>li:hover>a',
			],
			'property' => 'background-color',
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'menu_heading_megamenu',
	'label'    => esc_html__( 'Mega Menu', 'talemy' ),
	'section'  => 'header_main_menu',
] );

new \Kirki\Field\Dimension( [
	'settings'  => 'megamenu_title_size',
	'label'     => esc_html__( 'Title Size', 'talemy' ),
	'section'   => 'header_main_menu',
	'transport' => 'auto',
	'default'   => '18px',
	'output'    => [
		[
			'element'  => [
				'.megamenu-widget-area .widget-title',
				'.megamenu-title',
			],
			'property' => 'font-size',
			'exclude'  => ['18px'],
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'megamenu_divider_color',
	'label'     => esc_html__( 'Divider Color', 'talemy' ),
	'section'   => 'header_main_menu',
	'transport' => 'auto',
	'default'   => '#eeeeee',
	'choices'   => ['alpha' => true],
	'output'    => [
		[
			'element'  => '.megamenu-submenu:before',
			'property' => 'background-color',
			'exclude'  => ['#eeeeee'],
		],
	],
] );

/* Off Canvas ------------------------------------ */

new \Kirki\Pro\Field\Headline( [
	'settings' => 'side_heading_background',
	'label'    => esc_html__( 'Background', 'talemy' ),
	'section'  => 'header_off_canvas',
] );

new \Kirki\Field\Background( [
	'settings'  => 'side_bg',
	'section'   => 'header_off_canvas',
	'default'   => ['background-color' => ''],
	'transport' => 'auto',
	'output'    => [['element' => '.off-canvas']],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'side_heading_colors',
	'label'    => esc_html__( 'Colors', 'talemy' ),
	'section'  => 'header_off_canvas',
] );

new \Kirki\Field\Color( [
	'settings'  => 'side_title_color',
	'label'     => esc_html__( 'Widget Title Color', 'talemy' ),
	'section'   => 'header_off_canvas',
	'default'   => '#000000',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => '.off-canvas .widget-title',
			'property' => 'color',
			'exclude'  => ['#000000'],
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'side_text_color',
	'label'     => esc_html__( 'Text Color', 'talemy' ),
	'section'   => 'header_off_canvas',
	'default'   => '#777777',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => '.off-canvas',
			'property' => 'color',
			'exclude'  => ['#777777'],
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'side_link_color',
	'label'     => esc_html__( 'Link Color', 'talemy' ),
	'section'   => 'header_off_canvas',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'alpha'     => true,
	'transport' => 'auto',
	'default'   => [
		'default' => '#444444',
		'hover'   => '#f5b417',
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'.off-canvas-widget a',
				'.off-canvas-menu a',
			],
			'property' => 'color',
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'.off-canvas-widget a:hover',
				'.off-canvas-menu a:hover',
			],
			'property' => 'color',
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'side_menu_divider_color',
	'label'     => esc_html__( 'Menu Divider Color', 'talemy' ),
	'section'   => 'header_off_canvas',
	'default'   => '#DFDFDF',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => [
				'.off-canvas-menu ul',
				'.off-canvas-menu li',
			],
			'property' => 'border-color',
			'exclude'  => ['#DFDFDF'],
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'side_heading_typography',
	'label'    => esc_html__( 'Typography', 'talemy' ),
	'section'  => 'header_off_canvas',
] );

new \Kirki\Field\Typography( [
	'settings'  => 'side_typo',
	'label'     => esc_html__( 'Off-Canvas Menu', 'talemy' ),
	'section'   => 'header_off_canvas',
	'transport' => 'auto',
	'choices'	=> talemy_default_font_choices(),
	'default'   => [
		'font-family'    => 'Poppins',
		'variant'        => '600',
		'letter-spacing' => '0',
		'text-transform' => 'uppercase',
	],
	'output'    => [
		[
			'element' => ['.off-canvas-menu a'],
		],
	],
] );