<?php

$defaults = Talemy_Options::get_default_options();

new \Kirki\Panel( 'global', [
	'title'    => esc_html__( 'Global', 'talemy' ),
	'priority' => 21,
] );

new \Kirki\Panel( 'typography', [
	'title' => esc_html__( 'Typography', 'talemy' ),
	'panel' => 'global',
] );

new \Kirki\Section( 'typography_body', [
	'title' => esc_html__( 'Body', 'talemy' ),
	'panel' => 'typography',
] );

new \Kirki\Section( 'typography_heading', [
	'title' => esc_html__( 'Headings', 'talemy' ),
	'panel' => 'typography',
] );

new \Kirki\Panel( 'listing', [
	'title' => esc_html__( 'Listing', 'talemy' ),
	'panel' => 'global',
] );

new \Kirki\Section( 'list_style_grid', [
	'title' => esc_html__( 'Grid', 'talemy' ),
	'panel' => 'listing',
] );

new \Kirki\Section( 'list_style_list', [
	'title' => esc_html__( 'List', 'talemy' ),
	'panel' => 'listing',
] );

new \Kirki\Section( 'list_style_masonry', [
	'title' => esc_html__( 'Masonry', 'talemy' ),
	'panel' => 'listing',
] );

new \Kirki\Section( 'global_banner', [
	'title' => esc_html__( 'Banner', 'talemy' ),
	'panel' => 'global',
] );

new \Kirki\Section( 'breadcrumbs', [
	'title' => esc_html__( 'Breadcrumbs', 'talemy' ),
	'panel' => 'global',
] );

new \Kirki\Section( 'colors', [
	'title' => esc_html__( 'Colors', 'talemy' ),
	'panel' => 'global',
] );

new \Kirki\Section( 'styling', [
	'title' => esc_html__( 'Styling', 'talemy' ),
	'panel' => 'global',
] );

new \Kirki\Section( 'misc', [
	'title' => esc_html__( 'Miscellaneous', 'talemy' ),
	'panel' => 'global',
] );

/* Typography ------------------------------------ */

new \Kirki\Field\Typography( [
	'settings'  => 'typo_body',
	'label'     => esc_html__( 'Body Font', 'talemy' ),
	'section'   => 'typography_body',
	'choices'	=> talemy_default_font_choices(),
	'default'   => [
		'color'          => '#515151',
		'font-family'    => 'Poppins',
		'variant'        => 'regular',
		'font-size'      => '16px',
		'line-height'    => '1.75',
		'letter-spacing' => '',
		'text-transform' => 'none',
	],
	'transport' => 'auto',
	'output'    => [
		['element' => 'body'],
	],
] );

new \Kirki\Field\Typography( [
	'settings'  => 'typo_heading',
	'label'     => esc_html__( 'H1 - H6 Font', 'talemy' ),
	'section'   => 'typography_heading',
	'choices'	=> talemy_default_font_choices(),
	'default'   => [
		'font-family'    => 'Poppins',
		'variant'        => '600',
		'line-height'    => '1.35',
		'letter-spacing' => '',
		'text-transform' => 'none',
	],
	'transport' => 'auto',
	'output'    => [
		['element' => ['h1', 'h2', 'h3', 'h4', 'h5', 'h6']],
	],
] );

new \Kirki\Field\Dimension( [
	'settings'  => 'typo_h1_size',
	'label'     => esc_html__( 'H1 Font Size', 'talemy' ),
	'section'   => 'typography_heading',
	'default'   => '36px',
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => 'h1',
			'property' => 'font-size',
			'exclude'  => ['36px', '1.8rem'],
		],
	],
] );

new \Kirki\Field\Dimension( [
	'settings'  => 'typo_h2_size',
	'label'     => esc_html__( 'H2 Font Size', 'talemy' ),
	'section'   => 'typography_heading',
	'default'   => '27px',
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => 'h2',
			'property' => 'font-size',
			'exclude'  => ['27px', '1.35rem'],
		],
	],
] );

new \Kirki\Field\Dimension( [
	'settings'  => 'typo_h3_size',
	'label'     => esc_html__( 'H3 Font Size', 'talemy' ),
	'section'   => 'typography_heading',
	'default'   => '21px',
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => 'h3',
			'property' => 'font-size',
			'exclude'  => ['21px', '1.05rem'],
		],
	],
] );

new \Kirki\Field\Dimension( [
	'settings'  => 'typo_h4_size',
	'label'     => esc_html__( 'H4 Font Size', 'talemy' ),
	'section'   => 'typography_heading',
	'default'   => '18px',
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => 'h4',
			'property' => 'font-size',
			'exclude'  => ['18px', '0.9rem'],
		],
	],
] );

new \Kirki\Field\Dimension( [
	'settings'  => 'typo_h5_size',
	'label'     => esc_html__( 'H5 Font Size', 'talemy' ),
	'section'   => 'typography_heading',
	'default'   => '16px',
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => 'h5',
			'property' => 'font-size',
			'exclude'  => ['16px', '0.8rem'],
		],
	],
] );

new \Kirki\Field\Dimension( [
	'settings'  => 'typo_h6_size',
	'label'     => esc_html__( 'H6 Font Size', 'talemy' ),
	'section'   => 'typography_heading',
	'default'   => '14px',
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => 'h6',
			'property' => 'font-size',
			'exclude'  => ['14px', '0.7rem'],
		],
	],
] );

/* Colors ------------------------------------ */

new \Kirki\Field\Color( [
	'settings'  => 'primary_color',
	'label'     => esc_html__( 'Primary Color', 'talemy' ),
	'section'   => 'colors',
	'default'   => '#41246d',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => ':root',
			'property' => '--theme-color-primary',
			'exclude'  => ['#41246d'],
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'secondary_color',
	'label'     => esc_html__( 'Secondary Color', 'talemy' ),
	'section'   => 'colors',
	'default'   => '#f5b417',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => ':root',
			'property' => '--theme-color-secondary',
			'exclude'  => ['#f5b417'],
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'body_link_color',
	'label'     => esc_html__( 'Link Color', 'talemy' ),
	'section'   => 'colors',
	'default'   => '#f5b417',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => ':root',
			'property' => '--theme-color-link',
			'exclude'  => ['#f5b417'],
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'body_link_hover_color',
	'label'     => esc_html__( 'Link Hover Color', 'talemy' ),
	'section'   => 'colors',
	'default'   => '#222222',
	'choices'   => ['alpha' => true],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => ':root',
			'property' => '--theme-color-link-hover',
			'exclude'  => ['#222222'],
		],
	],
] );

new Kirki\Pro\Field\Headline( [
	'settings' => 'colors_button_headings',
	'label'    => esc_html__( 'Buttons', 'talemy' ),
	'section'  => 'colors',
] );

new Kirki\Field\Multicolor( [
	'settings'  => 'button_bg_color',
	'label'     => esc_html__( 'Background Color', 'talemy' ),
	'section'   => 'colors',
	'alpha'     => true,
	'transport' => 'auto',
	'default'   => [
		'default' => '',
		'hover'   => '',
	],
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => ':root',
			'property' => '--theme-color-btn-bg',
		],
		[
			'choice'   => 'hover',
			'element'  => ':root',
			'property' => '--theme-color-btn-bg-hover',
		],
	],
] );

new Kirki\Field\Multicolor( [
	'settings'  => 'button_text_color',
	'label'     => esc_html__( 'Text Color', 'talemy' ),
	'section'   => 'colors',
	'alpha'     => true,
	'transport' => 'auto',
	'default'   => [
		'default' => '',
		'hover'   => '',
	],
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => ':root',
			'property' => '--theme-color-btn-text',
		],
		[
			'choice'   => 'hover',
			'element'  => ':root',
			'property' => '--theme-color-btn-text-hover',
		],
	],
] );

/* Styling ------------------------------------ */

new \Kirki\Field\Select( [
	'settings'    => 'corner_style',
	'label'       => esc_html__( 'General Corner Style', 'talemy' ),
	'description' => esc_html__( 'Apply to buttons and form elements.', 'talemy' ),
	'section'     => 'styling',
	'default'     => $defaults['corner_style'],
	'choices'     => [
		''	    => esc_html__( 'Default', 'talemy' ),
		'round' => esc_html__( 'Round Corner', 'talemy' ),
		'sharp' => esc_html__( 'Sharp Corner', 'talemy' ),
	],
] );

/* Background ------------------------------------ */

new \Kirki\Field\Background( [
	'settings'  => 'body_bg',
	'label'     => esc_html__( 'Site Background', 'talemy' ),
	'section'   => 'background',
	'transport' => 'auto',
	'output'    => [['element' => 'body']],
] );

/* Banner ------------------------------------ */

new \Kirki\Field\Select( [
	'settings' => 'banner',
	'label'    => esc_html__( 'Global Banner', 'talemy' ),
	'section'  => 'global_banner',
	'default'  => '',
	'choices'  => talemy_get_option_page_banner_options(),
] );

new \Kirki\Field\Background( [
	'settings'  => 'banner_bg',
	'label'     => esc_html__( 'Background', 'talemy' ),
	'section'   => 'global_banner',
	'transport' => 'auto',
	'default'   => [
		'background-color' => '#41246d'
	],
	'output'    => [ [ 'element' => '.content-banner' ] ],
] );

new \Kirki\Field\Color( [
	'settings'  => 'banner_bg_overlay',
	'label'     => esc_html__( 'Background Overlay', 'talemy' ),
	'section'   => 'global_banner',
	'default'   => 'rgba(0,0,0,0.6)',
	'choices'   => [ 'alpha' => true ],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => [
				'.content-banner .banner-overlay',
			],
			'property' => 'background',
			'exclude'  => [ 'rgba(0,0,0,0.6)' ],
		],
	],
] );

/* Breadcrumbs ------------------------------------ */

new \Kirki\Field\Select( [
	'settings' => 'breadcrumbs_source',
	'label'    => esc_html__( 'Breadcrumbs Engine', 'talemy' ),
	'section'  => 'breadcrumbs',
	'default'  => '',
	'choices'  => [
		''         => esc_html__( 'Default', 'talemy' ),
		'bcnxt'    => esc_html__( 'Breadcrumb NavXT', 'talemy' ),
		'rankmath' => esc_html__( 'RankMath (must have activated in plugin)', 'talemy' ),
		'yoast'    => esc_html__( 'Yoast (must have activated in plugin)', 'talemy' ),
		'seopress' => esc_html__( 'SEOPress (must have activated in plugin)', 'talemy' ),
	],
] );

new \Kirki\Pro\Field\Divider(
	[
		'settings' => 'breadcrumbs_div1',
		'section'  => 'breadcrumbs',
	]
);

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'breadcrumbs_home_icon',
	'label'    => esc_html__( 'Use icon for home?', 'talemy' ),
	'section'  => 'breadcrumbs',
	'default'  => true,
] );

/* List Settings ------------------------------------ */

new \Kirki\Field\Checkbox_Toggle( [
    'settings' => 'grid_category',
    'label'    => esc_html__( 'Show Category', 'talemy' ),
    'section'  => 'list_style_grid',
    'default'  => 1,
] );

new \Kirki\Field\Multicheck( [
    'settings' => 'grid_meta_data',
    'label'    => esc_html__( 'Meta Data', 'talemy' ),
    'section'  => 'list_style_grid',
    'default'  => array( 'date', 'author', 'comment' ),
    'choices'  => array(
        'date'    => esc_html__( 'Date', 'talemy' ),
        'avatar'  => esc_html__( 'Avatar', 'talemy' ),
        'author'  => esc_html__( 'Author', 'talemy' ),
        'comment' => esc_html__( 'Comment Count', 'talemy' ),
    ),
] );

new \Kirki\Field\Checkbox_Toggle( [
    'settings' => 'grid_excerpt',
    'label'    => esc_html__( 'Show Excerpt', 'talemy' ),
    'section'  => 'list_style_grid',
    'default'  => 1,
] );

new \Kirki\Field\Number( [
    'settings' => 'grid_excerpt_limit',
    'label'    => esc_html__( 'Excerpt Length', 'talemy' ),
    'section'  => 'list_style_grid',
    'default'  => 80,
] );

// style 2

new \Kirki\Field\Checkbox_Toggle( [
    'settings' => 'list_category',
    'label'    => esc_html__( 'Show Category', 'talemy' ),
    'section'  => 'list_style_list',
    'default'  => 1,
] );

new \Kirki\Field\Multicheck( [
    'settings' => 'list_meta_data',
    'label'    => esc_html__( 'Meta Data', 'talemy' ),
    'section'  => 'list_style_list',
    'default'  => array( 'date', 'author' ),
    'choices'  => array(
        'date'    => esc_html__( 'Date', 'talemy' ),
        'avatar'  => esc_html__( 'Avatar', 'talemy' ),
        'author'  => esc_html__( 'Author', 'talemy' ),
        'comment' => esc_html__( 'Comment Count', 'talemy' ),
    ),
] );

new \Kirki\Field\Checkbox_Toggle( [
    'settings' => 'list_excerpt',
    'label'    => esc_html__( 'Show Excerpt', 'talemy' ),
    'section'  => 'list_style_list',
    'default'  => 1,
] );

new \Kirki\Field\Number( [
    'settings'    => 'list_excerpt_limit',
    'label'       => esc_html__( 'Excerpt Length', 'talemy' ),
    'description' => esc_html__( 'Number of characters.', 'talemy' ),
    'section'     => 'list_style_list',
    'default'     => 120,
    'choices'     => array(
        'min'  => 0,
        'step' => 1,
    ),
] );

// style masonry

new \Kirki\Field\Checkbox_Toggle( [
    'settings' => 'masonry_category',
    'label'    => esc_html__( 'Show Category', 'talemy' ),
    'section'  => 'list_style_masonry',
    'default'  => 1,
] );

new \Kirki\Field\Multicheck( [
    'settings' => 'masonry_meta_data',
    'label'    => esc_html__( 'Meta Data', 'talemy' ),
    'section'  => 'list_style_masonry',
    'default'  => array( 'date', 'author', 'share' ),
    'choices'  => array(
        'date'   => esc_html__( 'Date', 'talemy' ),
        'avatar' => esc_html__( 'Avatar', 'talemy' ),
        'author' => esc_html__( 'Author', 'talemy' ),
    ),
] );

new \Kirki\Field\Checkbox_Toggle( [
    'settings' => 'masonry_excerpt',
    'label'    => esc_html__( 'Show Excerpt', 'talemy' ),
    'section'  => 'list_style_masonry',
    'default'  => 1,
] );

new \Kirki\Field\Number( [
    'settings'    => 'masonry_excerpt_limit',
    'label'       => esc_html__( 'Excerpt Length', 'talemy' ),
    'description' => esc_html__( 'Number of words.', 'talemy' ),
    'section'     => 'list_style_masonry',
    'default'     => 80,
    'choices'     => array(
        'min'  => 0,
        'step' => 1,
    ),
] );

/* Misc ------------------------------------ */

new \Kirki\Field\Select( [
	'settings' => 'page_loader',
	'label'    => esc_html__( 'Page Loader Style', 'talemy' ),
	'section'  => 'misc',
	'default'  => $defaults['page_loader'],
	'choices'  => [
		'none'        => esc_html__( 'No Loader', 'talemy' ),
		'line'        => esc_html__( 'Line', 'talemy' ),
		'circle'      => esc_html__( 'Circle', 'talemy' ),
		'pulse'       => esc_html__( 'Pulse', 'talemy' ),
		'square-spin' => esc_html__( 'Square Spin', 'talemy' ),
		'wave'        => esc_html__( 'Wave', 'talemy' ),
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'page_loading_bg',
	'label'     => esc_html__( 'Loading Screen Color', 'talemy' ),
	'section'   => 'misc',
	'transport' => 'auto',
	'default'   => '#FFFFFF',
	'output'    => [
		[
			'element'  => ['.site-overlay'],
			'property' => 'background',
			'exclude'  => ['#FFFFFF'],
		],
	],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'sticky_sidebar',
	'label'    => esc_html__( 'Sticky Sidebar', 'talemy' ),
	'section'  => 'misc',
	'default'  => $defaults['sticky_sidebar'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'ajax_search_form',
	'label'    => esc_html__( 'Enable AJAX Search', 'talemy' ),
	'section'  => 'misc',
	'default'  => $defaults['ajax_search_form'],
] );

new \Kirki\Field\Slider( [
	'settings'    => 'ajax_search_results_limit',
	'label'       => esc_html__( 'Number of Search Results', 'talemy' ),
	'section'     => 'misc',
	'default'     => $defaults['ajax_search_results_limit'],
	'choices'     => [
		'min'  => 1,
		'max'  => 50,
		'step' => 1,
	],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'disable_megamenu',
	'label'    => esc_html__( 'Disable Mega Menu', 'talemy' ),
	'section'  => 'misc',
	'default'  => $defaults['disable_megamenu'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'hide_sidebar_on_xs',
	'label'    => esc_html__( 'Hide Sidebar On Small Screen', 'talemy' ),
	'section'  => 'misc',
	'default'  => $defaults['hide_sidebar_on_xs'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'scroll_top',
	'label'    => esc_html__( 'Show Scroll Top', 'talemy' ),
	'section'  => 'misc',
	'default'  => $defaults['scroll_top'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'loop_thumb_placeholder',
	'label'    => esc_html__( 'Show Thumb Placeholder', 'talemy' ),
	'section'  => 'misc',
	'default'  => $defaults['loop_thumb_placeholder'],
] );

new \Kirki\Field\Text( [
	'settings'    => 'loop_date_format',
	'label'       => esc_html__( 'List Date Format', 'talemy' ),
	'description' => '<a href="https://codex.wordpress.org/Formatting_Date_and_Time" target="_blank">' . esc_html__( 'Documentation on date and time formatting', 'talemy' ) . '</a>',
	'section'     => 'misc',
	'default'     => $defaults['loop_date_format'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings'        => 'theme_login',
	'label'           => esc_html__( 'Enable Theme Login', 'talemy' ),
	'section'         => 'misc',
	'default'         => $defaults['theme_login'],
	'active_callback' => [
		[
			'setting'  => 'nav_login',
			'operator' => '==',
			'value'    => true,
		],
	],
] );

new \Kirki\Field\Select( [
	'settings'        => 'custom_login_page',
	'label'           => esc_html__( 'Custom Login Page', 'talemy' ),
	'section'         => 'misc',
	'choices'         => talemy_get_option_pages(),
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'theme_login',
			'operator' => '==',
			'value'    => false,
		],
	],
] );

if ( function_exists( 'sf_get_share_networks' ) ) {

    new \Kirki\Section( 'share_networks', [
        'title' => esc_html__( 'Share Networks', 'talemy' ),
		'panel' => 'global',
    ] );

	new \Kirki\Field\Sortable( [
		'settings' => 'share_buttons',
		'label'    => esc_html__( 'Share Buttons', 'talemy' ),
		'section'  => 'share_networks',
		'default'  => ['facebook', 'twitter', 'pinterest'],
		'choices'  => sf_get_share_networks(),
		'tooltip'  => esc_html__( 'Show or hide an item by clicking the eye icon. Drag and drop the items to sort the display order.', 'talemy' ),
	] );

	new \Kirki\Field\Text( [
		'settings'    => 'social_twitter_at',
		'label'       => 'Twitter @',
		'description' => esc_html__( 'Used by Twitter Share link', 'talemy' ),
		'section'     => 'share_networks',
		'default'     => '',
	] );
}