<?php

$defaults = Talemy_Options::get_default_options();

new \Kirki\Section( 'footer', [
	'title'    => esc_html__( 'Footer', 'talemy' ),
	'priority' => 22,
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'footer_top',
	'label'    => esc_html__( 'Show Footer Top', 'talemy' ),
	'section'  => 'footer',
	'default'  => $defaults['footer_top'],
] );

new \Kirki\Field\Radio_Image( [
	'settings'        => 'footer_top_style',
	'label'           => esc_html__( 'Footer Top Style', 'talemy' ),
	'section'         => 'footer',
	'default'         => $defaults['footer_top_style'],
	'choices'         => [
		'1' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/ft1.jpg',
		'2' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/ft2.jpg',
		'3' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/ft3.jpg',
		'4' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/ft4.jpg',
		'5' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/ft5.jpg',
		'6' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/ft6.jpg',
	],
	'active_callback' => [
		[
			'setting'  => 'footer_top',
			'operator' => '==',
			'value'    => 1,
		],
	],
] );

new \Kirki\Field\Radio_Image( [
	'settings' => 'footer_bottom_style',
	'label'    => esc_html__( 'Footer Bottom Style', 'talemy' ),
	'section'  => 'footer',
	'default'  => $defaults['footer_bottom_style'],
	'choices'  => [
		'1' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/fb1.jpg',
		'2' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/fb2.jpg',
		'3' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/fb3.jpg',
		'4' => TALEMY_THEME_URI . 'includes/admin/assets/images/footer/fb4.jpg',
	],
] );

new \Kirki\Field\Textarea( [
	'settings'    => 'footer_copyright',
	'label'       => esc_html__( 'Footer Copyright Text', 'talemy' ),
	'description' => esc_html__( '%%year%% will be replaced with current year, e.g. 2018. %%sitename%% will be replaced with site title.', 'talemy' ),
	'section'     => 'footer',
	'default'     => $defaults['footer_copyright'],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'footer_heading_1',
	'label'    => esc_html__( 'Footer Styling', 'talemy' ),
	'section'  => 'footer',
] );

new \Kirki\Field\Background( [
	'settings'  => 'footer_bg',
	'label'     => esc_html__( 'Footer Background', 'talemy' ),
	'section'   => 'footer',
	'default'   => [ 'background-color' => '#222' ],
	'transport' => 'auto',
	'output'    => [ [ 'element' => '#footer' ] ],
] );

new \Kirki\Field\Select( [
	'settings' => 'footer_title_style',
	'label'    => esc_html__( 'Title Style', 'talemy' ),
	'section'  => 'footer',
	'default'  => $defaults['footer_title_style'],
	'choices'  => [
		''  => esc_html__( 'Default', 'talemy' ),
		'1' => esc_html__( 'Style 1', 'talemy' ),
		'2' => esc_html__( 'Style 2', 'talemy' ),
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'footer_title_color',
	'label'     => esc_html__( 'Title Color', 'talemy' ),
	'section'   => 'footer',
	'default'   => '#FFFFFF',
	'choices'   => [ 'alpha' => true ],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => '.footer-top .widget-title',
			'property' => 'color',
			'exclude'  => [ '#FFFFFF' ],
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'footer_text_color',
	'label'     => esc_html__( 'Text Color', 'talemy' ),
	'section'   => 'footer',
	'default'   => '#BABABA',
	'choices'   => [ 'alpha' => true ],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => '#footer',
			'property' => 'color',
			'exclude'  => [ '#BABABA' ],
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'footer_link_color',
	'label'     => esc_html__( 'Link Color', 'talemy' ),
	'section'   => 'footer',
	'alpha'     => true,
	'transport' => 'auto',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'default'   => [
		'default' => '#BABABA',
		'hover'   => '#f5b417',
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'#footer a',
				'#footer strong',
			],
			'property' => 'color',
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'#footer a:hover',
			],
			'property' => 'color',
		],
	],
] );

new \Kirki\Field\Number( [
	'settings'  => 'footer_top_border_width',
	'label'     => esc_html__( 'Top Border Width', 'talemy' ),
	'section'   => 'footer',
	'default'   => 0,
	'choices'   => [
		'min'  => 0,
		'max'  => 300,
		'step' => 1,
	],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => [
				'#footer',
			],
			'property' => 'border-top-width',
			'exclude'  => [ 0 ],
			'suffix'   => 'px',
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'footer_top_border_color',
	'label'     => esc_html__( 'Top Border Color', 'talemy' ),
	'section'   => 'footer',
	'default'   => '#e0e0e0',
	'choices'   => [ 'alpha' => true ],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => [
				'#footer',
			],
			'property' => 'border-top-color',
			'exclude'  => [ '#e0e0e0' ],
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'footer_border_color',
	'label'     => esc_html__( 'Border Color', 'talemy' ),
	'section'   => 'footer',
	'default'   => '#585858',
	'choices'   => [ 'alpha' => true ],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => [
				'#footer .selectric',
				'#footer .sf-input',
				'#footer input:not(.btn)',
				'#footer select',
			],
			'property' => 'border-color',
			'exclude'  => [ '#585858' ],
		],
		[
			'element'  => [
				'#footer .selectric .button',
			],
			'property' => 'color',
			'exclude'  => [ '#585858' ],
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'footer_divider_color',
	'label'     => esc_html__( 'Divider Color', 'talemy' ),
	'section'   => 'footer',
	'default'   => '#393939',
	'choices'   => [ 'alpha' => true ],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => [
				'.footer-top .top-widget-area',
				'.footer-top .bottom-widget-area',
			],
			'property' => 'border-color',
			'exclude'  => [ '#393939' ],
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'footer_heading_2',
	'label'    => esc_html__( 'Footer Top Styling', 'talemy' ),
	'section'  => 'footer',
] );

new \Kirki\Field\Background( [
	'settings'  => 'footer_top_bg',
	'label'     => esc_html__( 'Footer Top Background', 'talemy' ),
	'section'   => 'footer',
	'default'   => [ 'background-color' => '' ],
	'transport' => 'auto',
	'output'    => [ [ 'element' => '.footer-top' ] ],
] );

new \Kirki\Field\Color( [
	'settings'  => 'footer_top1_bg_color',
	'label'     => esc_html__( 'Column 1 Background', 'talemy' ),
	'section'   => 'footer',
	'default'   => '',
	'transport' => 'auto',
	'output'    => [
		[
			'element'     => [ '.footer-top .footer-1', '.footer-top .footer-1:before' ],
			'property'    => 'background-color',
			'media_query' => '@media (min-width:768px)',
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'footer_top2_bg_color',
	'label'     => esc_html__( 'Column 2 Background', 'talemy' ),
	'section'   => 'footer',
	'default'   => '',
	'transport' => 'auto',
	'output'    => [
		[
			'element'     => [ '.footer-top .footer-2' ],
			'property'    => 'background-color',
			'media_query' => '@media (min-width:768px)',
		],
	],
] );

new \Kirki\Pro\Field\Headline( [
	'settings' => 'footer_heading_3',
	'label'    => esc_html__( 'Footer Bottom Styling', 'talemy' ),
	'section'  => 'footer',
] );

new \Kirki\Field\Color( [
	'settings'  => 'footer_bottom_bg_color',
	'label'     => esc_html__( 'Footer Bottom Background', 'talemy' ),
	'section'   => 'footer',
	'default'   => '',
	'choices'   => [ 'alpha' => true ],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => '.footer-bottom',
			'property' => 'background-color',
		],
	],
] );

new \Kirki\Field\Color( [
	'settings'  => 'footer_bottom_text_color',
	'label'     => esc_html__( 'Footer Bottom Text Color', 'talemy' ),
	'section'   => 'footer',
	'default'   => '#bababa',
	'choices'   => [ 'alpha' => true ],
	'transport' => 'auto',
	'output'    => [
		[
			'element'  => [
				'#footer .footer-bottom',
				'#footer .footer-menu a',
				'#footer .footer-bottom .scroll-top',
			],
			'property' => 'color',
			'exclude'  => [ '#bababa' ],
		],
	],
] );

new \Kirki\Field\Multicolor( [
	'settings'  => 'footer_bottom_link_color',
	'label'     => esc_html__( 'Link Color', 'talemy' ),
	'section'   => 'footer',
	'alpha'     => true,
	'transport' => 'auto',
	'choices'   => [
		'default' => esc_html__( 'Default', 'talemy' ),
		'hover'   => esc_html__( 'Hover', 'talemy' ),
	],
	'default'   => [
		'default' => '#f5b417',
		'hover'   => '#ffffff',
	],
	'output'    => [
		[
			'choice'   => 'default',
			'element'  => [
				'#footer .footer-copyright a',
			],
			'property' => 'color',
		],
		[
			'choice'   => 'hover',
			'element'  => [
				'#footer .footer-menu a:hover',
				'#footer .footer-copyright a:hover',
				'#footer .footer-bottom .scroll-top:hover',
			],
			'property' => 'color',
		],
	],
] );