<?php

if ( ! defined( 'TRIBE_EVENTS_FILE' ) ) {
	return;
}

$defaults = Talemy_Options::get_default_options();

new \Kirki\Section( 'ec_page_banner', [
	'title' => esc_html__( 'Page Banner', 'talemy' ),
	'panel' => 'tribe_customizer',
] );

/* General ------------------------------------ */

new \Kirki\Field\Select( [
	'settings' => 'ec_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'ec_page_banner',
	'default'  => $defaults['ec_banner'],
	'choices'  => talemy_get_option_page_banner_options(),
] );

new \Kirki\Field\Image( [
	'settings'        => 'ec_banner_image',
	'label'           => esc_html__( 'Banner Image', 'talemy' ),
	'section'         => 'ec_page_banner',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'ec_banner',
			'operator' => '==',
			'value'    => '',
		],
	],
	'output'          => [
		[
			'element'  => [ '.tribe-events-page-template .content-banner' ],
			'property' => 'background-image',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'ec_banner_shortcode',
	'label'           => esc_html__( 'Banner Shortcode', 'talemy' ),
	'section'         => 'ec_page_banner',
	'active_callback' => [
		[
			'setting'  => 'ec_banner',
			'operator' => '==',
			'value'    => 'shortcode',
		],
	],
] );
