<?php

if ( ! class_exists( 'BuddyPress' ) ) {
	return;
}

$defaults = Talemy_Options::get_default_options();

new \Kirki\Section( 'buddypress', [
	'title'    => esc_html__( 'BuddyPress', 'talemy' ),
	'priority' => 31,
] );

new \Kirki\Field\Radio_Image( [
	'settings' => 'bp_layout',
	'label'    => esc_html__( 'Layout', 'talemy' ),
	'section'  => 'buddypress',
	'default'  => $defaults['bp_layout'],
	'choices'  => talemy_get_option_layouts(),
] );

new \Kirki\Field\Select( [
	'settings' => 'bp_sidebar',
	'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
	'section'  => 'buddypress',
	'default'  => $defaults['bp_sidebar'],
	'choices'  => talemy_get_option_sidebars( true ),
] );

new \Kirki\Field\Select( [
	'settings' => 'bp_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'buddypress',
	'default'  => $defaults['bp_banner'],
	'choices'  => talemy_get_option_page_banner_options(),
] );

new \Kirki\Field\Image( [
	'settings'        => 'bp_banner_image',
	'label'           => esc_html__( 'Banner Image', 'talemy' ),
	'section'         => 'buddypress',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'bp_banner',
			'operator' => '==',
			'value'    => '',
		],
	],
	'output'          => [
		[
			'element'  => [ '.content-banner' ],
			'property' => 'background-image',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'bp_banner_shortcode',
	'label'           => esc_html__( 'Banner Shortcode', 'talemy' ),
	'section'         => 'buddypress',
	'active_callback' => [
		[
			'setting'  => 'bp_banner',
			'operator' => '==',
			'value'    => 'shortcode',
		],
	],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'bp_nav_messages',
	'label'    => esc_html__( 'Show Nav Messages', 'talemy' ),
	'section'  => 'buddypress',
	'default'  => $defaults['bp_nav_messages'],
] );

new \Kirki\Field\Checkbox_Toggle( [
	'settings' => 'bp_nav_notifications',
	'label'    => esc_html__( 'Show Nav Notifications', 'talemy' ),
	'section'  => 'buddypress',
	'default'  => $defaults['bp_nav_notifications'],
] );