<?php

if ( ! class_exists( 'bbPress' ) ) {
	return;
}

$defaults = Talemy_Options::get_default_options();

new \Kirki\Section( 'bbpress', [
	'title'    => esc_html__( 'bbPress', 'talemy' ),
	'priority' => 31,
] );

new \Kirki\Field\Radio_Image( [
	'settings' => 'bbp_layout',
	'label'    => esc_html__( 'Layout', 'talemy' ),
	'section'  => 'bbpress',
	'default'  => $defaults['bbp_layout'],
	'choices'  => talemy_get_option_layouts(),
] );

new \Kirki\Field\Select( [
	'settings' => 'bbp_sidebar',
	'label'    => esc_html__( 'Default Sidebar', 'talemy' ),
	'section'  => 'bbpress',
	'default'  => $defaults['bbp_sidebar'],
	'choices'  => talemy_get_option_sidebars( true ),
] );

new \Kirki\Field\Select( [
	'settings' => 'bbp_banner',
	'label'    => esc_html__( 'Page Banner', 'talemy' ),
	'section'  => 'bbpress',
	'default'  => $defaults['bbp_banner'],
	'choices'  => talemy_get_option_page_banner_options(),
] );

new \Kirki\Field\Image( [
	'settings'        => 'bbp_banner_image',
	'label'           => esc_html__( 'Banner Image', 'talemy' ),
	'section'         => 'bbpress',
	'default'         => '',
	'active_callback' => [
		[
			'setting'  => 'bbp_banner',
			'operator' => '==',
			'value'    => '',
		],
	],
	'output'          => [
		[
			'element'  => ['.content-banner'],
			'property' => 'background-image',
		],
	],
] );

new \Kirki\Field\Text( [
	'settings'        => 'bbp_banner_shortcode',
	'label'           => esc_html__( 'Banner Shortcode', 'talemy' ),
	'section'         => 'bbpress',
	'active_callback' => [
		[
			'setting'  => 'bbp_banner',
			'operator' => '==',
			'value'    => 'shortcode',
		],
	],
] );