<?php

$defaults = Talemy_Options::get_default_options();

new \Kirki\Section( 'advanced', [
	'title'    => esc_html__( 'Advanced', 'talemy' ),
	'priority' => 29,
] );

new \Kirki\Field\Code( [
	'settings'    => 'header_code',
	'label'       => esc_html__( 'Header Code', 'talemy' ),
	'description' => sprintf( esc_html__( 'Add your before %s code here. e.g. Google Analytics', 'talemy' ), '&lt;/head&gt;' ),
	'section'     => 'advanced',
	'default'     => '',
	'choices'     => [
		'language' => 'html',
		'theme'    => 'monokai',
	],
] );

new \Kirki\Field\Code( [
	'settings'    => 'footer_code',
	'label'       => esc_html__( 'Footer Code', 'talemy' ),
	'description' => sprintf( esc_html__( 'Add your before %s code here.', 'talemy' ), '&lt;/body&gt;' ),
	'section'     => 'advanced',
	'default'     => '',
	'choices'     => [
		'language' => 'html',
		'theme'    => 'monokai',
	],
] );

new \Kirki\Field\Select( [
	'settings'    => 'dynamic_css_method',
	'label'       => esc_html__( 'Dynamic CSS Method', 'talemy' ),
	'description' => esc_html__( 'Choose "File" mode to output dynamically generated CSS to a file. Save your settings again if your style is not updated.', 'talemy' ),
	'section'     => 'advanced',
	'default'     => $defaults['dynamic_css_method'],
	'choices'     => [
		'inline' => esc_html__( 'Inline', 'talemy' ),
		'file'   => esc_html__( 'File', 'talemy' ),
	],
] );