<?php
/**
 * Block Gropus
 *
 * @since   1.2.8
 * @package Talemy/Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly

class Talemy_Block_Groups extends Talemy_Block {

    static $loop_dir = 'templates/learndash/loop-group/';
    static $category_name = 'ld_group_category';
    static $tag_name = 'ld_group_tag';

    /**
     * Constructor
     *
     * @param array  $atts
     */
    function __construct( $atts ) {
        parent::__construct( $atts );
        $this->block_id = 'Block_Groups';
        $this->set_tabs();
        $this->query = talemy_block_get_query( $this->atts, $this->tab_ids );
    }

    /**
     * Set tab_ids and html
     *
     * @return void
     */
    private function set_tabs() {
        $out = $tabs = '';

        if ( empty( $this->atts['tab_type'] ) ) {
            return;
        }

        if ( 'subcat' !== $this->atts['tab_type'] && ( empty( $this->atts['tab_categories'] ) && empty( $this->atts['tab_tags'] ) && empty( $this->atts['tab_authors'] ) ) ) {
            return;
        }

        if ( 'author' == $this->atts['tab_type'] ) {
            foreach ( $this->atts['tab_authors'] as $id ) {
                if ( count_user_posts( $id ) > 0 ) {
                    $author_name = get_the_author_meta( 'display_name', $id );
                    $tabs .= '<a class="tab-item" href="javascript:void(0)" data-tab-id="' . esc_attr( $id ) . '">' . esc_attr( $author_name ) . '</a>';
                    $this->tab_ids[] = $id;
                }
            }
        } else {
            $args = array( 'hide_empty' => 1 );

            if ( 'subcat' == $this->atts['tab_type'] ) {
                $args['taxonomy'] = self::$category_name;

                if ( ! empty( $this->atts['group_categories'] ) ) {
                    $args['child_of'] = is_array( $this->atts['group_categories'] ) ? $this->atts['group_categories'][0] : '';
                }
            }

            if ( 'cat' == $this->atts['tab_type'] ) {
                $args['taxonomy'] = self::$category_name;

                if ( ! empty( $this->atts['tab_categories'] ) ) {
                    $args['include'] = $this->atts['tab_categories'];
                }
            }

            if ( 'tag' == $this->atts['tab_type'] ) {
                $args['taxonomy'] = self::$tag_name;

                if ( ! empty( $this->atts['tab_tags'] ) ) {
                    $args['include'] = $this->atts['tab_tags'];
                }
            }

            if ( ! empty( $this->atts['tab_orderby'] ) ) {
                $args['orderby'] = $this->atts['tab_orderby'];
            }

            if ( ! empty( $this->atts['tab_order'] ) ) {
                $args['order'] = $this->atts['tab_order'];
            }

            $terms = get_terms( $args );
            if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                foreach ( $terms as $term ) {
                    $tabs .= '<a class="tab-item" href="javascript:void(0)" data-tab-id="' . esc_attr( $term->term_id ) . '">' . esc_attr( $term->name );
                    $tabs .= '</a>';
                    $this->tab_ids[] = $term->term_id;
                }
            }
        }

        if ( ! empty( $tabs ) ) {
            $out .= '<div class="block-nav">';
            $out .= '<div class="tabs-wrapper">';
            if ( $this->atts['tab_show_all'] ) {
                $out .= '<a class="tab-item" href="javascript:void(0)" data-tab-id="0">' . apply_filters( 'talemy_block_groups_tab_text_all', esc_html__( 'All', 'talemy' ) ) . '</a>';
            }
            $out .= $tabs;
            $out .= '</div>';
            $out .= '<div class="more-tabs">';
            $out .= '<a href="javascript:void(0)" class="more-tab"><span>' . apply_filters( 'talemy_block_groups_tab_text_more', esc_html__( 'More', 'talemy' ) ) . '</span><i class="ticon-angle-down"></i></a>';
            $out .= '<div class="tabs-dropdown"></div>';
            $out .= '</div></div>';
        }

        $this->tabs_html = $out;
    }

    /**
     * Get block content
     * @return string
     */
    public function get_content() {
        if ( $this->query->have_posts() ) {
            talemy_set_block_settings( $this->atts );

            echo '<div class="block-content">';
            echo '<div class="' . esc_attr( talemy_get_setting( 'list_class' ) ) . '">';

            while ( $this->query->have_posts() ) {
                $this->query->the_post();
                get_template_part( self::$loop_dir . $this->atts['list_style'] );
            }

            echo '</div>';
            echo '</div>';

            wp_reset_postdata();
        }
    }

    /**
     * Get preloaded content
     * @return string
     */
    public function get_preload_content() {
        if ( 'preload' !== $this->atts['preload_content'] || empty( $this->tab_ids ) ) {
            return;
        }

        echo '<div class="block-preload-content">';

        foreach ( $this->tab_ids as $tab_id ) {
            $query_args = $this->query->query;
            switch ( $this->atts['tab_type'] ) {
            case 'subcat':
            case 'cat':
                $query_args['tax_query'] = array(
                    array(
                        'taxonomy' => self::$category_name,
                        'terms' => $tab_id,
                    ),
                );
                break;
            case 'tag':
                $query_args['tax_query'] = array(
                    array(
                        'taxonomy' => self::$tag_name,
                        'terms' => $tab_id,
                    ),
                );
                break;
            case 'author':
                $query_args['author'] = $tab_id;
                break;
            }
            $query = new WP_Query( $query_args );

            if ( $query->have_posts() ) {
                talemy_set_block_settings( $this->atts );

                echo '<div class="block-content" data-content-id="' . esc_attr( $tab_id ) . '" data-max-pages="' . esc_attr( $query->max_num_pages - 1 ) . '">';
                echo '<div class="' . esc_attr( talemy_get_setting( 'list_class' ) ) . '">';

                while ( $query->have_posts() ) {
                    $query->the_post();
                    get_template_part( self::$loop_dir . $this->atts['list_style'] );
                }

                echo '</div>';
                echo '</div>';
            } else {
                echo '<div class="block-content" data-content-id="' . esc_attr( $tab_id ) . '">';
                echo '<p>' . apply_filters( 'talemy_block_courses_text_not_found', esc_html__( 'No courses to display.', 'talemy' ) ) . '</p>';
                echo '</div>';
            }

            wp_reset_postdata();
        }

        echo '</div>';
    }
}