<?php

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

function talemy_get_option_sidebars( $empty_option = false ) {
	global $wp_registered_sidebars, $talemy_option_sidebars;

	if ( ! empty( $talemy_option_sidebars ) ) {
		return $talemy_option_sidebars;
	}

	$sidebars = [];

	if ( $empty_option ) {
		$sidebars[''] = esc_html__( 'Default', 'talemy' );
	}

	if ( ! empty( $wp_registered_sidebars ) ) {
		foreach ( $wp_registered_sidebars as $sidebar ) {
			if ( 'footer-1' == $sidebar['id'] || 'footer-2' == $sidebar['id'] || 'footer-3' == $sidebar['id'] || 'footer-4' == $sidebar['id'] || 'footer-5' == $sidebar['id'] ) {
				continue;
			}
			$sidebars[$sidebar['id']] = $sidebar['name'];
		}
	} else {
		$sidebars['default-sidebar'] = esc_html__( 'Default Sidebar', 'talemy' );
	}
	$talemy_option_sidebars = $sidebars;

	return $sidebars;
}

function talemy_get_option_menus() {
	$menus   = get_terms( 'nav_menu', [ 'hide_empty' => false ] );
	$options = [ '' => esc_html__( 'Default', 'talemy' ) ];
	if ( $menus ) {
		foreach ( $menus as $menu ) {
			$options[$menu->term_id] = $menu->name;
		}
	}
	return $options;
}

function talemy_get_option_cats() {
	$cats       = get_categories( 'hide_empty=0' );
	$cats_array = [];
	foreach ( $cats as $cat ) {
		$cats_array[$cat->term_id] = wp_specialchars_decode( $cat->cat_name );
	}
	return $cats_array;
}

function talemy_get_cat_count() {
	$cats = get_categories( 'hide_empty=0' );
	return count( $cats );
}

function talemy_get_option_layouts() {
	return [
		'sidebar-right' => TALEMY_THEME_URI . 'includes/admin/assets/images/layout/l1.png',
		'sidebar-left'  => TALEMY_THEME_URI . 'includes/admin/assets/images/layout/l2.png',
		'full-width'    => TALEMY_THEME_URI . 'includes/admin/assets/images/layout/l3.png',
	];
}

function talemy_get_option_post_styles() {
	return [
		'1' => TALEMY_THEME_URI . 'includes/admin/assets/images/post/p1.png',
		'2' => TALEMY_THEME_URI . 'includes/admin/assets/images/post/p2.png',
	];
}

function talemy_get_option_post_layouts() {
	return [
		'sidebar-right' => TALEMY_THEME_URI . 'includes/admin/assets/images/layout/l1.png',
		'sidebar-left'  => TALEMY_THEME_URI . 'includes/admin/assets/images/layout/l2.png',
		'full-width'    => TALEMY_THEME_URI . 'includes/admin/assets/images/layout/l3.png',
		'thin-width'    => TALEMY_THEME_URI . 'includes/admin/assets/images/layout/l4.png',
	];
}

function talemy_get_option_list_styles() {
	return [
		'grid'    => esc_html__( 'Grid', 'talemy' ),
		'list'    => esc_html__( 'List', 'talemy' ),
		'masonry' => esc_html__( 'Masonry', 'talemy' ),
	];
}

function talemy_get_option_course_list_styles() {
	return [
		'grid'    => esc_html__( 'Grid 1', 'talemy' ),
		'grid2'   => esc_html__( 'Grid 2', 'talemy' ),
		'list'    => esc_html__( 'List', 'talemy' ),
		'masonry' => esc_html__( 'Masonry', 'talemy' ),
	];
}

function talemy_get_option_course_list_meta_data() {
	$meta_data_options = [];
	if ( 'lifterlms' === TALEMY_LMS_PLUGIN ) {
		$meta_data_options = [
			'level'    => esc_html__( 'Level', 'talemy' ),
			'duration' => esc_html__( 'Duration', 'talemy' ),
			'enrolled' => esc_html__( 'Students', 'talemy' ),
		];
	} else if ( 'learndash' === TALEMY_LMS_PLUGIN ) {
		$meta_data_options = [
			'level'    => esc_html__( 'Level', 'talemy' ),
			'language' => esc_html__( 'Language', 'talemy' ),
			'duration' => esc_html__( 'Duration', 'talemy' ),
			'enrolled' => esc_html__( 'Students', 'talemy' ),
		];
	}
	return $meta_data_options;
}

function talemy_get_option_header_styles() {
	return [
		'1' => esc_html__( 'Style 1', 'talemy' ),
		'2' => esc_html__( 'Style 2', 'talemy' ),
		'3' => esc_html__( 'Style 3', 'talemy' ),
		'4' => esc_html__( 'Style 4', 'talemy' ),
		'5' => esc_html__( 'Style 5', 'talemy' ),
		'6' => esc_html__( 'Style 6', 'talemy' ),
		'7' => esc_html__( 'Style 7', 'talemy' ),
		'8' => esc_html__( 'Style 8', 'talemy' ),
		'9' => esc_html__( 'Style 9', 'talemy' ),
	];
}

function talemy_get_option_page_banner_options() {
	return [
		''            => esc_html__( 'Default', 'talemy' ),
		'breadcrumbs' => esc_html__( 'Breadcrumbs', 'talemy' ),
		'shortcode'   => esc_html__( 'Shortcode', 'talemy' ),
		'disable'     => esc_html__( 'Disable', 'talemy' ),
	];
}

function talemy_get_option_page_banner_options_page() {
	return [
		'inherit'   => esc_html__( 'Default ( Global )', 'talemy' ),
		''          => esc_html__( 'Default', 'talemy' ),
		'shortcode' => esc_html__( 'Shortcode', 'talemy' ),
		'disable'   => esc_html__( 'Disable', 'talemy' ),
	];
}

function talemy_get_option_pagination_type() {
	return [
		'numeric' => esc_html__( 'Numeric', 'talemy' ),
		'more'    => esc_html__( 'Load More', 'talemy' ),
		'scroll'  => esc_html__( 'Infinite Scroll', 'talemy' ),
	];
}

function talemy_get_option_columns() {
	return [
		'1' => esc_html__( '1', 'talemy' ),
		'2' => esc_html__( '2', 'talemy' ),
		'3' => esc_html__( '3', 'talemy' ),
		'4' => esc_html__( '4', 'talemy' ),
		'5' => esc_html__( '5', 'talemy' ),
		'6' => esc_html__( '6', 'talemy' ),
	];
}

function talemy_get_option_tablet_columns() {
	return [
		'1' => esc_html__( '1', 'talemy' ),
		'2' => esc_html__( '2', 'talemy' ),
		'3' => esc_html__( '3', 'talemy' ),
		'4' => esc_html__( '4', 'talemy' ),
	];
}

function talemy_get_option_mobile_columns() {
	return [
		'1' => esc_html__( '1', 'talemy' ),
		'2' => esc_html__( '2', 'talemy' ),
		'3' => esc_html__( '3', 'talemy' ),
	];
}

function talemy_get_option_screens() {
	return [
		'desktop' => esc_html__( 'Desktop', 'talemy' ),
		'tablet'  => esc_html__( 'Tablet', 'talemy' ),
		'mobile'  => esc_html__( 'Mobile', 'talemy' ),
	];
}

function talemy_get_option_course_sections() {
	return [
		'overview'    => esc_html__( 'Overview', 'talemy' ),
		'curriculum'  => esc_html__( 'Curriculum', 'talemy' ),
		'instructors' => esc_html__( 'Instructors', 'talemy' ),
		'reviews'     => esc_html__( 'Reviews', 'talemy' ),
	];
}

function talemy_get_options_tab_sections() {
	return [
		'general' => [
			'label' => esc_html__( 'General', 'talemy' ),
		],
		'design'  => [
			'label' => esc_html__( 'Design', 'talemy' ),
		],
	];
}

/**
 * Get all image sizes
 * @return array
 */
function talemy_get_option_image_sizes() {
	global $_wp_additional_image_sizes, $talemy_option_image_sizes;

	if ( isset( $talemy_option_image_sizes ) ) {
		return $talemy_option_image_sizes;
	}

	$default_image_sizes = ['thumbnail', 'medium', 'medium_large', 'large'];

	$image_sizes = [];
	$options     = [];

	foreach ( $default_image_sizes as $size ) {
		$image_sizes[$size] = [
			'width'  => (int)get_option( $size . '_size_w' ),
			'height' => (int)get_option( $size . '_size_h' ),
			'crop'   => (bool)get_option( $size . '_crop' ),
		];
	}

	if ( $_wp_additional_image_sizes ) {
		$image_sizes = array_merge( $image_sizes, $_wp_additional_image_sizes );
	}

	foreach ( $image_sizes as $size_key => $size_attributes ) {
		$label = ucwords( str_replace( '_', ' ', $size_key ) );
		if ( is_array( $size_attributes ) ) {
			$label .= sprintf( ' - %d x %d', $size_attributes['width'], $size_attributes['height'] );
		}

		$options[$size_key] = $label;
	}

	$options['full']           = _x( 'Full', 'Image Size', 'talemy' );
	$talemy_option_image_sizes = $options;

	return $options;
}

/**
 * Get a list of events
 * @return array  post options
 */
function talemy_get_option_events() {
	$options = [];
	$events  = tribe_get_events( [
		'posts_per_page' => -1,
		'start_date'     => date( 'Y-m-d H:i:s' ),
	] );
	foreach ( $events as $event ) {
		$options[$event->ID] = strip_tags( $event->post_title ) . ' - ' . esc_html( tribe_format_date( $event->EventStartDate, false, 'm/d/Y' ) );
	}
	return $options;
}

/**
 * Get a list of pages
 * @return array  page options
 */
function talemy_get_option_pages() {
	$options = [ '' => esc_html__( 'Select', 'talemy' ) ];
	$pages   = get_pages();
	foreach ( $pages as $page ) {
		$options[$page->ID] = strip_tags( $page->post_title );
	}
	return $options;
}

/**
 * Get posts
 *
 * @param string|array $post_types
 * @return array
 */
function talemy_get_option_posts( $post_types = 'post' ) {
	$options = [];
	$posts   = get_posts( array(
		'post_type'      => $post_types,
		'post_status'    => 'publish',
		'posts_per_page' => -1,
	) );
	foreach ( $posts as $post ) {
		$options[ $post->ID ] = $post->post_title;
	}
	return $options;
}


/**
 * Get option terms
 *
 * @param string $type
 * @return array
 */
function talemy_get_option_terms( $taxonomy = 'category', $type = 'id' ) {
	$terms   = get_terms( 'hide_empty=0&taxonomy=' . $taxonomy );
	$options = [];
	if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
		foreach ( $terms as $term ) {
			$value           = 'slug' == $type ? $term->slug : $term->term_id;
			$options[$value] = wp_specialchars_decode( $term->name );
		}
	}
	return $options;
}
