<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

function talemy_theme_config() {
	return [
		'doc_url'   => 'https://themespirit.com/documentation/talemy/',
		'video_url' => 'https://www.youtube.com/watch?v=HIEQjHAa4Fs&list=PLQTu2PJqDRfuJKkWiNkocJPD77dTclsog'
	];
}
add_filter( 'sf_config_theme', 'talemy_theme_config' );

function talemy_config_theme_fonts() {
	return [
		[
			'family' => 'Poppins',
			'variants' => '300,regular,italic,500,600,600italic,700',
			'source' => 'Google'
		]
	];
}
add_filter( 'sf_config_theme_fonts', 'talemy_config_theme_fonts' );

function talemy_theme_plugins( $plugins = [] ) {
	$plugins = [
		array(
			'name'      => 'Spirit Framework',
			'slug'      => 'spirit-framework',
			'source'    => 'https://themespirit.s3.amazonaws.com/plugins/spirit-framework.zip',
			'required'  => true,
			'version'   => '1.2.12'
		),
		array(
			'name'      => 'Elementor',
			'slug'      => 'elementor',
			'required'  => true,
			'version'   => '3.5'
		),
		array(
			'name'      => 'LearnDash Custom Meta',
			'slug'      => 'ld-custom-meta',
			'source'    => 'premium',
			'required'  => false,
			'version'   => '1.0.4',
		),
		array(
			'name'      => 'LearnDash Course Reviews',
			'slug'      => 'ld-course-reviews',
			'source'    => 'premium',
			'required'  => false,
			'version'   => '1.1.4',
			'icon'		=> TALEMY_THEME_URI . 'assets/images/plugins/ld-course-reviews.png',
		),
		array(
			'name'      => 'Contact Form 7',
			'slug'      => 'contact-form-7',
			'required'  => false
		),
		array(
			'name'      => 'Slider Revolution',
			'slug'      => 'revslider',
			'source'    => 'premium',
			'required'  => false,
			'version'   => '6.7.15',
			'icon'		=> TALEMY_THEME_URI . 'assets/images/plugins/revslider.png',
		),
		array(
			'name'      => 'The Events Calendar',
			'slug'      => 'the-events-calendar',
			'required'  => false,
			'version'   => '6.0.0',
			'icon'		=> TALEMY_THEME_URI . 'assets/images/plugins/the-events-calendar.gif',
		),
		array(
			'name'      => 'Talemy Demo Data',
			'slug'      => 'talemy-demo-data',
			'source'    => 'premium',
			'required'  => false,
			'version'   => '1.1.3',
		),
		array(
			'name'      => 'WooCommerce',
			'slug'      => 'woocommerce',
			'required'  => false,
			'version'   => '8.0.0',
		),
		array(
			'name'      => 'WooCommerce Wishlist Plugin',
			'slug'      => 'ti-woocommerce-wishlist',
			'required'  => false,
			'icon'		=> TALEMY_THEME_URI . 'assets/images/plugins/ti-woocommerce-wishlist.gif'
		),
		array(
			'name'      => 'Mailchimp for WordPress',
			'slug'      => 'mailchimp-for-wp',
			'required'  => false
		),
		array(
			'name'      => 'Smash Balloon Social Photo Feed',
			'slug'      => 'instagram-feed',
			'required'  => false
		),
		array(
			'name'      => 'WP Video Popup',
			'slug'      => 'responsive-youtube-vimeo-popup',
			'required'  => false,
			'icon' 		=> TALEMY_THEME_URI . 'assets/images/plugins/responsive-youtube-vimeo-popup.jpeg'
		)
	];
	return $plugins;
}
add_filter( 'sf_config_plugins', 'talemy_theme_plugins' );

function talemy_envato_item_id( $product_id ) {
	return '23064542';
}
add_filter( 'sf_envato_item_id', 'talemy_envato_item_id' );

add_filter( "tgmpa_plugin_action_links", function( $action_links, $item_slug, $item, $context ) {
	if ( isset( $item['source'] ) && 'premium' === strtolower( $item['source'] ) && ! TGM_Plugin_Activation::$instance->is_plugin_installed( $item_slug ) ) {
		if ( ! talemy_is_product_registered() ) {
			return [
				'register' => '<a href="' . esc_url( TGM_Plugin_Activation::$instance->get_dashboard_url() ) . '">' . esc_html__( 'Register the theme', 'talemy' ) . '</a>'
			];
		}
	}
	return $action_links;
}, 10, 4 );