<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

class Talemy_Block_Editor {
    /**
	 * Hooks
	 */
	public static function init() {
        add_action( 'enqueue_block_editor_assets', array( __CLASS__, 'assets' ) );
    }

    /**
     * Enqueue block editor assets
     */
    public static function assets() {
        $suffix = !TALEMY_DEV_MODE ? '.min' : '';
		wp_register_style( 'talemy-block-editor', TALEMY_THEME_URI . 'assets/css/admin/block-editor'. $suffix . '.css', false, TALEMY_THEME_VERSION );
        wp_enqueue_style( 'talemy-block-editor' );
        wp_style_add_data( 'talemy-block-editor', 'rtl', 'replace' );
        wp_add_inline_style( 'talemy-block-editor', self::get_inline_css() );
    }

    /**
     * Block editor inline css
     *
     * @return void
     */
    public static function get_inline_css() {
        $css = '';
        $mods = get_theme_mods();
        $font_props = array( 'color', 'font-family', 'font-weight', 'font-style', 'line-height', 'text-transform' );
        
        if ( !empty( $mods['typo_body'] ) ) {
            $body_style = '';
            
            foreach ( $font_props as $prop ) {
                if ( !empty( $mods['typo_body'][ $prop ] ) ) {
                    $body_style .= $prop .':'. $mods['typo_body'][ $prop ] .';';
                }
            }
    
            if ( !empty( $body_style ) ) {
                $css .= '#wpwrap .editor-styles-wrapper {'. $body_style .'}';
            }
        }
    
        if ( !empty( $mods['typo_heading'] ) ) {
            $heading_style = '';
            foreach ( $font_props as $prop ) {
                if ( !empty( $mods['typo_heading'][ $prop ] ) ) {
                    $heading_style .= $prop .':'. $mods['typo_heading'][ $prop ] .';';
                }
            }
    
            if ( !empty( $heading_style ) ) {
                $css .= '.wp-block-heading h1, .wp-block-heading h2, .wp-block-heading h3, .wp-block-heading h4, .wp-block-heading h5, .wp-block-heading h6, #wpwrap .editor-post-title__block .editor-post-title__input {'. $heading_style .'}';
            }
        }

        if ( ! empty( $mods['primary_color'] ) ) {
            $css .= ':root{--theme-color-primary:'. $mods['primary_color'] .';}';
        }
    
        if ( ! empty( $mods['secondary_color'] ) ) {
            $css .= ':root{--theme-color-secondary:'. $mods['secondary_color'] .';}';
        }

        if ( ! empty( $mods['link_color'] ) ) {
            $css .= ':root{--theme-color-link:'. $mods['link_color'] .';}';
        }
    
        return $css;
    }
}

Talemy_Block_Editor::init();