<?php
/**
 * Admin
 *
 * @since   1.1.7
 * @package Talemy/Classes
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

class Talemy_Admin {

    /**
	 * Hooks
	 */
	public function __construct() {
        if ( defined( 'SF_FRAMEWORK_VERSION' ) ) {
            new SF_Admin();
        }
        $this->includes();
        $this->hooks();
    }

    /**
     * Include files
     */
    public function includes() {
        require_once( TALEMY_THEME_DIR . 'includes/admin/block-editor.php' );
        require_once( TALEMY_THEME_DIR . 'includes/admin/config.php' );
        require_once( TALEMY_THEME_DIR . 'includes/admin/plugins.php' );
        require_once( TALEMY_THEME_DIR . 'includes/admin/metabox.php' );
    }

    /**
     * Include files
     */
    public function hooks() {
        add_action( 'admin_notices', array( $this, 'admin_notices' ), 999 );
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ), 20 );
        add_action( 'after_switch_theme', array( $this, 'setup_theme' ) );

        // remove wp video popup ad admin notice
        if ( function_exists( 'wp_video_popup_pro_ad' ) ) {
            remove_action( 'admin_notices', 'wp_video_popup_pro_ad' );
        }
    }

    /**
     * Display admin notice if the required plugins are not active
     */
    public function admin_notices() {
        if ( isset( $_GET['page'] ) && $_GET['page'] == 'tgmpa-install-plugins' ) {
            return;
        }

        $action = '';
        $plugin_slug = 'spirit-framework';
        $plugin_file = 'spirit-framework/spirit-framework.php';
        $plugin_version = '1.2.12';

        if ( defined( 'SF_FRAMEWORK_VERSION' ) ) {
            // check if plugin require an update
            if ( version_compare( SF_FRAMEWORK_VERSION, $plugin_version, '<' ) ) {
                $action = 'update';
            }
        } else {
            if ( ! function_exists( 'get_plugins' ) ) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }
            // check if plugin is installed
            $installed_plugins = get_plugins();
            if ( ! array_key_exists( $plugin_file, $installed_plugins ) ) {
                $action = 'install';
            // check if there's an update available
            } else if ( version_compare( $installed_plugins[ $plugin_file ]['Version'], $plugin_version, '<' ) ) {
                $action = 'update';
            // plugin needs activation
            } else {
                $action = 'activate';
            }
        }

        if ( ! empty( $action ) ) {
            $nonce_url = wp_nonce_url(
                add_query_arg(
                    array(
                        'plugin'           => urlencode( $plugin_slug ),
                        'tgmpa-' . $action => $action . '-plugin',
                    ),
                    TGM_Plugin_Activation::$instance->get_tgmpa_url()
                ),
                'tgmpa-' . $action,
                'tgmpa-nonce'
            );
            if ( 'install' === $action ) {
                $button_text = __( 'Install', 'talemy' );
            } elseif ( 'update' === $action ) {
                $button_text = __( 'Update', 'talemy' );
            } elseif ( 'activate' === $action ) {
                $button_text = __( 'Activate', 'talemy' );
            }
            ?>
            <div class="notice notice-error is-dismissible">
                <h3><?php esc_html_e( 'Installation/Activation/Update Of Required Plugins Needed', 'talemy' ); ?></h3>
                <p><?php esc_html_e( 'The following required plugin is currently inactive: Spirit Framework.', 'talemy' ); ?></p>
                <p><a href="<?php echo esc_url( $nonce_url ); ?>" class="button-primary"><?php printf( esc_html__( 'Go %s Plugin', 'talemy' ), $button_text ); ?></a></p>
            </div>
            <?php
        }
    }

    /**
     * Enqueue admin styles & scripts
     */
    public function admin_scripts() {
        wp_enqueue_style( 'ticon', TALEMY_THEME_URI . 'assets/css/ticon.css', array(), TALEMY_THEME_VERSION );
        wp_enqueue_style( 'font-awesome-5-all' );
    }

    public function setup_theme() {
        $theme_version = get_option( 'talemy_theme_version' );
        if ( $theme_version == false ) {
            update_option( 'talemy_theme_version', TALEMY_THEME_VERSION );
        } else {
            // do action on theme update
            update_option( 'talemy_theme_version', TALEMY_THEME_VERSION );
        }
    }
}

new Talemy_Admin();